/*
 * Decompiled with CFR 0.152.
 */
package org.raml.model;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.raml.emitter.Dumper;
import org.raml.emitter.MapFilter;
import org.raml.emitter.TraitsDumper;
import org.raml.emitter.TypeDumper;
import org.raml.emitter.UrlParameterFilter;
import org.raml.model.Action;
import org.raml.model.ActionType;
import org.raml.model.SecurityReference;
import org.raml.model.TemplateUse;
import org.raml.model.parameter.UriParameter;
import org.raml.parser.annotation.Key;
import org.raml.parser.annotation.Mapping;
import org.raml.parser.annotation.Parent;
import org.raml.parser.annotation.Scalar;
import org.raml.parser.annotation.Sequence;
import org.raml.parser.builder.TraitsExtraHandler;
import org.raml.parser.resolver.ResourceHandler;
import org.raml.parser.rule.SecurityReferenceSequenceRule;
import org.raml.parser.rule.UriParametersRule;

public class Resource {
    @Scalar
    private String displayName;
    @Sequence(rule=SecurityReferenceSequenceRule.class)
    private List<SecurityReference> securedBy = new ArrayList<SecurityReference>();
    @Scalar
    @Dumper(value=TypeDumper.class)
    private String type;
    @Sequence(extraHandler=TraitsExtraHandler.class)
    @Dumper(value=TraitsDumper.class)
    private List<String> is = new ArrayList<String>();
    @Scalar
    private String description;
    @Parent(property="uri")
    private String parentUri;
    @Key
    private String relativeUri;
    @Mapping
    @MapFilter(value=UrlParameterFilter.class)
    private Map<String, UriParameter> uriParameters = new LinkedHashMap<String, UriParameter>();
    private List<TemplateUse> isModel = new ArrayList<TemplateUse>();
    private List<TemplateUse> typeModel = new ArrayList<TemplateUse>();
    @Mapping(rule=UriParametersRule.class)
    private Map<String, List<UriParameter>> baseUriParameters = new LinkedHashMap<String, List<UriParameter>>();
    @Mapping(implicit=true)
    private Map<ActionType, Action> actions = new LinkedHashMap<ActionType, Action>();
    @Mapping(handler=ResourceHandler.class, implicit=true)
    private Map<String, Resource> resources = new LinkedHashMap<String, Resource>();

    public List<TemplateUse> getIsModel() {
        return this.isModel;
    }

    public void setIsModel(List<TemplateUse> isModel) {
        this.isModel = isModel;
    }

    public void setRelativeUri(String relativeUri) {
        this.relativeUri = relativeUri;
    }

    public String getParentUri() {
        return this.parentUri;
    }

    public void setParentUri(String parentUri) {
        this.parentUri = parentUri;
    }

    public void setUriParameters(Map<String, UriParameter> uriParameters) {
        this.uriParameters = uriParameters;
    }

    public Map<ActionType, Action> getActions() {
        return this.actions;
    }

    public void setActions(Map<ActionType, Action> actions) {
        this.actions = actions;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getRelativeUri() {
        return this.relativeUri;
    }

    public String getUri() {
        return this.parentUri + this.relativeUri;
    }

    public Action getAction(ActionType name) {
        return this.actions.get((Object)name);
    }

    public Action getAction(String name) {
        return this.actions.get((Object)ActionType.valueOf(name.toUpperCase()));
    }

    public Map<String, Resource> getResources() {
        return this.resources;
    }

    public void setResources(Map<String, Resource> resources) {
        this.resources = resources;
    }

    public Map<String, UriParameter> getUriParameters() {
        return this.uriParameters;
    }

    public List<String> getIs() {
        return this.is;
    }

    public void setIs(List<String> is) {
        this.is = is;
    }

    public String getType() {
        return this.type;
    }

    public TemplateUse getTypeModelT() {
        if (this.typeModel.isEmpty()) {
            return null;
        }
        return this.typeModel.iterator().next();
    }

    public List<TemplateUse> getTypeModel() {
        return this.typeModel;
    }

    public void setTypeModel(List<TemplateUse> typeModel) {
        this.typeModel = typeModel;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setTypeModelT(TemplateUse type) {
        this.typeModel.clear();
        if (type != null) {
            this.typeModel.add(type);
        }
    }

    public List<SecurityReference> getSecuredBy() {
        return this.securedBy;
    }

    public void setSecuredBy(List<SecurityReference> securedBy) {
        this.securedBy = securedBy;
    }

    public Map<String, List<UriParameter>> getBaseUriParameters() {
        return this.baseUriParameters;
    }

    public void setBaseUriParameters(Map<String, List<UriParameter>> baseUriParameters) {
        this.baseUriParameters = baseUriParameters;
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return "Resource{displayName='" + this.displayName + '\'' + ", uri='" + (this.parentUri != null ? this.getUri() : "-'") + '}';
    }

    public Resource getResource(String path) {
        for (Resource resource : this.resources.values()) {
            if (!path.startsWith(resource.getRelativeUri())) continue;
            if (path.length() == resource.getRelativeUri().length()) {
                return resource;
            }
            if (path.charAt(resource.getRelativeUri().length()) != '/') continue;
            return resource.getResource(path.substring(resource.getRelativeUri().length()));
        }
        return null;
    }
}

