/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.jaxrs.raml.jsonschema;

import com.mulesoft.jaxrs.raml.jsonschema.JSONObjectWrapper;
import com.mulesoft.jaxrs.raml.jsonschema.JsonFormatter;
import com.mulesoft.jaxrs.raml.jsonschema.JsonUtils;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class SchemaGenerator {
    public static void main(String[] args) {
        String in = "C:/workspaces/RAML-100apis/100apis/salesforce/examples";
        String out = "C:/workspaces/RAML-100apis/100apis/salesforce/schemes";
        new SchemaGenerator().processDir(in, out);
    }

    public void processDir(String src, String dst) {
        File[] srcFiles;
        File srcFolder = new File(src);
        if (!srcFolder.exists() || !srcFolder.isDirectory()) {
            return;
        }
        File dstFolder = new File(dst);
        if (dstFolder.exists() && !dstFolder.isDirectory()) {
            return;
        }
        dstFolder.mkdirs();
        for (File srcFile : srcFiles = srcFolder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String name) {
                return name.endsWith(".json");
            }
        })) {
            String name = srcFile.getName();
            if (name.endsWith("-example.json")) {
                name = name.substring(0, name.length() - "-example.json".length()) + "-schema.json";
            }
            File dstFile = new File(dstFolder, name);
            String srcPath = srcFile.getAbsolutePath();
            String dstPath = dstFile.getAbsolutePath();
            this.generateSchema(srcPath, dstPath);
        }
    }

    public void generateSchema(String in, String out) {
        File file = new File(in);
        if (!file.exists()) {
            return;
        }
        try {
            FileInputStream fis = new FileInputStream(file);
            DataInputStream dis = new DataInputStream(fis);
            int length = (int)file.length();
            byte[] bArr = new byte[length];
            dis.readFully(bArr);
            String content = new String(bArr, "UTF-8");
            dis.close();
            String sch = this.generateSchema(content);
            if (sch == null) {
                return;
            }
            if ((sch = JsonFormatter.format(sch)) == null) {
                return;
            }
            File oFile = new File(out);
            if (oFile.exists()) {
                oFile.delete();
            }
            oFile.createNewFile();
            FileOutputStream fos = new FileOutputStream(oFile);
            fos.write(sch.getBytes("UTF-8"));
            fos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String generateSchema(String content) {
        try {
            JSONObject obj;
            JSONObject sch = new JSONObject();
            sch.put("required", true);
            sch.putOpt("$schema", (Object)"http://json-schema.org/draft-03/schema");
            if (content.startsWith("{")) {
                obj = new JSONObject(content);
                sch.put("type", (Object)"object");
                this.pass(obj, sch);
            } else if (content.startsWith("[")) {
                obj = new JSONArray(content);
                sch.put("type", (Object)"array");
                this.passArray((JSONArray)obj, sch);
            } else {
                return null;
            }
            String result = JsonUtils.transformObjectToString(sch);
            return result;
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private void pass(JSONObject obj, JSONObject sch) {
        Iterator iter = obj.keys();
        while (iter.hasNext()) {
            Object o = iter.next();
            String propName = o.toString();
            try {
                Object value = obj.get(propName);
                this.registerProperty(propName, value, sch);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    private void registerProperty(String propName, Object value, JSONObject sch) throws JSONException {
        String type;
        JSONObject properties = null;
        try {
            properties = sch.getJSONObject("properties");
        }
        catch (JSONException e) {
            // empty catch block
        }
        if (properties == null) {
            properties = new JSONObject();
            sch.put("properties", (Object)properties);
        }
        JSONObject property = null;
        try {
            property = properties.getJSONObject(propName);
        }
        catch (JSONException e) {
            // empty catch block
        }
        if (property == null) {
            property = new JSONObject();
            properties.put(propName, (Object)property);
        }
        if ((type = this.detectType(value)) == null) {
            System.err.println("undetected type");
            System.err.println(value.toString());
            return;
        }
        property.put("type", (Object)type);
        property.put("required", false);
        if ("array".equals(type)) {
            this.passArray((JSONArray)value, property);
        } else if ("object".equals(type)) {
            if (value instanceof JSONObject) {
                this.pass((JSONObject)value, property);
            } else if (value.equals(JSONObject.NULL)) {
                // empty if block
            }
        }
    }

    private void passArray(JSONArray array, JSONObject property) throws JSONException {
        JSONArray items = null;
        try {
            items = property.getJSONArray("items");
        }
        catch (JSONException e) {
            // empty catch block
        }
        if (items == null) {
            items = new JSONArray();
            property.put("items", (Object)items);
        }
        int l = array.length();
        LinkedHashSet<JSONObjectWrapper> itemSet = new LinkedHashSet<JSONObjectWrapper>();
        for (int i = 0; i < l; ++i) {
            Object value = array.get(i);
            JSONObject item = new JSONObject();
            String type = this.detectType(value);
            if (type == null) {
                System.err.println("undetected type for array member");
                System.err.println(value.toString());
                continue;
            }
            item.put("type", (Object)type);
            if (value instanceof JSONObject) {
                this.pass((JSONObject)value, item);
            }
            JSONObjectWrapper wrapper = new JSONObjectWrapper(item);
            itemSet.add(wrapper);
        }
        for (JSONObjectWrapper wr : itemSet) {
            items.put((Object)wr.getObject());
        }
    }

    private String detectType(Object value) {
        if (value instanceof String) {
            return "string";
        }
        if (value instanceof Number) {
            return "number";
        }
        if (value instanceof Boolean) {
            return "boolean";
        }
        if (value instanceof JSONObject) {
            return "object";
        }
        if (value instanceof JSONArray) {
            return "array";
        }
        if (value == JSONObject.NULL) {
            return "object";
        }
        return null;
    }
}

