/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.jaxrs.raml.jsonschema;

import com.mulesoft.jaxrs.raml.jsonschema.ISchemaNode;
import com.mulesoft.jaxrs.raml.jsonschema.JsonUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class JsonSchemaNode
implements ISchemaNode {
    JsonSchemaNode parent;
    private String name;
    private JSONObject object;
    private LinkedHashMap<String, JsonSchemaNode> properties = null;
    private LinkedHashSet<JsonSchemaNode> arrayItems = null;
    private String type = null;
    private Boolean required = null;

    public JsonSchemaNode(String name, JSONObject object, JsonSchemaNode parent) {
        this.name = name != null ? name.trim() : "";
        this.object = object;
        this.parent = parent;
    }

    public JsonSchemaNode getParent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (this.name == null ? name == null : this.name.equals(name)) {
            return;
        }
        this.name = name;
        this.fireChanges();
    }

    public String getType() {
        if (this.type != null) {
            return this.type;
        }
        if (this.object.has("type")) {
            try {
                this.type = this.object.getString("type");
            }
            catch (JSONException jSONException) {}
        } else {
            this.type = "string";
        }
        return this.type;
    }

    public void setType(String type) {
        if (this.type == null ? type == null : this.type.equals(type)) {
            return;
        }
        this.setTypeSilent(type);
        this.fireChanges();
    }

    private void setTypeSilent(String type) {
        this.type = type;
        try {
            this.object.put("type", (Object)type);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public Collection<JsonSchemaNode> getChildren() {
        Collection<JsonSchemaNode> children = null;
        String type = this.getType();
        if ("array".equals(type)) {
            children = this.getArrayItems();
        } else if ("object".equals(type)) {
            children = this.getProperties();
        }
        return children;
    }

    private Collection<JsonSchemaNode> getArrayItems() {
        if (this.arrayItems != null) {
            return this.arrayItems;
        }
        this.arrayItems = new LinkedHashSet();
        this.reFillArrayItems();
        return this.arrayItems;
    }

    public Collection<JsonSchemaNode> getProperties() {
        if (this.properties != null) {
            return this.properties.values();
        }
        this.properties = new LinkedHashMap();
        this.reFillProperties();
        return this.properties.values();
    }

    public boolean isRequired() {
        if (this.required != null) {
            return this.required;
        }
        if (this.object.has("required")) {
            try {
                this.required = this.object.getBoolean("required");
            }
            catch (JSONException e) {
                this.required = false;
            }
        } else {
            this.required = false;
        }
        return this.required;
    }

    public void setRequired(boolean required) {
        if (this.required != null && required == this.required) {
            return;
        }
        this.setRequiredSilent(required);
        this.fireChanges();
    }

    private void setRequiredSilent(boolean required) {
        this.required = required;
        try {
            this.object.put("required", required);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void setProperty(JsonSchemaNode property) {
        JSONObject propertiesObject = null;
        try {
            propertiesObject = this.object.getJSONObject("properties");
        }
        catch (JSONException e) {
            // empty catch block
        }
        if (propertiesObject == null) {
            propertiesObject = new JSONObject();
            try {
                this.object.put("properties", (Object)propertiesObject);
            }
            catch (JSONException e) {
                // empty catch block
            }
        }
        try {
            propertiesObject.put(property.getName(), (Object)property.object);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        if (this.properties == null) {
            this.properties = new LinkedHashMap();
        }
        this.properties.put(property.getName(), property);
        this.fireChanges();
    }

    public void addArrayItem(JsonSchemaNode item) {
        try {
            Object itemsObject = this.object.get("items");
            if (itemsObject instanceof JSONArray) {
                JSONArray arr = (JSONArray)itemsObject;
                arr.put((Object)item.object);
            } else if (itemsObject instanceof JSONObject) {
                JSONObject itemJsonObj = (JSONObject)itemsObject;
                if (itemJsonObj.keys().hasNext()) {
                    JSONArray arr = new JSONArray();
                    arr.put((Object)itemJsonObj);
                    arr.put((Object)item.object);
                    this.object.put("items", (Object)arr);
                } else {
                    this.object.put("items", (Object)item.object);
                }
            } else {
                this.object.put("items", (Object)item.object);
            }
        }
        catch (JSONException e) {
            // empty catch block
        }
        if (this.arrayItems == null) {
            this.arrayItems = new LinkedHashSet();
        }
        this.arrayItems.add(item);
        try {
            this.object.put("items", (Object)item.object);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        this.fireChanges();
    }

    public void removeProperty(JsonSchemaNode property) {
        JSONObject propertiesObject = null;
        try {
            propertiesObject = this.object.getJSONObject("properties");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        if (propertiesObject == null) {
            return;
        }
        propertiesObject.remove(property.getName());
        if (this.properties != null) {
            this.properties.remove(property.getName());
        }
        this.fireChanges();
    }

    private void reFillProperties() {
        try {
            this.properties.clear();
            JSONObject propertiesObject = this.object.getJSONObject("properties");
            Iterator keys = propertiesObject.keys();
            while (keys.hasNext()) {
                Object key = keys.next();
                if (key == null) continue;
                String propName = key.toString();
                JSONObject propObj = propertiesObject.getJSONObject(propName);
                JsonSchemaNode propNode = new JsonSchemaNode(propName, propObj, this);
                this.properties.put(propName, propNode);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    private void reFillArrayItems() {
        try {
            this.arrayItems.clear();
            Object items = this.object.get("items");
            if (items instanceof JSONObject) {
                JSONObject itemObj = (JSONObject)items;
                JsonSchemaNode propNode = new JsonSchemaNode("", itemObj, this);
                this.arrayItems.add(propNode);
            } else if (items instanceof JSONArray) {
                JSONArray itemsArray = (JSONArray)items;
                int l = itemsArray.length();
                for (int i = 0; i < l; ++i) {
                    Object itemObject = itemsArray.get(i);
                    if (!(itemObject instanceof JSONObject)) continue;
                    JSONObject item = (JSONObject)itemObject;
                    JsonSchemaNode propNode = new JsonSchemaNode("", item, this);
                    this.arrayItems.add(propNode);
                }
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public String getFormattedStringValue() throws JSONException, IOException {
        String value = JsonUtils.transformObjectToStringAndFormat(this.object);
        return value;
    }

    public void addChildNode(JsonSchemaNode node) {
        if (this.type.equals("array")) {
            this.addArrayItem(node);
        } else if (this.type.equals("object")) {
            this.setProperty(node);
        }
    }

    public String toString() {
        String name_ = this.getName();
        String type_ = this.getType();
        boolean required_ = this.isRequired();
        StringBuilder bld = new StringBuilder(name_);
        bld.append(" (");
        bld.append("type=").append(type_);
        if (required_) {
            bld.append(", required=true");
        }
        bld.append(")");
        String result = bld.toString();
        return result;
    }

    private void fireChanges() {
    }

    public static boolean compare(JsonSchemaNode node1, JsonSchemaNode node2) {
        ArrayList<JsonSchemaNode> list1 = new ArrayList<JsonSchemaNode>();
        ArrayList<JsonSchemaNode> list2 = new ArrayList<JsonSchemaNode>();
        list1.add(node1);
        list2.add(node2);
        for (int i = 0; i < list1.size(); ++i) {
            JsonSchemaNode n2;
            JsonSchemaNode n1 = (JsonSchemaNode)list1.get(i);
            if (JsonSchemaNode.doCompare(n1, n2 = (JsonSchemaNode)list2.get(i), list1, list2)) continue;
            return false;
        }
        return true;
    }

    private static boolean doCompare(JsonSchemaNode node1, JsonSchemaNode node2, ArrayList<JsonSchemaNode> list1, ArrayList<JsonSchemaNode> list2) {
        Collection<JsonSchemaNode> items2;
        Collection<JsonSchemaNode> items1;
        Collection<JsonSchemaNode> props2;
        Collection<JsonSchemaNode> props1;
        if (node1 == null) {
            return node2 == null;
        }
        if (node2 == null) {
            return false;
        }
        if (node1.isRequired() != node2.isRequired()) {
            return false;
        }
        if (!node1.getType().equals(node2.getType())) {
            return false;
        }
        if (!node1.getName().equals(node2.getName())) {
            return false;
        }
        return !(node1.getType().toLowerCase().equals("object") ? !JsonSchemaNode.attachArrays(props1 = node1.getProperties(), props2 = node2.getProperties(), list1, list2) : node2.getType().toLowerCase().equals("array") && !JsonSchemaNode.attachArrays(items1 = node1.getArrayItems(), items2 = node2.getArrayItems(), list1, list2));
    }

    private static boolean attachArrays(Collection<JsonSchemaNode> arr1, Collection<JsonSchemaNode> arr2, ArrayList<JsonSchemaNode> list1, ArrayList<JsonSchemaNode> list2) {
        int size = arr1.size();
        if (size != arr2.size()) {
            return false;
        }
        Iterator<JsonSchemaNode> i1 = arr1.iterator();
        Iterator<JsonSchemaNode> i2 = arr2.iterator();
        for (int i = 0; i < size; ++i) {
            JsonSchemaNode prop1 = i1.next();
            JsonSchemaNode prop2 = i2.next();
            list1.add(prop1);
            list2.add(prop2);
        }
        return true;
    }

    public void update(String name, String type, boolean required) {
        boolean gotChange = false;
        gotChange = this.name == null ? (gotChange |= name != null) : (gotChange |= !this.name.equals(name));
        if (this.type == null) {
            gotChange |= type != null;
        } else {
            boolean bl = gotChange = !this.name.equals(type);
        }
        gotChange = this.required == null ? true : (gotChange |= this.required != required);
        this.name = name;
        this.setTypeSilent(type);
        this.setRequiredSilent(required);
        if (!this.type.equals("object")) {
            this.clearProperties();
        }
        if (!this.type.equals("array")) {
            this.clearArrayItems();
        }
        if (gotChange) {
            this.fireChanges();
        }
    }

    private void clearProperties() {
        this.object.remove("properties");
        this.properties = null;
    }

    private void clearArrayItems() {
        this.object.remove("items");
        this.arrayItems = null;
    }

    public class ArrayItemsNode
    implements ISchemaNode {
        @Override
        public Collection<? extends ISchemaNode> getChildren() {
            return JsonSchemaNode.this.getArrayItems();
        }

        public String toString() {
            return "items:";
        }
    }

    public class PropertiesNode
    implements ISchemaNode {
        @Override
        public Collection<? extends ISchemaNode> getChildren() {
            return JsonSchemaNode.this.getProperties();
        }

        public String toString() {
            return "properties:";
        }
    }

    public class RequiredNode
    implements ISchemaNode {
        @Override
        public Collection<? extends ISchemaNode> getChildren() {
            return null;
        }

        public String toString() {
            return "required: " + JsonSchemaNode.this.isRequired();
        }
    }

    public class TypeNode
    implements ISchemaNode {
        @Override
        public Collection<? extends ISchemaNode> getChildren() {
            return null;
        }

        public String toString() {
            return "type: " + JsonSchemaNode.this.getType();
        }
    }
}

