/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.jaxrs.raml.jsonschema;

import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class JsonFormatter {
    private static final String INDENT_INCREMENT = "  ";

    public static String formatExternal(String content) {
        String trim = content.trim();
        String canonic = null;
        try {
            JSONObject obj;
            if (trim.startsWith("{")) {
                obj = new JSONObject(content);
                StringWriter wr = new StringWriter();
                obj.write((Writer)wr);
                canonic = StringEscapeUtils.unescapeJavaScript((String)wr.toString());
            } else if (trim.startsWith("[")) {
                obj = new JSONArray(content);
                StringWriter wr = new StringWriter();
                obj.write((Writer)wr);
                canonic = StringEscapeUtils.unescapeJavaScript((String)wr.toString());
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        if (canonic == null) {
            return null;
        }
        String result = JsonFormatter.format(canonic);
        return result;
    }

    public static String format(String content) {
        if (content == null) {
            return null;
        }
        Map<Object, String> literalsMap = JsonFormatter.markLiterals(content);
        String str00 = literalsMap.get(1);
        String str01 = str00.replaceAll("\\s", "");
        String str02 = str01.replace("},{", "$$$seq2$$$");
        String str03 = str02.replace("},", "$$$seq1$$$");
        String str04 = str03.replace("],", "$$$seq3$$$");
        String str05 = str04.replaceAll("(\\{|\\[|\\,)", "$1\n");
        String str06 = str05.replaceAll("(\\}|\\])", "$1\n");
        String str07 = str06.replace("$$$seq1$$$", "},\n");
        String str08 = str07.replace("$$$seq3$$$", "],\n");
        String str09 = str08.replace("$$$seq2$$$", "} , {\n");
        String str10 = str09.replaceAll("([^\\s])(\\}|\\])", "$1\n$2");
        String str11 = str10.replace(":", " : ");
        String str12 = str11.replace(",\n", " ,\n");
        String str = JsonFormatter.insertLiterals(str12, literalsMap);
        String[] arr = str.split("\n");
        String indent = "";
        StringBuilder bld = new StringBuilder();
        for (String s : arr) {
            int l;
            if (s.startsWith("} , {")) {
                l = indent.length();
                if (l != 0) {
                    indent = indent.substring(0, l - INDENT_INCREMENT.length());
                }
                bld.append(indent);
                bld.append(s);
                bld.append("\n");
                indent = indent + INDENT_INCREMENT;
                continue;
            }
            if (s.endsWith("{")) {
                bld.append(indent);
                bld.append(s);
                bld.append("\n");
                indent = indent + INDENT_INCREMENT;
                continue;
            }
            if (s.endsWith("[")) {
                bld.append(indent);
                bld.append(s);
                bld.append("\n");
                indent = indent + INDENT_INCREMENT;
                continue;
            }
            if (s.endsWith("} ,")) {
                l = indent.length();
                if (l != 0) {
                    indent = indent.substring(0, l - INDENT_INCREMENT.length());
                }
                bld.append(indent);
                bld.append(s);
                bld.append("\n");
                continue;
            }
            if (s.endsWith("] ,")) {
                l = indent.length();
                if (l != 0) {
                    indent = indent.substring(0, l - INDENT_INCREMENT.length());
                }
                bld.append(indent);
                bld.append(s);
                bld.append("\n");
                continue;
            }
            if (s.endsWith(",")) {
                bld.append(indent);
                bld.append(s);
                bld.append("\n");
                continue;
            }
            if (s.endsWith("}")) {
                l = indent.length();
                if (l != 0) {
                    indent = indent.substring(0, l - INDENT_INCREMENT.length());
                }
                bld.append(indent);
                bld.append(s);
                bld.append("\n");
                continue;
            }
            if (s.endsWith("]")) {
                l = indent.length();
                if (l != 0) {
                    indent = indent.substring(0, l - INDENT_INCREMENT.length());
                }
                bld.append(indent);
                bld.append(s);
                bld.append("\n");
                continue;
            }
            bld.append(indent);
            bld.append(s);
            bld.append("\n");
        }
        String result = bld.toString().trim();
        return result;
    }

    private static String insertLiterals(String string, Map<Object, String> literalsMap) {
        String str = string;
        for (Map.Entry<Object, String> entry : literalsMap.entrySet()) {
            Object key = entry.getKey();
            if (!(key instanceof String)) continue;
            String replacement = key.toString();
            String literal = entry.getValue();
            str = str.replace(replacement, literal);
        }
        return str;
    }

    private static Map<Object, String> markLiterals(String content) {
        if (content == null) {
            return null;
        }
        String replacement = "$$$%%%replacement%%%$$$";
        HashMap<Object, String> map = new HashMap<Object, String>();
        int prev = 0;
        StringBuilder bld = new StringBuilder();
        int ind = content.indexOf("\"");
        while (ind >= 0) {
            bld.append(content.substring(prev, ind).replaceAll("\\s", ""));
            prev = content.indexOf("\"", ind + 1);
            if (prev < 0) {
                prev = ind;
                break;
            }
            String literal = content.substring(ind, ++prev);
            String replStr = replacement + ind + "%%%$$$";
            map.put(replStr, literal);
            bld.append(replStr);
            ind = content.indexOf("\"", prev);
        }
        bld.append(content.substring(prev, content.length()).replaceAll("\\s", ""));
        String result = bld.toString();
        map.put(1, result);
        map.put(0, content);
        return map;
    }
}

