/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.jaxrs.raml.jaxb;

import com.mulesoft.jaxrs.raml.annotation.model.IBasicModel;
import com.mulesoft.jaxrs.raml.annotation.model.IFieldModel;
import com.mulesoft.jaxrs.raml.annotation.model.IMember;
import com.mulesoft.jaxrs.raml.annotation.model.IMethodModel;
import com.mulesoft.jaxrs.raml.annotation.model.ITypeModel;
import com.mulesoft.jaxrs.raml.jaxb.JAXBAttributeProperty;
import com.mulesoft.jaxrs.raml.jaxb.JAXBElementProperty;
import com.mulesoft.jaxrs.raml.jaxb.JAXBModelElement;
import com.mulesoft.jaxrs.raml.jaxb.JAXBProperty;
import com.mulesoft.jaxrs.raml.jaxb.JAXBRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlValue;

public class JAXBType
extends JAXBModelElement {
    protected JAXBType superClass;
    protected ArrayList<JAXBProperty> properties = new ArrayList();

    public JAXBType(ITypeModel model, JAXBRegistry r) {
        super(model, r);
        IMethodModel[] methods = model.getMethods();
        String value = this.value(XmlAccessorType.class, "value");
        XmlAccessType type = XmlAccessType.PUBLIC_MEMBER;
        if (value != null) {
            type = this.extractType(type);
        }
        for (IMethodModel iMethodModel : methods) {
            boolean needToConsume = this.needToConsume(type, iMethodModel);
            if (!needToConsume) continue;
            boolean get = iMethodModel.getName().startsWith("get");
            boolean is = iMethodModel.getName().startsWith("is");
            if (!get && !is) continue;
            this.properties.add(this.createProperty(get ? iMethodModel.getName().substring(3) : iMethodModel.getName().substring(2), iMethodModel));
        }
        for (IMember iMember : model.getFields()) {
            if (iMember.isStatic()) continue;
            this.properties.add(this.createProperty(iMember.getName(), iMember));
        }
    }

    private boolean needToConsume(XmlAccessType type, IMember m) {
        boolean needToConsume = false;
        if (!m.isStatic()) {
            if (type == XmlAccessType.PUBLIC_MEMBER && m.isPublic()) {
                needToConsume = true;
            }
            if (type == XmlAccessType.PROPERTY == m instanceof IMethodModel) {
                needToConsume = true;
            }
            if (type == XmlAccessType.FIELD == m instanceof IFieldModel) {
                needToConsume = true;
            }
            if (m.hasAnnotation(XmlTransient.class.getSimpleName())) {
                needToConsume = false;
                return false;
            }
            boolean isElement = m.hasAnnotation(XmlElement.class.getSimpleName());
            boolean isAttribute = m.hasAnnotation(XmlAttribute.class.getSimpleName());
            boolean isValue = m.hasAnnotation(XmlValue.class.getSimpleName());
            if (isElement || isAttribute || isValue) {
                needToConsume = true;
            }
        }
        return needToConsume;
    }

    private XmlAccessType extractType(XmlAccessType type) {
        return null;
    }

    private JAXBProperty createProperty(String string, IBasicModel m) {
        boolean isElement = m.hasAnnotation(XmlElement.class.getSimpleName());
        boolean isAttribute = m.hasAnnotation(XmlAttribute.class.getSimpleName());
        boolean isValue = m.hasAnnotation(XmlValue.class.getSimpleName());
        if (isElement) {
            return new JAXBElementProperty(m, this.registry, string);
        }
        if (isAttribute) {
            return new JAXBAttributeProperty(m, this.registry, string);
        }
        if (isValue) {
            return new JAXBAttributeProperty(m, this.registry, string);
        }
        return new JAXBElementProperty(m, this.registry, string);
    }

    public String getXMLName() {
        return this.elementName != null ? this.elementName : this.originalType.getName().toLowerCase();
    }

    public HashMap<String, String> gatherNamespaces() {
        int n = 0;
        HashMap<String, String> map = new HashMap<String, String>();
        this.fillNamespaceMap(map, n);
        return map;
    }

    private int fillNamespaceMap(HashMap<String, String> map, int n) {
        for (JAXBProperty p : this.properties) {
            JAXBType type;
            if (p.namespace != null) {
                map.put(p.namespace, "n" + n++);
            }
            if ((type = p.getType()) == null) continue;
            n = type.fillNamespaceMap(map, n);
        }
        return n;
    }
}

