/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.jaxrs.raml.annotation.model.reflection;

import com.mulesoft.jaxrs.raml.annotation.model.IRamlConfig;
import com.mulesoft.jaxrs.raml.annotation.model.ITypeModel;
import com.mulesoft.jaxrs.raml.annotation.model.ResourceVisitor;
import com.mulesoft.jaxrs.raml.annotation.model.reflection.ReflectionType;
import com.mulesoft.jaxrs.raml.jsonschema.JsonFormatter;
import com.mulesoft.jaxrs.raml.jsonschema.JsonUtil;
import com.mulesoft.jaxrs.raml.jsonschema.SchemaGenerator;
import java.io.File;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class RuntimeResourceVisitor
extends ResourceVisitor {
    public RuntimeResourceVisitor(File outputFile, ClassLoader classLoader) {
        super(outputFile, classLoader);
    }

    public RuntimeResourceVisitor(File outputFile, ClassLoader classLoader, IRamlConfig preferencesConfig) {
        super(outputFile, classLoader);
        this.setPreferences(preferencesConfig);
    }

    protected void afterSchemaGen(ITypeModel t) {
        String generateXMLExampleJAXB = this.generateXMLExampleJAXB(t);
        if (generateXMLExampleJAXB != null) {
            File file = this.outputFile;
            File parentDir = file.getParentFile();
            File examplesDir = new File(parentDir, "examples");
            File schemaFile = new File(parentDir, "schemas");
            if (!examplesDir.exists()) {
                examplesDir.mkdir();
            }
            this.writeString(generateXMLExampleJAXB, new File(examplesDir, t.getName() + ".xml"));
            String jsonText = this.getProperJSONExampleFromXML(generateXMLExampleJAXB);
            this.writeString(jsonText, new File(examplesDir, t.getName().toLowerCase() + ".json"));
            String generatedSchema = jsonText != null ? new SchemaGenerator().generateSchema(jsonText) : null;
            String string = generatedSchema = generatedSchema != null ? JsonFormatter.format(generatedSchema) : null;
            if (generatedSchema != null) {
                String schemaName = t.getName().toLowerCase() + "-jsonschema";
                this.spec.getCoreRaml().addGlobalSchema(schemaName, generatedSchema, true, false);
                this.writeString(generatedSchema, new File(schemaFile, schemaName + ".json"));
            }
        }
    }

    protected String getProperJSONExampleFromXML(String generateXMLExampleJAXB) {
        String jsonText = JsonUtil.convertToJSON(generateXMLExampleJAXB, true);
        try {
            JSONObject c = new JSONObject(jsonText);
            JSONObject v = (JSONObject)c.get((String)c.keys().next());
            jsonText = v.toString();
        }
        catch (JSONException e) {
            throw new IllegalStateException(e);
        }
        jsonText = JsonFormatter.format(jsonText);
        return jsonText;
    }

    @Override
    protected void generateXMLSchema(ITypeModel t) {
        if (t instanceof ReflectionType) {
            Class element = (Class)((ReflectionType)t).getElement();
            this.generateXSDForClass(element);
        } else if (t.getFullyQualifiedName() != null && this.classLoader != null) {
            try {
                Class<?> element = this.classLoader.loadClass(t.getFullyQualifiedName());
                this.generateXSDForClass(element);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        this.afterSchemaGen(t);
    }

    @Override
    protected ResourceVisitor createResourceVisitor() {
        return new RuntimeResourceVisitor(this.outputFile, this.classLoader);
    }
}

