/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.jaxrs.raml.annotation.model.reflection;

import com.mulesoft.jaxrs.raml.annotation.model.IAnnotationModel;
import com.mulesoft.jaxrs.raml.annotation.model.IParameterModel;
import com.mulesoft.jaxrs.raml.annotation.model.reflection.AnnotationModel;
import com.mulesoft.jaxrs.raml.annotation.model.reflection.ReflectionType;
import java.lang.annotation.Annotation;

public class ReflectionParameter
implements IParameterModel {
    private static final String VALUE = "value";
    protected ReflectionType type;
    protected AnnotationModel[] model;

    public ReflectionParameter(ReflectionType type, AnnotationModel[] model) {
        this.type = type;
        this.model = model;
    }

    public ReflectionParameter(Class<?> cl, Annotation[] annotations) {
        this.type = new ReflectionType(cl);
        this.model = new AnnotationModel[annotations.length];
        int i = 0;
        for (Annotation a : annotations) {
            this.model[i++] = new AnnotationModel(a);
        }
    }

    @Override
    public String getDocumentation() {
        return "";
    }

    @Override
    public String getAnnotationValue(String annotation) {
        IAnnotationModel[] annotations;
        for (IAnnotationModel q : annotations = this.getAnnotations()) {
            if (!q.getName().equals(annotation)) continue;
            return q.getValue(VALUE);
        }
        return null;
    }

    @Override
    public String[] getAnnotationValues(String annotation) {
        IAnnotationModel[] annotations;
        for (IAnnotationModel q : annotations = this.getAnnotations()) {
            if (!q.getName().equals(annotation)) continue;
            return q.getValues(annotation);
        }
        return null;
    }

    @Override
    public boolean hasAnnotation(String name) {
        IAnnotationModel[] annotations;
        for (IAnnotationModel q : annotations = this.getAnnotations()) {
            if (!q.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IAnnotationModel getAnnotation(String name) {
        IAnnotationModel[] annotations;
        for (IAnnotationModel m : annotations = this.getAnnotations()) {
            if (!m.getName().equals(name)) continue;
            return m;
        }
        return null;
    }

    @Override
    public String getName() {
        String name = this.type.getName();
        return name;
    }

    @Override
    public String getType() {
        String name = this.type.getName();
        return name;
    }

    @Override
    public boolean required() {
        return ((Class)this.type.element).isPrimitive();
    }

    @Override
    public IAnnotationModel[] getAnnotations() {
        return this.model;
    }
}

