/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.jaxrs.raml.annotation.model;

import com.mulesoft.jaxrs.raml.annotation.model.FileUtil;
import com.mulesoft.jaxrs.raml.annotation.model.IAnnotationModel;
import com.mulesoft.jaxrs.raml.annotation.model.IDocInfo;
import com.mulesoft.jaxrs.raml.annotation.model.IMethodModel;
import com.mulesoft.jaxrs.raml.annotation.model.IParameterModel;
import com.mulesoft.jaxrs.raml.annotation.model.IRamlConfig;
import com.mulesoft.jaxrs.raml.annotation.model.ITypeModel;
import com.mulesoft.jaxrs.raml.annotation.model.RAMLModelHelper;
import com.mulesoft.jaxrs.raml.jaxb.ExampleGenerator;
import com.mulesoft.jaxrs.raml.jaxb.JAXBRegistry;
import com.mulesoft.jaxrs.raml.jaxb.JAXBType;
import com.mulesoft.jaxrs.raml.jaxb.XMLWriter;
import com.mulesoft.jaxrs.raml.jsonschema.JsonFormatter;
import com.mulesoft.jaxrs.raml.jsonschema.JsonUtil;
import com.mulesoft.jaxrs.raml.jsonschema.SchemaGenerator;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import org.raml.emitter.IRamlHierarchyTarget;
import org.raml.emitter.RamlEmitterV2;
import org.raml.model.Action;
import org.raml.model.ActionType;
import org.raml.model.MimeType;
import org.raml.model.ParamType;
import org.raml.model.Protocol;
import org.raml.model.Raml2;
import org.raml.model.Resource;
import org.raml.model.Response;
import org.raml.model.parameter.AbstractParam;
import org.raml.model.parameter.FormParameter;
import org.raml.model.parameter.Header;
import org.raml.model.parameter.QueryParameter;
import org.raml.model.parameter.UriParameter;

public abstract class ResourceVisitor {
    private static final String DEFAULT_RESPONSE = "200";
    private static final String API_RESPONSE = "ApiResponse";
    private static final String API_RESPONSES = "ApiResponses";
    private static final String CODE = "code";
    private static final String JSONSCHEMA = "-jsonschema";
    protected static final String XML_FILE_EXT = ".xml";
    private static final String JSON_FILE_EXT = ".json";
    protected static final String SCHEMAS_FOLDER = "schemas";
    protected static final String EXAMPLES_FOLDER = "examples";
    protected static final String EXAMPLES_PREFFIX = "examples/";
    private static final String JSON = "json";
    private static final String XML = "xml";
    protected JAXBRegistry regsistry = new JAXBRegistry();
    private static final String FORM = "form";
    private static final String DEFAULT_VALUE = "DefaultValue";
    private static final String PATH_PARAM = "PathParam";
    private static final String HEADER_PARAM = "HeaderParam";
    private static final String CONSUMES = "Consumes";
    private static final String PRODUCES = "Produces";
    private static final String QUERY_PARAM = "QueryParam";
    private static final String PATH = "Path";
    private static final String FORM_PARAM = "FormParam";
    private static final String XML_ROOT_ELEMENT = "XmlRootElement";
    private static final String MESSAGE = "message";
    protected RAMLModelHelper spec = new RAMLModelHelper();
    protected String[] classConsumes;
    protected String[] classProduces;
    protected HashSet<ITypeModel> consumedTypes = new HashSet();
    private String basePath;
    protected final File outputFile;
    protected final ClassLoader classLoader;
    private IRamlConfig config;

    public ResourceVisitor(File outputFile, ClassLoader classLoader) {
        this.outputFile = outputFile;
        this.classLoader = classLoader;
    }

    public void visit(ITypeModel t) {
        this.consumedTypes.add(t);
        this.classConsumes = t.getAnnotationValues(CONSUMES);
        this.classProduces = t.getAnnotationValues(PRODUCES);
        String annotationValue = t.getAnnotationValue(PATH);
        if (this.basePath != null) {
            if (annotationValue == null) {
                annotationValue = "";
            }
            annotationValue = this.basePath + annotationValue;
        }
        if (annotationValue != null) {
            IMethodModel[] methods;
            if (!annotationValue.endsWith("/")) {
                annotationValue = annotationValue + "/";
            }
            for (IMethodModel m : methods = t.getMethods()) {
                this.visit(m, annotationValue);
            }
        }
    }

    protected void generateXMLSchema(ITypeModel t) {
    }

    protected String generateXMLExampleJAXB(ITypeModel t) {
        JAXBRegistry rs = new JAXBRegistry();
        JAXBType jaxbModel = rs.getJAXBModel(t);
        if (jaxbModel != null) {
            XMLWriter writer = new XMLWriter();
            ExampleGenerator gen = new ExampleGenerator(writer);
            gen.generateXML(jaxbModel);
            return writer.toString();
        }
        return null;
    }

    public String getRaml() {
        this.spec.optimize();
        RamlEmitterV2 emmitter = new RamlEmitterV2();
        emmitter.setSingle(false);
        final StringHolder holder = new StringHolder();
        emmitter.dump(new IRamlHierarchyTarget(){

            @Override
            public void write(String path, String content) {
            }

            @Override
            public void writeRoot(String content) {
                holder.content = content;
            }
        }, this.spec.getCoreRaml());
        return holder.content;
    }

    private void visit(IMethodModel m, String path) {
        boolean hasPath = m.hasAnnotation(PATH);
        if (hasPath) {
            String localPath = m.getAnnotationValue(PATH);
            if (path.endsWith("/") && localPath.startsWith("/")) {
                localPath = localPath.substring(1);
            }
            path = path + localPath;
        }
        boolean isWs = hasPath;
        for (ActionType q : ActionType.values()) {
            boolean hasAnnotation = m.hasAnnotation(q.name());
            isWs |= hasAnnotation;
        }
        if (isWs) {
            ITypeModel bodyType;
            Resource res = new Resource();
            IDocInfo documentation = m.getBasicDocInfo();
            String text = documentation.getDocumentation();
            if (!"".equals(text)) {
                res.setDescription(text);
            }
            String returnName = null;
            String parameterName = null;
            ITypeModel returnedType = m.getReturnedType();
            if (returnedType != null) {
                if (returnedType.hasAnnotation(XML_ROOT_ELEMENT)) {
                    this.generateXMLSchema(returnedType);
                    returnName = returnedType.getName().toLowerCase();
                }
                if (hasPath && this.consumedTypes.add(returnedType)) {
                    ResourceVisitor resourceVisitor = this.createResourceVisitor();
                    resourceVisitor.consumedTypes.addAll(this.consumedTypes);
                    resourceVisitor.basePath = path;
                    resourceVisitor.spec = this.spec;
                    resourceVisitor.visit(returnedType);
                }
            }
            if ((bodyType = m.getBodyType()) != null && bodyType.hasAnnotation(XML_ROOT_ELEMENT)) {
                this.generateXMLSchema(bodyType);
                parameterName = bodyType.getName().toLowerCase();
            }
            if (path.endsWith("/")) {
                res.setRelativeUri(path.substring(0, path.length() - 1));
            } else {
                res.setRelativeUri(path);
            }
            for (ActionType q : ActionType.values()) {
                boolean hasAnnotation = m.hasAnnotation(q.name());
                if (!hasAnnotation) continue;
                this.addMethod(q, res, m, documentation, returnName, parameterName);
            }
            this.spec.addResource(res);
        }
    }

    protected abstract ResourceVisitor createResourceVisitor();

    private void addMethod(ActionType action, Resource res, IMethodModel m, IDocInfo documentation, String returnName, String parameterName) {
        String[] producesValue;
        IParameterModel[] text;
        AbstractParam value2;
        IAnnotationModel annotation;
        Action value = new Action();
        value.setType(action);
        res.getActions().put(action, value);
        IParameterModel[] parameters = m.getParameters();
        String[] responseCodes = new String[]{DEFAULT_RESPONSE};
        String[] responseDescriptions = new String[]{null};
        if (this.config != null) {
            responseCodes = new String[]{this.config.getResponseCode(action)};
        }
        if ((annotation = m.getAnnotation(API_RESPONSE)) != null) {
            responseCodes = new String[]{annotation.getValue(CODE)};
            responseDescriptions = new String[]{annotation.getValue(MESSAGE)};
        }
        if ((annotation = m.getAnnotation(API_RESPONSES)) != null) {
            Object[] subAnnotations = annotation.getSubAnnotations("value");
            if (subAnnotations == null) {
                subAnnotations = new IAnnotationModel[]{};
            }
            responseCodes = new String[subAnnotations.length];
            responseDescriptions = new String[subAnnotations.length];
            int a = 0;
            Object[] objectArray = subAnnotations;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                Object mq = objectArray[i];
                responseCodes[a++] = mq.getValue(CODE);
                responseDescriptions[a - 1] = mq.getValue(MESSAGE);
            }
        }
        for (IParameterModel pm : parameters) {
            if (!pm.hasAnnotation(QUERY_PARAM)) continue;
            String annotationValue = pm.getAnnotationValue(QUERY_PARAM);
            String type = pm.getType();
            QueryParameter value22 = new QueryParameter();
            this.configureParam(pm, value22);
            this.proceedType(type, value22, pm);
            String text2 = documentation.getDocumentation(pm.getName());
            if (!"".equals(text2)) {
                value22.setDescription(text2);
            }
            value.getQueryParameters().put(annotationValue, value22);
        }
        for (IParameterModel pm : parameters) {
            if (!pm.hasAnnotation(HEADER_PARAM)) continue;
            String annotationValue = pm.getAnnotationValue(HEADER_PARAM);
            value2 = new Header();
            this.configureParam(pm, value2);
            this.proceedType(pm.getType(), value2, pm);
            text = documentation.getDocumentation(pm.getName());
            if (!"".equals(text)) {
                value2.setDescription((String)text);
            }
            value.getHeaders().put(annotationValue, (Header)value2);
        }
        for (IParameterModel pm : parameters) {
            if (!pm.hasAnnotation(PATH_PARAM)) continue;
            String annotationValue = pm.getAnnotationValue(PATH_PARAM);
            value2 = new UriParameter();
            this.configureParam(pm, value2);
            text = documentation.getDocumentation(pm.getName());
            if (!"".equals(text)) {
                value2.setDescription((String)text);
            }
            this.proceedType(pm.getType(), value2, pm);
            res.getUriParameters().put(annotationValue, (UriParameter)value2);
        }
        String[] consumesValue = m.getAnnotationValues(CONSUMES);
        if (consumesValue == null) {
            consumesValue = this.classConsumes;
        }
        if (consumesValue != null) {
            for (String s : consumesValue) {
                s = this.sanitizeMediaType(s);
                MimeType bodyType = new MimeType();
                if (s.contains(XML)) {
                    bodyType.setSchema(parameterName);
                    if (parameterName != null) {
                        bodyType.setExample(EXAMPLES_PREFFIX + parameterName + XML_FILE_EXT);
                        bodyType.setExampleOrigin(EXAMPLES_PREFFIX + parameterName + XML_FILE_EXT);
                    }
                }
                if (s.contains(JSON) && parameterName != null) {
                    bodyType.setSchema(parameterName + JSONSCHEMA);
                    bodyType.setExample(EXAMPLES_PREFFIX + parameterName + JSON_FILE_EXT);
                    bodyType.setExampleOrigin(EXAMPLES_PREFFIX + parameterName + JSON_FILE_EXT);
                }
                bodyType.setType(s);
                if (s.contains(FORM)) {
                    for (IParameterModel pm : parameters) {
                        if (!pm.hasAnnotation(FORM_PARAM)) continue;
                        String annotationValue = pm.getAnnotationValue(FORM_PARAM);
                        FormParameter vl = new FormParameter();
                        this.configureParam(pm, vl);
                        String text3 = documentation.getDocumentation(pm.getName());
                        if (!"".equals(text3)) {
                            vl.setDescription(text3);
                        }
                        this.proceedType(pm.getType(), vl, pm);
                        ArrayList<FormParameter> arrayList = new ArrayList<FormParameter>();
                        arrayList.add(vl);
                        if (bodyType.getFormParameters() == null) {
                            bodyType.setFormParameters(new HashMap<String, List<FormParameter>>());
                        }
                        bodyType.getFormParameters().put(annotationValue, arrayList);
                    }
                }
                value.getBody().put(s, bodyType);
            }
        }
        if ((producesValue = m.getAnnotationValues(PRODUCES)) == null) {
            producesValue = this.classProduces;
        }
        int a = 0;
        for (String responseCode : responseCodes) {
            String text4;
            Response value23;
            if (producesValue != null) {
                value23 = new Response();
                text4 = documentation.getReturnInfo();
                String respDesc = responseDescriptions[a];
                if (respDesc != null && respDesc.length() > 0) {
                    text4 = respDesc;
                }
                ++a;
                if (!"".equals(text4)) {
                    value23.setDescription(text4);
                }
                for (String s : producesValue) {
                    s = this.sanitizeMediaType(s);
                    MimeType mimeType = new MimeType();
                    if (returnName != null) {
                        if (s.contains(XML)) {
                            mimeType.setSchema(returnName);
                            if (returnName != null) {
                                mimeType.setExample(EXAMPLES_PREFFIX + returnName + XML_FILE_EXT);
                                mimeType.setExampleOrigin(EXAMPLES_PREFFIX + returnName + XML_FILE_EXT);
                            }
                        }
                        if (s.contains(JSON) && returnName != null) {
                            mimeType.setSchema(returnName + JSONSCHEMA);
                            mimeType.setExample(EXAMPLES_PREFFIX + returnName + JSON_FILE_EXT);
                            mimeType.setExampleOrigin(EXAMPLES_PREFFIX + returnName + JSON_FILE_EXT);
                        }
                    }
                    mimeType.setType(s);
                    value23.getBody().put(s, mimeType);
                }
                value.getResponses().put(responseCode, value23);
                continue;
            }
            value23 = new Response();
            text4 = documentation.getReturnInfo();
            if (!"".equals(text4)) {
                value23.setDescription(text4);
            }
            value.getResponses().put(responseCode, value23);
        }
    }

    private void configureParam(IParameterModel model, AbstractParam param) {
        String max;
        String min;
        if (model.hasAnnotation("NotNull")) {
            param.setRequired(true);
        }
        if (model.hasAnnotation("Pattern")) {
            IAnnotationModel annotation = model.getAnnotation("Pattern");
            String pattern = annotation.getValue("regexp");
            param.setPattern(pattern);
        }
        if (model.hasAnnotation("Min")) {
            min = model.getAnnotationValue("Min");
            param.setMinimum(BigDecimal.valueOf(Double.parseDouble(min)));
        }
        if (model.hasAnnotation("DecimalMin")) {
            min = model.getAnnotationValue("DecimalMin");
            param.setMinimum(BigDecimal.valueOf(Double.parseDouble(min)));
        }
        if (model.hasAnnotation("Max")) {
            max = model.getAnnotationValue("Max");
            param.setMaximum(BigDecimal.valueOf(Double.parseDouble(max)));
        }
        if (model.hasAnnotation("DecimalMax")) {
            max = model.getAnnotationValue("DecimalMax");
            param.setMaximum(BigDecimal.valueOf(Double.parseDouble(max)));
        }
    }

    private String sanitizeMediaType(String s) {
        if ((s = s.toLowerCase()).contains(FORM)) {
            if (s.contains("urlencoded")) {
                s = "application/x-www-form-urlencoded";
            }
            if (s.contains("multipart")) {
                s = "multipart/form-data";
            }
        }
        if (s.contains("text")) {
            if (s.contains("html")) {
                s = "text/html";
            }
            if (s.contains("plain")) {
                s = "text/plain";
            }
        }
        if (s.contains("octet")) {
            return "application/octet-stream";
        }
        if (s.contains(XML)) {
            s = "application/xml";
        }
        if (s.contains(JSON)) {
            s = "application/json";
        }
        return s;
    }

    private void proceedType(String type, AbstractParam value2, IParameterModel param) {
        String annotationValue = param.getAnnotationValue(DEFAULT_VALUE);
        boolean hasDefault = false;
        if (annotationValue != null) {
            value2.setDefaultValue(annotationValue);
            hasDefault = true;
        }
        if (type.equals("I")) {
            value2.setType(ParamType.INTEGER);
            value2.setRequired(!hasDefault);
        }
        if (type.equals("D")) {
            value2.setType(ParamType.NUMBER);
            value2.setRequired(!hasDefault);
        }
        if (type.equals("Z")) {
            value2.setType(ParamType.BOOLEAN);
        }
        if (type.equals("int") || type.equals("long") || type.equals("short")) {
            value2.setType(ParamType.INTEGER);
            value2.setRequired(!hasDefault);
        }
        if (type.equals("float") || type.equals("double")) {
            value2.setType(ParamType.NUMBER);
            value2.setRequired(!hasDefault);
        }
        if (type.equals("boolean")) {
            value2.setType(ParamType.BOOLEAN);
            value2.setRequired(!hasDefault);
        }
        if (type.equals("QInteger;")) {
            value2.setType(ParamType.INTEGER);
        }
        if (type.equals("QDouble;")) {
            value2.setType(ParamType.NUMBER);
        }
        if (type.equals("QBoolean;")) {
            value2.setType(ParamType.BOOLEAN);
            value2.setRequired(!hasDefault);
        }
        if (type.equals("java.lang.Integer") || type.equals("java.lang.Long") || type.equals("java.lang.Short")) {
            value2.setType(ParamType.INTEGER);
        }
        if (type.equals("java.lang.Float") || type.equals("java.lang.Double")) {
            value2.setType(ParamType.NUMBER);
        }
        if (type.equals("java.lang.Boolean")) {
            value2.setType(ParamType.BOOLEAN);
        }
    }

    protected void generateXSDForClass(Class<?> element) {
        try {
            String name = element.getSimpleName().toLowerCase();
            String fileName = name + ".xsd";
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{element});
            CustomSchemaOutputResolver sor = new CustomSchemaOutputResolver(fileName);
            jaxbContext.generateSchema((SchemaOutputResolver)sor);
            File file = sor.getFile();
            String content = FileUtil.fileToString(file);
            this.generateExamle(file, content);
            this.spec.getCoreRaml().addGlobalSchema(name, content, false, false);
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void clear() {
        this.spec.coreRaml = new Raml2();
        this.spec.coreRaml.setBaseUri("http://example.com");
        this.spec.coreRaml.setTitle("Please type API title here");
        this.spec.coreRaml.setProtocols(Collections.singletonList(Protocol.HTTP));
    }

    public boolean isEmpty() {
        return this.spec.coreRaml.getResources().isEmpty();
    }

    protected void doGenerateAndSave(File schemaFile, File parentDir, File examplesDir, String dummyXml) {
        String jsonText = JsonUtil.convertToJSON(dummyXml, true);
        jsonText = JsonFormatter.format(jsonText);
        String fName = schemaFile.getName().replace(XML_FILE_EXT, JSONSCHEMA);
        fName = fName.replace(".xsd", JSONSCHEMA);
        String generatedSchema = jsonText != null ? new SchemaGenerator().generateSchema(jsonText) : null;
        String string = generatedSchema = generatedSchema != null ? JsonFormatter.format(generatedSchema) : null;
        if (generatedSchema != null) {
            this.spec.getCoreRaml().addGlobalSchema(fName, generatedSchema, true, false);
        }
        String name = schemaFile.getName();
        name = name.substring(0, name.lastIndexOf(46));
        File toSave = new File(examplesDir, name + XML_FILE_EXT);
        this.writeString(dummyXml, toSave);
        toSave = new File(examplesDir, name + JSON_FILE_EXT);
        if (jsonText != null) {
            this.writeString(jsonText, toSave);
        }
        File shemas = new File(parentDir, SCHEMAS_FOLDER);
        toSave = new File(shemas, fName + JSON_FILE_EXT);
        if (generatedSchema != null) {
            this.writeString(generatedSchema, toSave);
        }
    }

    protected void writeString(String generateDummyXmlFor, File toSave) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(toSave);
            fileOutputStream.write(generateDummyXmlFor.getBytes("UTF-8"));
            fileOutputStream.close();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    protected void generateExamle(File schemaFile, String content) {
    }

    public void setPreferences(IRamlConfig preferencesConfig) {
        this.config = preferencesConfig;
        if (preferencesConfig.getTitle() != null && preferencesConfig.getTitle().length() > 0) {
            this.spec.getCoreRaml().setTitle(preferencesConfig.getTitle());
        }
        if (preferencesConfig.getVersion() != null && preferencesConfig.getVersion().length() > 0) {
            this.spec.getCoreRaml().setVersion(preferencesConfig.getVersion());
        }
        if (preferencesConfig.getBaseUrl() != null && preferencesConfig.getBaseUrl().length() > 0) {
            this.spec.getCoreRaml().setBaseUri(preferencesConfig.getBaseUrl());
        }
        if (preferencesConfig.getProtocols() != null) {
            ArrayList<Protocol> protocols = new ArrayList<Protocol>(preferencesConfig.getProtocols());
            Collections.sort(protocols);
            this.spec.getCoreRaml().setProtocols(protocols);
        }
        this.spec.doSort = preferencesConfig.isSorted();
        this.spec.extractCommonParts = preferencesConfig.doFullTree();
    }

    class StringHolder {
        String content;

        StringHolder() {
        }
    }

    public class CustomSchemaOutputResolver
    extends SchemaOutputResolver {
        private final String fileName;
        private File file;

        public CustomSchemaOutputResolver(String fileName) {
            this.fileName = fileName;
        }

        public Result createOutput(String namespaceURI, String suggestedFileName) throws IOException {
            if (ResourceVisitor.this.outputFile != null) {
                File dir = new File(ResourceVisitor.this.outputFile.getParent(), ResourceVisitor.SCHEMAS_FOLDER);
                dir.mkdirs();
                this.file = new File(dir, this.fileName);
            } else {
                this.file = new File(this.fileName);
            }
            StreamResult result = new StreamResult(this.file);
            result.setSystemId(this.file.toURI().toURL().toString());
            return result;
        }

        public File getFile() {
            return this.file;
        }
    }
}

