/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.schema.validation.rules;

import java.nio.file.Path;
import java.nio.file.PathMatcher;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.avro.Schema;
import org.jetbrains.annotations.NotNull;
import org.radarbase.schema.Scope;
import org.radarbase.schema.specification.config.SchemaConfig;
import org.radarbase.schema.validation.ValidationContext;
import org.radarbase.schema.validation.ValidationHelper;
import org.radarbase.schema.validation.rules.AllValidator;
import org.radarbase.schema.validation.rules.AllValidatorKt;
import org.radarbase.schema.validation.rules.DirectValidatorKt;
import org.radarbase.schema.validation.rules.SchemaMetadata;
import org.radarbase.schema.validation.rules.SchemaMetadataRules;
import org.radarbase.schema.validation.rules.SchemaMetadataRulesKt;
import org.radarbase.schema.validation.rules.SchemaRules;
import org.radarbase.schema.validation.rules.Validator;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0012H\u0002J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0012H\u0002J\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00122\u0006\u0010\u0015\u001a\u00020\u0016R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0017"}, d2={"Lorg/radarbase/schema/validation/rules/SchemaMetadataRules;", "", "schemaRoot", "Ljava/nio/file/Path;", "config", "Lorg/radarbase/schema/specification/config/SchemaConfig;", "schemaRules", "Lorg/radarbase/schema/validation/rules/SchemaRules;", "(Ljava/nio/file/Path;Lorg/radarbase/schema/specification/config/SchemaConfig;Lorg/radarbase/schema/validation/rules/SchemaRules;)V", "isSchemaLocationCorrect", "Lorg/radarbase/schema/validation/rules/AllValidator;", "Lorg/radarbase/schema/validation/rules/SchemaMetadata;", "()Lorg/radarbase/schema/validation/rules/AllValidator;", "pathMatcher", "Ljava/nio/file/PathMatcher;", "getSchemaRules", "()Lorg/radarbase/schema/validation/rules/SchemaRules;", "isNameSchemaLocationCorrect", "Lorg/radarbase/schema/validation/rules/Validator;", "isNamespaceSchemaLocationCorrect", "isSchemaMetadataValid", "scopeSpecificValidation", "", "radar-schemas-core"})
public final class SchemaMetadataRules {
    @NotNull
    private final Path schemaRoot;
    @NotNull
    private final SchemaRules schemaRules;
    @NotNull
    private final PathMatcher pathMatcher;
    @NotNull
    private final AllValidator<SchemaMetadata> isSchemaLocationCorrect;

    public SchemaMetadataRules(@NotNull Path schemaRoot, @NotNull SchemaConfig config, @NotNull SchemaRules schemaRules) {
        Intrinsics.checkNotNullParameter((Object)schemaRoot, (String)"schemaRoot");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)schemaRules, (String)"schemaRules");
        this.schemaRoot = schemaRoot;
        this.schemaRules = schemaRules;
        this.pathMatcher = config.pathMatcher(this.schemaRoot);
        Validator[] validatorArray = new Validator[]{this.isNamespaceSchemaLocationCorrect(), this.isNameSchemaLocationCorrect()};
        this.isSchemaLocationCorrect = AllValidatorKt.all(validatorArray);
    }

    public /* synthetic */ SchemaMetadataRules(Path path, SchemaConfig schemaConfig, SchemaRules schemaRules, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            schemaRules = new SchemaRules(null, 1, null);
        }
        this(path, schemaConfig, schemaRules);
    }

    @NotNull
    public final SchemaRules getSchemaRules() {
        return this.schemaRules;
    }

    @NotNull
    public final AllValidator<SchemaMetadata> isSchemaLocationCorrect() {
        return this.isSchemaLocationCorrect;
    }

    @NotNull
    public final Validator<SchemaMetadata> isSchemaMetadataValid(boolean scopeSpecificValidation) {
        return DirectValidatorKt.Validator((Function2)new Function2<ValidationContext, SchemaMetadata, Unit>(this, scopeSpecificValidation){
            final /* synthetic */ SchemaMetadataRules this$0;
            final /* synthetic */ boolean $scopeSpecificValidation;
            {
                this.this$0 = $receiver;
                this.$scopeSpecificValidation = $scopeSpecificValidation;
                super(2);
            }

            public final void invoke(@NotNull ValidationContext $this$Validator, @NotNull SchemaMetadata metadata) {
                Intrinsics.checkNotNullParameter((Object)$this$Validator, (String)"$this$Validator");
                Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
                if (!SchemaMetadataRules.access$getPathMatcher$p(this.this$0).matches(metadata.getPath())) {
                    return;
                }
                $this$Validator.launchValidation(this.this$0.isSchemaLocationCorrect(), metadata);
                Validator<Schema> ruleset = metadata.getSchema().getType() == Schema.Type.ENUM ? this.this$0.getSchemaRules().isEnumValid() : (!this.$scopeSpecificValidation ? this.this$0.getSchemaRules().isRecordValid() : (metadata.getScope() == Scope.ACTIVE ? this.this$0.getSchemaRules().isActiveSourceValid() : (metadata.getScope() == Scope.MONITOR ? this.this$0.getSchemaRules().isMonitorSourceValid() : (metadata.getScope() == Scope.PASSIVE ? this.this$0.getSchemaRules().isPassiveSourceValid() : this.this$0.getSchemaRules().isRecordValid()))));
                $this$Validator.launchValidation(ruleset, metadata.getSchema());
            }
        });
    }

    private final Validator<SchemaMetadata> isNamespaceSchemaLocationCorrect() {
        return DirectValidatorKt.Validator((Function2)new Function2<ValidationContext, SchemaMetadata, Unit>(this){
            final /* synthetic */ SchemaMetadataRules this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull ValidationContext $this$Validator, @NotNull SchemaMetadata metadata) {
                Intrinsics.checkNotNullParameter((Object)$this$Validator, (String)"$this$Validator");
                Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
                try {
                    String expected = ValidationHelper.INSTANCE.getNamespace(SchemaMetadataRules.access$getSchemaRoot$p(this.this$0), metadata.getPath(), metadata.getScope());
                    String namespace = metadata.getSchema().getNamespace();
                    if (!StringsKt.equals((String)expected, (String)namespace, (boolean)true)) {
                        SchemaMetadataRulesKt.raise($this$Validator, metadata, "Namespace cannot be null and must fully lowercase dot separated without numeric. In this case the expected value is \"" + expected + "\".");
                    }
                }
                catch (IllegalArgumentException ex) {
                    $this$Validator.raise("Path " + metadata.getPath() + " is not part of root " + SchemaMetadataRules.access$getSchemaRoot$p(this.this$0), ex);
                }
            }
        });
    }

    private final Validator<SchemaMetadata> isNameSchemaLocationCorrect() {
        return DirectValidatorKt.Validator(isNameSchemaLocationCorrect.1.INSTANCE);
    }

    public static final /* synthetic */ PathMatcher access$getPathMatcher$p(SchemaMetadataRules $this) {
        return $this.pathMatcher;
    }

    public static final /* synthetic */ Path access$getSchemaRoot$p(SchemaMetadataRules $this) {
        return $this.schemaRoot;
    }
}

