/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.schema.specification.stream;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.avro.generic.GenericRecord;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.radarbase.config.AvroTopicConfig;
import org.radarbase.config.OpenConfig;
import org.radarbase.schema.SchemaCatalogue;
import org.radarbase.schema.specification.DataTopic;
import org.radarbase.schema.util.SchemaUtils;
import org.radarbase.stream.TimeWindowMetadata;
import org.radarbase.topic.AvroTopic;
import org.radarcns.kafka.AggregateKey;
import org.radarcns.kafka.ObservationKey;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@OpenConfig
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u001f\u001a\u00020 2\u0014\u0010!\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010#0\"2\u0006\u0010$\u001a\u00020\u0019H\u0014J\u0010\u0010%\u001a\u00020 2\u0006\u0010&\u001a\u00020\u0005H\u0013J\u001e\u0010'\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030(0\u000b2\u0006\u0010)\u001a\u00020*H\u0017R$\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001e\u0010\u000e\u001a\u0004\u0018\u00010\u00058VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R \u0010\u0013\u001a\u0004\u0018\u00010\u00058\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\rR&\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u00198\u0016@WX\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001e\u00a8\u0006+"}, d2={"Lorg/radarbase/schema/specification/stream/StreamDataTopic;", "Lorg/radarbase/schema/specification/DataTopic;", "()V", "inputTopics", "", "", "getInputTopics", "()Ljava/util/List;", "setInputTopics", "(Ljava/util/List;)V", "timedTopicNames", "Ljava/util/stream/Stream;", "getTimedTopicNames", "()Ljava/util/stream/Stream;", "topic", "getTopic", "()Ljava/lang/String;", "setTopic", "(Ljava/lang/String;)V", "topicBase", "getTopicBase", "setTopicBase", "topicNames", "getTopicNames", "value", "", "windowed", "getWindowed", "()Z", "setWindowed", "(Z)V", "propertiesMap", "", "map", "", "", "reduced", "setInputTopic", "inputTopic", "topics", "Lorg/radarbase/topic/AvroTopic;", "schemaCatalogue", "Lorg/radarbase/schema/SchemaCatalogue;", "radar-schemas-core"})
@SourceDebugExtension(value={"SMAP\nStreamDataTopic.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StreamDataTopic.kt\norg/radarbase/schema/specification/stream/StreamDataTopic\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,111:1\n1#2:112\n37#3,2:113\n*S KotlinDebug\n*F\n+ 1 StreamDataTopic.kt\norg/radarbase/schema/specification/stream/StreamDataTopic\n*L\n69#1:113,2\n*E\n"})
public class StreamDataTopic
extends DataTopic {
    @JsonProperty
    private boolean windowed;
    @JsonProperty(value="input_topics")
    @NotNull
    private List<String> inputTopics = new ArrayList();
    @JsonProperty(value="topic_base")
    @Nullable
    private String topicBase;
    @Nullable
    private String topic;

    public boolean getWindowed() {
        return this.windowed;
    }

    @JsonSetter
    public void setWindowed(boolean value) {
        this.windowed = value;
        if (value && (this.getKeySchema() == null || Intrinsics.areEqual((Object)this.getKeySchema(), (Object)ObservationKey.class.getName()))) {
            this.setKeySchema(AggregateKey.class.getName());
        }
    }

    @NotNull
    public List<String> getInputTopics() {
        return this.inputTopics;
    }

    public void setInputTopics(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.inputTopics = list;
    }

    @Nullable
    public String getTopicBase() {
        return this.topicBase;
    }

    public void setTopicBase(@Nullable String string) {
        this.topicBase = string;
    }

    @JsonSetter(value="input_topic")
    private void setInputTopic(String inputTopic) {
        if (this.getTopicBase() == null) {
            this.setTopicBase(inputTopic);
        }
        if (!this.getInputTopics().isEmpty()) {
            boolean bl = false;
            String string = "Input topics already set";
            throw new IllegalStateException(string.toString());
        }
        this.getInputTopics().add(inputTopic);
    }

    @Nullable
    public String getTopic() {
        Object object;
        if (this.getWindowed()) {
            object = this.getTopicBase() + "_<time-frame>";
        } else {
            object = this.topic;
            if (object == null) {
                object = this.getTopicBase() + "_output";
            }
        }
        return object;
    }

    public void setTopic(@Nullable String string) {
        this.topic = string;
    }

    @Override
    @JsonIgnore
    @NotNull
    public Stream<String> getTopicNames() {
        Stream<String> stream;
        if (this.getWindowed()) {
            Collection $this$toTypedArray$iv = (Collection)EntriesMappings.entries$0;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Stream<String> stream2 = Arrays.stream(thisCollection$iv.toArray(new TimeWindowMetadata[0])).map(arg_0 -> StreamDataTopic._get_topicNames_$lambda$1((Function1)new Function1<TimeWindowMetadata, String>(this){
                final /* synthetic */ StreamDataTopic this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final String invoke(@NotNull TimeWindowMetadata label) {
                    Intrinsics.checkNotNullParameter((Object)label, (String)"label");
                    return label.getTopicLabel(this.this$0.getTopicBase());
                }
            }, arg_0));
            Intrinsics.checkNotNull(stream2);
            stream = stream2;
        } else {
            Object currentTopic = this.getTopic();
            if (currentTopic == null) {
                currentTopic = this.getTopicBase() + "_output";
                this.setTopic((String)currentTopic);
            }
            Stream<String> stream3 = Stream.of(currentTopic);
            Intrinsics.checkNotNull(stream3);
            stream = stream3;
        }
        return stream;
    }

    @Override
    @JsonIgnore
    @NotNull
    public Stream<AvroTopic<?, ?>> topics(@NotNull SchemaCatalogue schemaCatalogue) {
        Intrinsics.checkNotNullParameter((Object)schemaCatalogue, (String)"schemaCatalogue");
        Stream<AvroTopic<?, ?>> stream = this.getTopicNames().flatMap(SchemaUtils.INSTANCE.applyOrEmpty(arg_0 -> StreamDataTopic.topics$lambda$2(this, schemaCatalogue, arg_0)));
        Intrinsics.checkNotNullExpressionValue(stream, (String)"flatMap(...)");
        return stream;
    }

    @JsonIgnore
    @NotNull
    public Stream<String> getTimedTopicNames() {
        Stream<String> stream;
        if (this.getWindowed()) {
            stream = this.getTopicNames();
        } else {
            Stream stream2 = Stream.empty();
            Intrinsics.checkNotNull(stream2);
            stream = stream2;
        }
        return stream;
    }

    @Override
    protected void propertiesMap(@NotNull Map<String, Object> map, boolean reduced) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        map.put("input_topics", this.getInputTopics());
        map.put("windowed", this.getWindowed());
        if (!reduced) {
            map.put("topic_base", this.getTopicBase());
        }
    }

    private static final String _get_topicNames_$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final Stream topics$lambda$2(StreamDataTopic this$0, SchemaCatalogue $schemaCatalogue, String topic) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$schemaCatalogue, (String)"$schemaCatalogue");
        AvroTopicConfig config = new AvroTopicConfig();
        config.setTopic(topic);
        config.setKeySchema(this$0.getKeySchema());
        config.setValueSchema(this$0.getValueSchema());
        Stream<AvroTopic<GenericRecord, GenericRecord>> stream = Stream.of($schemaCatalogue.genericAvroTopic(config));
        Intrinsics.checkNotNullExpressionValue(stream, (String)"of(...)");
        return stream;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<TimeWindowMetadata> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])TimeWindowMetadata.values()));
        }
    }
}

