/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.schema.validation.rules;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.apache.avro.JsonProperties;
import org.apache.avro.Schema;
import org.jetbrains.annotations.NotNull;
import org.radarbase.schema.validation.ValidationContext;
import org.radarbase.schema.validation.rules.AllValidatorKt;
import org.radarbase.schema.validation.rules.DirectValidatorKt;
import org.radarbase.schema.validation.rules.PredicateValidatorKt;
import org.radarbase.schema.validation.rules.SchemaField;
import org.radarbase.schema.validation.rules.SchemaFieldRules;
import org.radarbase.schema.validation.rules.SchemaFieldRulesKt;
import org.radarbase.schema.validation.rules.SchemaRules;
import org.radarbase.schema.validation.rules.Validator;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0016\u001a\u00020\u0017*\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J\u0014\u0010\u001a\u001a\u00020\u0017*\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0007H\u0002R \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\nR\u001a\u0010\u000f\u001a\u00020\u0010X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/radarbase/schema/validation/rules/SchemaFieldRules;", "", "()V", "defaultsValidator", "", "Lorg/apache/avro/Schema$Type;", "Lorg/radarbase/schema/validation/rules/Validator;", "Lorg/radarbase/schema/validation/rules/SchemaField;", "isDefaultValueNullable", "isDefaultValueValid", "()Lorg/radarbase/schema/validation/rules/Validator;", "isDocumentationValid", "isFieldTypeValid", "isFieldValid", "isNameValid", "schemaRules", "Lorg/radarbase/schema/validation/rules/SchemaRules;", "getSchemaRules$radar_schemas_core", "()Lorg/radarbase/schema/validation/rules/SchemaRules;", "setSchemaRules$radar_schemas_core", "(Lorg/radarbase/schema/validation/rules/SchemaRules;)V", "validateInternalUnion", "isDefaultUnionCompatible", "", "Lorg/radarbase/schema/validation/ValidationContext;", "field", "isEnumDefaultUnknown", "Companion", "radar-schemas-core"})
public final class SchemaFieldRules {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<Schema.Type, Validator<SchemaField>> defaultsValidator = new EnumMap(Schema.Type.class);
    public SchemaRules schemaRules;
    @NotNull
    private final Validator<SchemaField> validateInternalUnion;
    @NotNull
    private final Validator<SchemaField> isFieldTypeValid;
    @NotNull
    private final Validator<SchemaField> isDefaultValueNullable;
    @NotNull
    private final Validator<SchemaField> isDefaultValueValid;
    @NotNull
    private final Validator<SchemaField> isNameValid;
    @NotNull
    private final Validator<SchemaField> isDocumentationValid;
    @NotNull
    private final Validator<SchemaField> isFieldValid;
    @NotNull
    private static final String UNKNOWN = "UNKNOWN";
    private static final Schema NULL_SCHEMA = Schema.create((Schema.Type)Schema.Type.NULL);
    @NotNull
    private static final Regex FIELD_NAME_PATTERN = new Regex("[a-z][a-z0-9]*([a-z0-9][A-Z][a-z0-9]+)?([A-Z][a-z0-9]+)*[A-Z]?");

    public SchemaFieldRules() {
        this.defaultsValidator.put(Schema.Type.ENUM, DirectValidatorKt.Validator((Function2)new Function2<ValidationContext, SchemaField, Unit>(){

            public final void invoke(@NotNull ValidationContext $this$Validator, @NotNull SchemaField it) {
                Intrinsics.checkNotNullParameter((Object)$this$Validator, (String)"$this$Validator");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.isEnumDefaultUnknown($this$Validator, it);
            }
        }));
        this.defaultsValidator.put(Schema.Type.UNION, DirectValidatorKt.Validator((Function2)new Function2<ValidationContext, SchemaField, Unit>(){

            public final void invoke(@NotNull ValidationContext $this$Validator, @NotNull SchemaField it) {
                Intrinsics.checkNotNullParameter((Object)$this$Validator, (String)"$this$Validator");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.isDefaultUnionCompatible($this$Validator, it);
            }
        }));
        this.validateInternalUnion = DirectValidatorKt.Validator((Function2)new Function2<ValidationContext, SchemaField, Unit>(this){
            final /* synthetic */ SchemaFieldRules this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull ValidationContext $this$Validator, @NotNull SchemaField field) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)$this$Validator, (String)"$this$Validator");
                Intrinsics.checkNotNullParameter((Object)field, (String)"field");
                List list = field.getField().schema().getTypes();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getTypes(...)");
                Iterable iterable = list;
                SchemaFieldRules schemaFieldRules = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Schema.Type type;
                    Schema schema = (Schema)element$iv;
                    boolean bl = false;
                    Schema.Type type2 = type = schema.getType();
                    switch (type2 == null ? -1 : validateInternalUnion.WhenMappings.$EnumSwitchMapping$0[type2.ordinal()]) {
                        case 1: {
                            $this$Validator.launchValidation(schemaFieldRules.getSchemaRules$radar_schemas_core().isRecordValid(), schema);
                            break;
                        }
                        case 2: {
                            $this$Validator.launchValidation(schemaFieldRules.getSchemaRules$radar_schemas_core().isEnumValid(), schema);
                            break;
                        }
                        case 3: {
                            SchemaFieldRulesKt.raise($this$Validator, field, "Cannot have a nested union.");
                            break;
                        }
                        default: {
                        }
                    }
                }
            }
        });
        this.isFieldTypeValid = DirectValidatorKt.Validator((Function2)new Function2<ValidationContext, SchemaField, Unit>(this){
            final /* synthetic */ SchemaFieldRules this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull ValidationContext $this$Validator, @NotNull SchemaField field) {
                Schema.Type subType;
                Intrinsics.checkNotNullParameter((Object)$this$Validator, (String)"$this$Validator");
                Intrinsics.checkNotNullParameter((Object)field, (String)"field");
                Schema schema = field.getField().schema();
                Schema.Type type = subType = schema.getType();
                switch (type == null ? -1 : isFieldTypeValid.WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                    case 1: {
                        $this$Validator.validate(SchemaFieldRules.access$getValidateInternalUnion$p(this.this$0), field);
                        break;
                    }
                    case 2: {
                        Validator<Schema> validator2 = this.this$0.getSchemaRules$radar_schemas_core().isRecordValid();
                        Intrinsics.checkNotNull((Object)schema);
                        $this$Validator.validate(validator2, schema);
                        break;
                    }
                    case 3: {
                        Validator<Schema> validator3 = this.this$0.getSchemaRules$radar_schemas_core().isEnumValid();
                        Intrinsics.checkNotNull((Object)schema);
                        $this$Validator.validate(validator3, schema);
                        break;
                    }
                }
            }
        });
        this.isDefaultValueNullable = DirectValidatorKt.Validator(isDefaultValueNullable.1.INSTANCE);
        this.isDefaultValueValid = DirectValidatorKt.Validator((Function2)new Function2<ValidationContext, SchemaField, Unit>(this){
            final /* synthetic */ SchemaFieldRules this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull ValidationContext $this$Validator, @NotNull SchemaField input) {
                Intrinsics.checkNotNullParameter((Object)$this$Validator, (String)"$this$Validator");
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                Map map = SchemaFieldRules.access$getDefaultsValidator$p(this.this$0);
                Schema.Type type = input.getField().schema().getType();
                Intrinsics.checkNotNullExpressionValue((Object)type, (String)"getType(...)");
                $this$Validator.validate(map.getOrDefault(type, SchemaFieldRules.access$isDefaultValueNullable$p(this.this$0)), input);
            }
        });
        this.isNameValid = PredicateValidatorKt.validator((Function1)isNameValid.1.INSTANCE, "Field name does not respect lowerCamelCase name convention. Please avoid abbreviations and write out the field name instead.");
        this.isDocumentationValid = DirectValidatorKt.Validator(isDocumentationValid.1.INSTANCE);
        Validator[] validatorArray = new Validator[]{this.isFieldTypeValid, this.isNameValid, this.isDefaultValueValid, this.isDocumentationValid};
        this.isFieldValid = AllValidatorKt.all(validatorArray);
    }

    @NotNull
    public final SchemaRules getSchemaRules$radar_schemas_core() {
        SchemaRules schemaRules = this.schemaRules;
        if (schemaRules != null) {
            return schemaRules;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"schemaRules");
        return null;
    }

    public final void setSchemaRules$radar_schemas_core(@NotNull SchemaRules schemaRules) {
        Intrinsics.checkNotNullParameter((Object)schemaRules, (String)"<set-?>");
        this.schemaRules = schemaRules;
    }

    @NotNull
    public final Validator<SchemaField> isFieldTypeValid() {
        return this.isFieldTypeValid;
    }

    @NotNull
    public final Validator<SchemaField> isDefaultValueValid() {
        return this.isDefaultValueValid;
    }

    @NotNull
    public final Validator<SchemaField> isNameValid() {
        return this.isNameValid;
    }

    @NotNull
    public final Validator<SchemaField> isDocumentationValid() {
        return this.isDocumentationValid;
    }

    @NotNull
    public final Validator<SchemaField> isFieldValid() {
        return this.isFieldValid;
    }

    private final void isEnumDefaultUnknown(ValidationContext $this$isEnumDefaultUnknown, SchemaField field) {
        if (field.getField().schema().getEnumSymbols().contains(UNKNOWN)) {
            Object object = field.getField().defaultVal();
            if (!Intrinsics.areEqual((Object)(object != null ? object.toString() : null), (Object)UNKNOWN)) {
                SchemaFieldRulesKt.raise($this$isEnumDefaultUnknown, field, "Default is \"" + field.getField().defaultVal() + "\". Any Avro enum type that has an \"UNKNOWN\" symbol must set its default value to \"UNKNOWN\".");
            }
        }
    }

    private final void isDefaultUnionCompatible(ValidationContext $this$isDefaultUnionCompatible, SchemaField field) {
        if (field.getField().schema().getTypes().contains(NULL_SCHEMA) && !Intrinsics.areEqual((Object)field.getField().defaultVal(), (Object)JsonProperties.NULL_VALUE)) {
            SchemaFieldRulesKt.raise($this$isDefaultUnionCompatible, field, "Default is not null. Any nullable Avro field must specify have its default value set to null.");
        }
    }

    public static final /* synthetic */ Validator access$getValidateInternalUnion$p(SchemaFieldRules $this) {
        return $this.validateInternalUnion;
    }

    public static final /* synthetic */ Map access$getDefaultsValidator$p(SchemaFieldRules $this) {
        return $this.defaultsValidator;
    }

    public static final /* synthetic */ Validator access$isDefaultValueNullable$p(SchemaFieldRules $this) {
        return $this.isDefaultValueNullable;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/radarbase/schema/validation/rules/SchemaFieldRules$Companion;", "", "()V", "FIELD_NAME_PATTERN", "Lkotlin/text/Regex;", "getFIELD_NAME_PATTERN$radar_schemas_core", "()Lkotlin/text/Regex;", "NULL_SCHEMA", "Lorg/apache/avro/Schema;", "kotlin.jvm.PlatformType", "UNKNOWN", "", "radar-schemas-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Regex getFIELD_NAME_PATTERN$radar_schemas_core() {
            return FIELD_NAME_PATTERN;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

