/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.schema.validation;

import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.radarbase.schema.Scope;
import org.radarbase.schema.util.SchemaUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\b\u001a\u00020\u00042\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0004J\n\u0010\u0011\u001a\u00020\u0004*\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/radarbase/schema/validation/ValidationHelper;", "", "()V", "COMMONS_PATH", "", "SPECIFICATIONS_PATH", "TOPIC_PATTERN", "Lkotlin/text/Regex;", "getNamespace", "schemaRoot", "Ljava/nio/file/Path;", "schemaPath", "scope", "Lorg/radarbase/schema/Scope;", "isValidTopic", "", "topicName", "toRecordName", "radar-schemas-core"})
@SourceDebugExtension(value={"SMAP\nValidationHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ValidationHelper.kt\norg/radarbase/schema/validation/ValidationHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,50:1\n1#2:51\n*E\n"})
public final class ValidationHelper {
    @NotNull
    public static final ValidationHelper INSTANCE = new ValidationHelper();
    @NotNull
    public static final String COMMONS_PATH = "commons";
    @NotNull
    public static final String SPECIFICATIONS_PATH = "specifications";
    @NotNull
    private static final Regex TOPIC_PATTERN = new Regex("[A-Za-z][a-z0-9-]*(_[A-Za-z0-9-]+)*");

    private ValidationHelper() {
    }

    @NotNull
    public final String getNamespace(@Nullable Path schemaRoot, @Nullable Path schemaPath, @NotNull Scope scope) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Path path = scope.getPath(schemaRoot);
        if (path == null) {
            boolean bl = false;
            String string = "Scope " + scope + " does not have a commons path";
            throw new IllegalArgumentException(string.toString());
        }
        Path rootPath = path;
        if (schemaPath == null) {
            boolean $i$a$-requireNotNull-ValidationHelper$getNamespace$22 = false;
            String $i$a$-requireNotNull-ValidationHelper$getNamespace$22 = "Missing schema path";
            throw new IllegalArgumentException($i$a$-requireNotNull-ValidationHelper$getNamespace$22.toString());
        }
        Path relativePath = rootPath.relativize(schemaPath);
        int n = 50;
        StringBuilder $this$getNamespace_u24lambda_u242 = stringBuilder = new StringBuilder(n);
        boolean bl = false;
        $this$getNamespace_u24lambda_u242.append(SchemaUtils.INSTANCE.getProjectGroup());
        $this$getNamespace_u24lambda_u242.append('.');
        $this$getNamespace_u24lambda_u242.append(scope.getLower());
        int n2 = relativePath.getNameCount() - 1;
        for (int i = 0; i < n2; ++i) {
            $this$getNamespace_u24lambda_u242.append('.');
            $this$getNamespace_u24lambda_u242.append(relativePath.getName(i));
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final String toRecordName(@NotNull Path $this$toRecordName) {
        Intrinsics.checkNotNullParameter((Object)$this$toRecordName, (String)"<this>");
        return SchemaUtils.INSTANCE.snakeToCamelCase(((Object)$this$toRecordName.getFileName()).toString());
    }

    public final boolean isValidTopic(@Nullable String topicName) {
        CharSequence charSequence;
        String string = topicName;
        return string != null ? TOPIC_PATTERN.matches(charSequence = (CharSequence)string) : false;
    }
}

