/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.schema.validation;

import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.apache.avro.Schema;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.radarbase.schema.SchemaCatalogue;
import org.radarbase.schema.Scope;
import org.radarbase.schema.specification.DataProducer;
import org.radarbase.schema.specification.DataTopic;
import org.radarbase.schema.specification.SourceCatalogue;
import org.radarbase.schema.specification.config.SchemaConfig;
import org.radarbase.schema.validation.SchemaValidator;
import org.radarbase.schema.validation.ValidationContext;
import org.radarbase.schema.validation.ValidationContextKt;
import org.radarbase.schema.validation.ValidationException;
import org.radarbase.schema.validation.rules.DirectValidatorKt;
import org.radarbase.schema.validation.rules.FailedSchemaMetadata;
import org.radarbase.schema.validation.rules.SchemaMetadata;
import org.radarbase.schema.validation.rules.SchemaMetadataRules;
import org.radarbase.schema.validation.rules.Validator;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 (2\u00020\u0001:\u0001(B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J(\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00152\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0086@\u00a2\u0006\u0002\u0010\u0018J&\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0086@\u00a2\u0006\u0002\u0010\u001cJ \u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001c\u0010 \u001a\u00020!*\u00020\"2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\"\u0010#\u001a\u00020!*\u00020\"2\u0006\u0010$\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0017J\u0014\u0010#\u001a\u00020!*\u00020\"2\u0006\u0010&\u001a\u00020'H\u0002R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001d\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006)"}, d2={"Lorg/radarbase/schema/validation/SchemaValidator;", "", "schemaRoot", "Ljava/nio/file/Path;", "config", "Lorg/radarbase/schema/specification/config/SchemaConfig;", "(Ljava/nio/file/Path;Lorg/radarbase/schema/specification/config/SchemaConfig;)V", "rules", "Lorg/radarbase/schema/validation/rules/SchemaMetadataRules;", "getRules", "()Lorg/radarbase/schema/validation/rules/SchemaMetadataRules;", "validatedSchemas", "", "", "Lorg/apache/avro/Schema;", "getValidatedSchemas", "()Ljava/util/Map;", "analyseFiles", "", "Lorg/radarbase/schema/validation/ValidationException;", "schemaCatalogue", "Lorg/radarbase/schema/SchemaCatalogue;", "scope", "Lorg/radarbase/schema/Scope;", "(Lorg/radarbase/schema/SchemaCatalogue;Lorg/radarbase/schema/Scope;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "analyseSourceCatalogue", "catalogue", "Lorg/radarbase/schema/specification/SourceCatalogue;", "(Lorg/radarbase/schema/Scope;Lorg/radarbase/schema/specification/SourceCatalogue;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "parsingValidator", "Lorg/radarbase/schema/validation/rules/Validator;", "Lorg/radarbase/schema/validation/rules/FailedSchemaMetadata;", "analyseFilesInternal", "", "Lorg/radarbase/schema/validation/ValidationContext;", "validate", "schema", "path", "schemaMetadata", "Lorg/radarbase/schema/validation/rules/SchemaMetadata;", "Companion", "radar-schemas-core"})
@SourceDebugExtension(value={"SMAP\nSchemaValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SchemaValidator.kt\norg/radarbase/schema/validation/SchemaValidator\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,137:1\n215#2,2:138\n*S KotlinDebug\n*F\n+ 1 SchemaValidator.kt\norg/radarbase/schema/validation/SchemaValidator\n*L\n99#1:138,2\n*E\n"})
public final class SchemaValidator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SchemaMetadataRules rules;
    @NotNull
    private static final String AVRO_EXTENSION = "avsc";

    public SchemaValidator(@NotNull Path schemaRoot, @NotNull SchemaConfig config) {
        Intrinsics.checkNotNullParameter((Object)schemaRoot, (String)"schemaRoot");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.rules = new SchemaMetadataRules(schemaRoot, config, null, 4, null);
    }

    @NotNull
    public final SchemaMetadataRules getRules() {
        return this.rules;
    }

    @Nullable
    public final Object analyseSourceCatalogue(@Nullable Scope scope, @NotNull SourceCatalogue catalogue, @NotNull Continuation<? super List<ValidationException>> $completion) {
        Stream stream;
        Validator<SchemaMetadata> validator2 = this.rules.isSchemaMetadataValid(true);
        if (scope != null) {
            var6_5 = catalogue.getSources().stream().filter(arg_0 -> SchemaValidator.analyseSourceCatalogue$lambda$0((Function1)new Function1<DataProducer<?>, Boolean>(scope){
                final /* synthetic */ Scope $scope;
                {
                    this.$scope = $scope;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(DataProducer<?> it) {
                    return it.getScope() == this.$scope;
                }
            }, arg_0));
            Intrinsics.checkNotNull(var6_5);
            stream = var6_5;
        } else {
            var6_5 = catalogue.getSources().stream();
            Intrinsics.checkNotNull(var6_5);
            stream = var6_5;
        }
        Stream producers2 = stream;
        Set schemas2 = producers2.flatMap(arg_0 -> SchemaValidator.analyseSourceCatalogue$lambda$1(analyseSourceCatalogue.schemas.1.INSTANCE, arg_0)).flatMap(arg_0 -> SchemaValidator.analyseSourceCatalogue$lambda$2((Function1)new Function1<DataTopic, Stream<? extends SchemaMetadata>>(catalogue){
            final /* synthetic */ SourceCatalogue $catalogue;
            {
                this.$catalogue = $catalogue;
                super(1);
            }

            public final Stream<? extends SchemaMetadata> invoke(DataTopic topic) {
                SchemaCatalogue schemaCatalogue = this.$catalogue.getSchemaCatalogue();
                Intrinsics.checkNotNull((Object)((Object)topic));
                Pair<SchemaMetadata, SchemaMetadata> pair = schemaCatalogue.topicSchemas(topic);
                SchemaMetadata keySchema = (SchemaMetadata)pair.component1();
                SchemaMetadata valueSchema = (SchemaMetadata)pair.component2();
                SchemaMetadata[] schemaMetadataArray = new SchemaMetadata[]{keySchema, valueSchema};
                return Stream.of(schemaMetadataArray);
            }
        }, arg_0)).collect(Collectors.toSet());
        Intrinsics.checkNotNull(schemas2);
        return ValidationContextKt.validateAll(validator2, schemas2, $completion);
    }

    @Nullable
    public final Object analyseFiles(@NotNull SchemaCatalogue schemaCatalogue, @Nullable Scope scope, @NotNull Continuation<? super List<ValidationException>> $completion) {
        return ValidationContextKt.validationContext((Function1<? super ValidationContext, Unit>)((Function1)new Function1<ValidationContext, Unit>(scope, this, schemaCatalogue){
            final /* synthetic */ Scope $scope;
            final /* synthetic */ SchemaValidator this$0;
            final /* synthetic */ SchemaCatalogue $schemaCatalogue;
            {
                this.$scope = $scope;
                this.this$0 = $receiver;
                this.$schemaCatalogue = $schemaCatalogue;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull ValidationContext $this$validationContext) {
                Intrinsics.checkNotNullParameter((Object)$this$validationContext, (String)"$this$validationContext");
                if (this.$scope == null) {
                    void $this$forEach$iv;
                    Iterable iterable = (Iterable)analyseFiles.EntriesMappings.entries$0;
                    SchemaValidator schemaValidator = this.this$0;
                    SchemaCatalogue schemaCatalogue = this.$schemaCatalogue;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        Scope scope = (Scope)element$iv;
                        boolean bl = false;
                        ValidationContext.launch$default($this$validationContext, null, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(schemaValidator, $this$validationContext, schemaCatalogue, scope, null){
                            int label;
                            final /* synthetic */ SchemaValidator this$0;
                            final /* synthetic */ ValidationContext $this_validationContext;
                            final /* synthetic */ SchemaCatalogue $schemaCatalogue;
                            final /* synthetic */ Scope $scope;
                            {
                                this.this$0 = $receiver;
                                this.$this_validationContext = $this_validationContext;
                                this.$schemaCatalogue = $schemaCatalogue;
                                this.$scope = $scope;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        SchemaValidator.access$analyseFilesInternal(this.this$0, this.$this_validationContext, this.$schemaCatalogue, this.$scope);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }, 1, null);
                    }
                } else {
                    SchemaValidator.access$analyseFilesInternal(this.this$0, $this$validationContext, this.$schemaCatalogue, this.$scope);
                }
            }
        }), $completion);
    }

    public static /* synthetic */ Object analyseFiles$default(SchemaValidator schemaValidator, SchemaCatalogue schemaCatalogue, Scope scope, Continuation continuation, int n, Object object) {
        if ((n & 2) != 0) {
            scope = null;
        }
        return schemaValidator.analyseFiles(schemaCatalogue, scope, (Continuation<? super List<ValidationException>>)continuation);
    }

    private final void analyseFilesInternal(ValidationContext $this$analyseFilesInternal, SchemaCatalogue schemaCatalogue, Scope scope) {
        $this$analyseFilesInternal.validateAll(this.parsingValidator(scope, schemaCatalogue), (Iterable)schemaCatalogue.getUnmappedSchemas());
        $this$analyseFilesInternal.validateAll(this.rules.isSchemaMetadataValid(false), (Iterable)schemaCatalogue.getSchemas().values());
    }

    private final Validator<FailedSchemaMetadata> parsingValidator(Scope scope, SchemaCatalogue schemaCatalogue) {
        Map map;
        Map $this$parsingValidator_u24lambda_u244 = map = MapsKt.createMapBuilder();
        boolean bl = false;
        Map<String, SchemaMetadata> $this$forEach$iv = schemaCatalogue.getSchemas();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, SchemaMetadata>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, SchemaMetadata> element$iv;
            Map.Entry<String, SchemaMetadata> entry = element$iv = iterator.next();
            boolean bl2 = false;
            String key = entry.getKey();
            SchemaMetadata value = entry.getValue();
            if (value.getScope() != scope) continue;
            $this$parsingValidator_u24lambda_u244.put(key, value.getSchema());
        }
        Map useTypes = MapsKt.build((Map)map);
        return DirectValidatorKt.Validator((Function2)new Function2<ValidationContext, FailedSchemaMetadata, Unit>((Map<String, ? extends Schema>)useTypes){
            final /* synthetic */ Map<String, Schema> $useTypes;
            {
                this.$useTypes = $useTypes;
                super(2);
            }

            public final void invoke(@NotNull ValidationContext $this$Validator, @NotNull FailedSchemaMetadata metadata) {
                Intrinsics.checkNotNullParameter((Object)$this$Validator, (String)"$this$Validator");
                Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
                Schema.Parser parser = new Schema.Parser();
                parser.addTypes(this.$useTypes);
                $this$Validator.launch((CoroutineContext)Dispatchers.getIO(), (Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(parser, metadata, $this$Validator, null){
                    int label;
                    final /* synthetic */ Schema.Parser $parser;
                    final /* synthetic */ FailedSchemaMetadata $metadata;
                    final /* synthetic */ ValidationContext $this_Validator;
                    {
                        this.$parser = $parser;
                        this.$metadata = $metadata;
                        this.$this_Validator = $this_Validator;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                try {
                                    this.$parser.parse(this.$metadata.getPath().toFile());
                                }
                                catch (Exception ex) {
                                    this.$this_Validator.raise("Cannot parse schema", ex);
                                }
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }));
            }
        });
    }

    public final void validate(@NotNull ValidationContext $this$validate, @NotNull Schema schema, @NotNull Path path, @NotNull Scope scope) {
        Intrinsics.checkNotNullParameter((Object)$this$validate, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.validate($this$validate, new SchemaMetadata(schema, scope, path));
    }

    private final void validate(ValidationContext $this$validate, SchemaMetadata schemaMetadata) {
        $this$validate.validate(this.rules.isSchemaMetadataValid(false), schemaMetadata);
    }

    @NotNull
    public final Map<String, Schema> getValidatedSchemas() {
        return this.rules.getSchemaRules().getSchemaStore();
    }

    private static final boolean analyseSourceCatalogue$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Stream analyseSourceCatalogue$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Stream)$tmp0.invoke(p0);
    }

    private static final Stream analyseSourceCatalogue$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Stream)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$analyseFilesInternal(SchemaValidator $this, ValidationContext $receiver, SchemaCatalogue schemaCatalogue, Scope scope) {
        $this.analyseFilesInternal($receiver, schemaCatalogue, scope);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u0005\u001a\u00020\u0006*\u00020\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/radarbase/schema/validation/SchemaValidator$Companion;", "", "()V", "AVRO_EXTENSION", "", "isAvscFile", "", "Ljava/nio/file/Path;", "radar-schemas-core"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isAvscFile(@NotNull Path $this$isAvscFile) {
            Intrinsics.checkNotNullParameter((Object)$this$isAvscFile, (String)"<this>");
            return StringsKt.equals((String)PathsKt.getExtension((Path)$this$isAvscFile), (String)SchemaValidator.AVRO_EXTENSION, (boolean)true);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

