/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.schema.specification;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.radarbase.schema.SchemaCatalogue;
import org.radarbase.schema.specification.DataProducer;
import org.radarbase.schema.specification.SourceCatalogue;
import org.radarbase.schema.specification.active.ActiveSource;
import org.radarbase.schema.specification.connector.ConnectorSource;
import org.radarbase.schema.specification.monitor.MonitorSource;
import org.radarbase.schema.specification.passive.PassiveSource;
import org.radarbase.schema.specification.push.PushSource;
import org.radarbase.schema.specification.stream.StreamGroup;
import org.radarbase.topic.AvroTopic;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001Bg\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0005\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0005\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0005\u00a2\u0006\u0002\u0010\u0011R\u001b\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0013R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001b\u0010\u001a\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001c0\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0013R\u0017\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u001f\u0010%\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030&0!8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010$\u00a8\u0006("}, d2={"Lorg/radarbase/schema/specification/SourceCatalogue;", "", "schemaCatalogue", "Lorg/radarbase/schema/SchemaCatalogue;", "activeSources", "", "Lorg/radarbase/schema/specification/active/ActiveSource;", "monitorSources", "Lorg/radarbase/schema/specification/monitor/MonitorSource;", "passiveSources", "Lorg/radarbase/schema/specification/passive/PassiveSource;", "streamGroups", "Lorg/radarbase/schema/specification/stream/StreamGroup;", "connectorSources", "Lorg/radarbase/schema/specification/connector/ConnectorSource;", "pushSources", "Lorg/radarbase/schema/specification/push/PushSource;", "(Lorg/radarbase/schema/SchemaCatalogue;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getActiveSources", "()Ljava/util/List;", "getConnectorSources", "getMonitorSources", "getPassiveSources", "getPushSources", "getSchemaCatalogue", "()Lorg/radarbase/schema/SchemaCatalogue;", "sources", "", "Lorg/radarbase/schema/specification/DataProducer;", "getSources", "()Ljava/util/Set;", "getStreamGroups", "topicNames", "Ljava/util/stream/Stream;", "", "getTopicNames", "()Ljava/util/stream/Stream;", "topics", "Lorg/radarbase/topic/AvroTopic;", "getTopics", "radar-schemas-core"})
public final class SourceCatalogue {
    @NotNull
    private final SchemaCatalogue schemaCatalogue;
    @NotNull
    private final List<ActiveSource<?>> activeSources;
    @NotNull
    private final List<MonitorSource> monitorSources;
    @NotNull
    private final List<PassiveSource> passiveSources;
    @NotNull
    private final List<StreamGroup> streamGroups;
    @NotNull
    private final List<ConnectorSource> connectorSources;
    @NotNull
    private final List<PushSource> pushSources;
    @NotNull
    private final Set<DataProducer<?>> sources;

    /*
     * WARNING - void declaration
     */
    public SourceCatalogue(@NotNull SchemaCatalogue schemaCatalogue, @NotNull List<? extends ActiveSource<?>> activeSources, @NotNull List<? extends MonitorSource> monitorSources, @NotNull List<? extends PassiveSource> passiveSources, @NotNull List<? extends StreamGroup> streamGroups, @NotNull List<? extends ConnectorSource> connectorSources, @NotNull List<? extends PushSource> pushSources) {
        void $this$sources_u24lambda_u240;
        Set set;
        Intrinsics.checkNotNullParameter((Object)schemaCatalogue, (String)"schemaCatalogue");
        Intrinsics.checkNotNullParameter(activeSources, (String)"activeSources");
        Intrinsics.checkNotNullParameter(monitorSources, (String)"monitorSources");
        Intrinsics.checkNotNullParameter(passiveSources, (String)"passiveSources");
        Intrinsics.checkNotNullParameter(streamGroups, (String)"streamGroups");
        Intrinsics.checkNotNullParameter(connectorSources, (String)"connectorSources");
        Intrinsics.checkNotNullParameter(pushSources, (String)"pushSources");
        this.schemaCatalogue = schemaCatalogue;
        this.activeSources = activeSources;
        this.monitorSources = monitorSources;
        this.passiveSources = passiveSources;
        this.streamGroups = streamGroups;
        this.connectorSources = connectorSources;
        this.pushSources = pushSources;
        Set set2 = set = SetsKt.createSetBuilder();
        SourceCatalogue sourceCatalogue = this;
        boolean bl = false;
        $this$sources_u24lambda_u240.addAll((Collection)this.activeSources);
        $this$sources_u24lambda_u240.addAll((Collection)this.monitorSources);
        $this$sources_u24lambda_u240.addAll((Collection)this.passiveSources);
        $this$sources_u24lambda_u240.addAll((Collection)this.streamGroups);
        $this$sources_u24lambda_u240.addAll((Collection)this.connectorSources);
        $this$sources_u24lambda_u240.addAll((Collection)this.pushSources);
        sourceCatalogue.sources = SetsKt.build((Set)set);
    }

    @NotNull
    public final SchemaCatalogue getSchemaCatalogue() {
        return this.schemaCatalogue;
    }

    @NotNull
    public final List<ActiveSource<?>> getActiveSources() {
        return this.activeSources;
    }

    @NotNull
    public final List<MonitorSource> getMonitorSources() {
        return this.monitorSources;
    }

    @NotNull
    public final List<PassiveSource> getPassiveSources() {
        return this.passiveSources;
    }

    @NotNull
    public final List<StreamGroup> getStreamGroups() {
        return this.streamGroups;
    }

    @NotNull
    public final List<ConnectorSource> getConnectorSources() {
        return this.connectorSources;
    }

    @NotNull
    public final List<PushSource> getPushSources() {
        return this.pushSources;
    }

    @NotNull
    public final Set<DataProducer<?>> getSources() {
        return this.sources;
    }

    @NotNull
    public final Stream<String> getTopicNames() {
        Stream<String> stream = this.sources.stream().flatMap(arg_0 -> SourceCatalogue._get_topicNames_$lambda$1(topicNames.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue(stream, (String)"flatMap(...)");
        return stream;
    }

    @NotNull
    public final Stream<AvroTopic<?, ?>> getTopics() {
        Stream<AvroTopic<?, ?>> stream = this.sources.stream().flatMap(arg_0 -> SourceCatalogue._get_topics_$lambda$2((Function1)new Function1<DataProducer<?>, Stream<? extends AvroTopic<?, ?>>>(this){
            final /* synthetic */ SourceCatalogue this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final Stream<? extends AvroTopic<?, ?>> invoke(DataProducer<?> it) {
                return it.topics(this.this$0.getSchemaCatalogue());
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue(stream, (String)"flatMap(...)");
        return stream;
    }

    private static final Stream _get_topicNames_$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Stream)$tmp0.invoke(p0);
    }

    private static final Stream _get_topics_$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Stream)$tmp0.invoke(p0);
    }
}

