/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.schema.specification;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.radarbase.config.OpenConfig;
import org.radarbase.schema.SchemaCatalogue;
import org.radarbase.schema.Scope;
import org.radarbase.schema.specification.DataProducer;
import org.radarbase.schema.specification.DataTopic;
import org.radarbase.schema.util.SchemaUtils;
import org.radarbase.topic.AvroTopic;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@OpenConfig
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b'\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\b\u0010+\u001a\u00020\u001eH\u0016J\u0013\u0010,\u001a\u00020\u001e2\b\u0010-\u001a\u0004\u0018\u00010\u0003H\u0096\u0002J\b\u0010.\u001a\u00020/H\u0016J\u001e\u00100\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u0003010(2\u0006\u00102\u001a\u000203H\u0017R\u001d\u0010\u0005\u001a\r\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\b\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR%\u0010\n\u001a\t\u0018\u00010\u000b\u00a2\u0006\u0002\b\f8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R,\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u00128\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R%\u0010\u0017\u001a\t\u0018\u00010\u000b\u00a2\u0006\u0002\b\f8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u000e\"\u0004\b\u0019\u0010\u0010R,\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u00128\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0014\"\u0004\b\u001c\u0010\u0016R\u001e\u0010\u001d\u001a\u00020\u001e8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u0019\u0010#\u001a\t\u0018\u00010$\u00a2\u0006\u0002\b\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u001a\u0010'\u001a\b\u0012\u0004\u0012\u00020\u000b0(8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*\u00a8\u00064"}, d2={"Lorg/radarbase/schema/specification/DataProducer;", "T", "Lorg/radarbase/schema/specification/DataTopic;", "", "()V", "data", "", "Ljakarta/validation/constraints/NotNull;", "getData", "()Ljava/util/List;", "doc", "", "Ljakarta/validation/constraints/NotBlank;", "getDoc", "()Ljava/lang/String;", "setDoc", "(Ljava/lang/String;)V", "labels", "", "getLabels", "()Ljava/util/Map;", "setLabels", "(Ljava/util/Map;)V", "name", "getName", "setName", "properties", "getProperties", "setProperties", "registerSchema", "", "getRegisterSchema", "()Z", "setRegisterSchema", "(Z)V", "scope", "Lorg/radarbase/schema/Scope;", "getScope", "()Lorg/radarbase/schema/Scope;", "topicNames", "Ljava/util/stream/Stream;", "getTopicNames", "()Ljava/util/stream/Stream;", "doRegisterSchema", "equals", "other", "hashCode", "", "topics", "Lorg/radarbase/topic/AvroTopic;", "schemaCatalogue", "Lorg/radarbase/schema/SchemaCatalogue;", "radar-schemas-core"})
public abstract class DataProducer<T extends DataTopic> {
    @JsonProperty
    @Nullable
    private String name;
    @JsonProperty
    @Nullable
    private String doc;
    @JsonProperty
    @Nullable
    private Map<String, String> properties;
    @JsonProperty
    @Nullable
    private Map<String, String> labels;
    @JsonProperty(value="register_schema")
    private boolean registerSchema = true;

    @Nullable
    public String getName() {
        return this.name;
    }

    public void setName(@Nullable String string) {
        this.name = string;
    }

    @Nullable
    public String getDoc() {
        return this.doc;
    }

    public void setDoc(@Nullable String string) {
        this.doc = string;
    }

    @Nullable
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(@Nullable Map<String, String> map) {
        this.properties = map;
    }

    @Nullable
    public Map<String, String> getLabels() {
        return this.labels;
    }

    public void setLabels(@Nullable Map<String, String> map) {
        this.labels = map;
    }

    public boolean getRegisterSchema() {
        return this.registerSchema;
    }

    public void setRegisterSchema(boolean bl) {
        this.registerSchema = bl;
    }

    @NotNull
    public abstract List<T> getData();

    @Nullable
    public abstract Scope getScope();

    @JsonIgnore
    @NotNull
    public Stream<String> getTopicNames() {
        Stream<String> stream = this.getData().stream().flatMap(arg_0 -> DataProducer._get_topicNames_$lambda$0((Function1)topicNames.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue(stream, (String)"flatMap(...)");
        return stream;
    }

    @JsonIgnore
    @NotNull
    public Stream<AvroTopic<?, ?>> topics(@NotNull SchemaCatalogue schemaCatalogue) {
        Intrinsics.checkNotNullParameter((Object)schemaCatalogue, (String)"schemaCatalogue");
        Stream<AvroTopic<?, ?>> stream = this.getData().stream().flatMap(SchemaUtils.INSTANCE.applyOrEmpty(arg_0 -> DataProducer.topics$lambda$1(schemaCatalogue, arg_0)));
        Intrinsics.checkNotNullExpressionValue(stream, (String)"flatMap(...)");
        return stream;
    }

    public boolean doRegisterSchema() {
        return this.getRegisterSchema();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type org.radarbase.schema.specification.DataProducer<*>");
        DataProducer cfr_ignored_0 = (DataProducer)other;
        return Intrinsics.areEqual((Object)this.getName(), (Object)((DataProducer)other).getName()) && Intrinsics.areEqual((Object)this.getDoc(), (Object)((DataProducer)other).getDoc()) && Intrinsics.areEqual(this.getData(), ((DataProducer)other).getData());
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.getName(), this.getDoc(), this.getData()};
        return Objects.hash(objectArray);
    }

    private static final Stream _get_topicNames_$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Stream)$tmp0.invoke(p0);
    }

    private static final Stream topics$lambda$1(SchemaCatalogue $schemaCatalogue, DataTopic t) {
        Intrinsics.checkNotNullParameter((Object)$schemaCatalogue, (String)"$schemaCatalogue");
        return t.topics($schemaCatalogue);
    }
}

