/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.schema;

import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.jetbrains.annotations.NotNull;
import org.radarbase.config.AvroTopicConfig;
import org.radarbase.schema.validation.rules.FailedSchemaMetadata;
import org.radarbase.schema.validation.rules.SchemaMetadata;
import org.radarbase.topic.AvroTopic;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012J\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00142\u0006\u0010\u0011\u001a\u00020\u0012R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0015"}, d2={"Lorg/radarbase/schema/SchemaCatalogue;", "", "schemas", "", "", "Lorg/radarbase/schema/validation/rules/SchemaMetadata;", "unmappedSchemas", "", "Lorg/radarbase/schema/validation/rules/FailedSchemaMetadata;", "(Ljava/util/Map;Ljava/util/List;)V", "getSchemas", "()Ljava/util/Map;", "getUnmappedSchemas", "()Ljava/util/List;", "genericAvroTopic", "Lorg/radarbase/topic/AvroTopic;", "Lorg/apache/avro/generic/GenericRecord;", "config", "Lorg/radarbase/config/AvroTopicConfig;", "topicSchemas", "Lkotlin/Pair;", "radar-schemas-core"})
@SourceDebugExtension(value={"SMAP\nSchemaCatalogue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SchemaCatalogue.kt\norg/radarbase/schema/SchemaCatalogue\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,163:1\n1#2:164\n*E\n"})
public final class SchemaCatalogue {
    @NotNull
    private final Map<String, SchemaMetadata> schemas;
    @NotNull
    private final List<FailedSchemaMetadata> unmappedSchemas;

    public SchemaCatalogue(@NotNull Map<String, SchemaMetadata> schemas2, @NotNull List<FailedSchemaMetadata> unmappedSchemas) {
        Intrinsics.checkNotNullParameter(schemas2, (String)"schemas");
        Intrinsics.checkNotNullParameter(unmappedSchemas, (String)"unmappedSchemas");
        this.schemas = schemas2;
        this.unmappedSchemas = unmappedSchemas;
    }

    @NotNull
    public final Map<String, SchemaMetadata> getSchemas() {
        return this.schemas;
    }

    @NotNull
    public final List<FailedSchemaMetadata> getUnmappedSchemas() {
        return this.unmappedSchemas;
    }

    @NotNull
    public final AvroTopic<GenericRecord, GenericRecord> genericAvroTopic(@NotNull AvroTopicConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Pair<SchemaMetadata, SchemaMetadata> pair = this.topicSchemas(config);
        SchemaMetadata keySchema = (SchemaMetadata)pair.component1();
        SchemaMetadata valueSchema = (SchemaMetadata)pair.component2();
        String string = config.getTopic();
        if (string == null) {
            boolean $i$a$-requireNotNull-SchemaCatalogue$genericAvroTopic$42 = false;
            String $i$a$-requireNotNull-SchemaCatalogue$genericAvroTopic$42 = "Missing Avro topic in configuration";
            throw new IllegalArgumentException($i$a$-requireNotNull-SchemaCatalogue$genericAvroTopic$42.toString());
        }
        Schema schema = keySchema.getSchema();
        if (schema == null) {
            String string2 = string;
            boolean $i$a$-requireNotNull-SchemaCatalogue$genericAvroTopic$52 = false;
            String string3 = string2;
            String $i$a$-requireNotNull-SchemaCatalogue$genericAvroTopic$52 = "Missing Avro key schema";
            throw new IllegalArgumentException($i$a$-requireNotNull-SchemaCatalogue$genericAvroTopic$52.toString());
        }
        Schema schema2 = valueSchema.getSchema();
        if (schema2 == null) {
            Schema schema3 = schema;
            String string4 = string;
            boolean bl = false;
            String string5 = "Missing Avro value schema";
            String string6 = string4;
            Schema schema4 = schema3;
            String string7 = string5;
            throw new IllegalArgumentException(string7.toString());
        }
        Class<GenericRecord> clazz = GenericRecord.class;
        Class<GenericRecord> clazz2 = GenericRecord.class;
        Schema schema5 = schema2;
        Schema schema6 = schema;
        String string8 = string;
        return new AvroTopic(string8, schema6, schema5, clazz2, clazz);
    }

    @NotNull
    public final Pair<SchemaMetadata, SchemaMetadata> topicSchemas(@NotNull AvroTopicConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        SchemaMetadata schemaMetadata = this.schemas.get(config.getKeySchema());
        if (schemaMetadata == null) {
            throw new NoSuchElementException("Key schema " + config.getKeySchema() + " for topic " + config.getTopic() + " not found.");
        }
        SchemaMetadata parsedKeySchema = schemaMetadata;
        SchemaMetadata schemaMetadata2 = this.schemas.get(config.getValueSchema());
        if (schemaMetadata2 == null) {
            throw new NoSuchElementException("Value schema " + config.getValueSchema() + " for topic " + config.getTopic() + " not found.");
        }
        SchemaMetadata parsedValueSchema = schemaMetadata2;
        return new Pair((Object)parsedKeySchema, (Object)parsedValueSchema);
    }
}

