/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.schema.validation.rules;

import io.confluent.connect.avro.AvroData;
import io.confluent.connect.avro.AvroDataConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.apache.avro.Schema;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.radarbase.schema.validation.ValidationContext;
import org.radarbase.schema.validation.rules.AllValidatorKt;
import org.radarbase.schema.validation.rules.DirectValidatorKt;
import org.radarbase.schema.validation.rules.PredicateValidatorKt;
import org.radarbase.schema.validation.rules.SchemaField;
import org.radarbase.schema.validation.rules.SchemaFieldRules;
import org.radarbase.schema.validation.rules.SchemaRules;
import org.radarbase.schema.validation.rules.SchemaRulesKt;
import org.radarbase.schema.validation.rules.Validator;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 *2\u00020\u0001:\u0001*B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\u001a\u0010$\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\bJ\u001c\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020 0(2\u0006\u0010)\u001a\u00020 H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000bR\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000bR\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000bR\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000bR\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000bR\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000bR\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u000bR\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000bR\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u000bR\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u000bR\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u000bR\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u000bR\u001d\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\t0\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lorg/radarbase/schema/validation/rules/SchemaRules;", "", "fieldRules", "Lorg/radarbase/schema/validation/rules/SchemaFieldRules;", "(Lorg/radarbase/schema/validation/rules/SchemaFieldRules;)V", "getFieldRules", "()Lorg/radarbase/schema/validation/rules/SchemaFieldRules;", "hasNoTimeCompleted", "Lorg/radarbase/schema/validation/rules/Validator;", "Lorg/apache/avro/Schema;", "getHasNoTimeCompleted", "()Lorg/radarbase/schema/validation/rules/Validator;", "hasNoTimeReceived", "getHasNoTimeReceived", "hasTime", "getHasTime", "hasTimeCompleted", "getHasTimeCompleted", "hasTimeReceived", "getHasTimeReceived", "isActiveSourceValid", "isDocumentationValid", "isEnumSymbolsValid", "isEnumValid", "isMonitorSourceValid", "isNameValid", "isNamespaceValid", "isPassiveSourceValid", "isRecordValid", "isUnique", "schemaStore", "", "", "getSchemaStore", "()Ljava/util/Map;", "isAvroConnectCompatible", "isFieldsValid", "validator", "Lorg/radarbase/schema/validation/rules/SchemaField;", "schemaErrorMessage", "Lkotlin/Function1;", "text", "Companion", "radar-schemas-core"})
public final class SchemaRules {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SchemaFieldRules fieldRules;
    @NotNull
    private final Map<String, Schema> schemaStore;
    @NotNull
    private final Validator<Schema> isUnique;
    @NotNull
    private final Validator<Schema> isNamespaceValid;
    @NotNull
    private final Validator<Schema> isNameValid;
    @NotNull
    private final Validator<Schema> isDocumentationValid;
    @NotNull
    private final Validator<Schema> isEnumSymbolsValid;
    @NotNull
    private final Validator<Schema> hasTime;
    @NotNull
    private final Validator<Schema> hasTimeCompleted;
    @NotNull
    private final Validator<Schema> hasNoTimeCompleted;
    @NotNull
    private final Validator<Schema> hasTimeReceived;
    @NotNull
    private final Validator<Schema> hasNoTimeReceived;
    @NotNull
    private final Validator<Schema> isEnumValid;
    @NotNull
    private final Validator<Schema> isRecordValid;
    @NotNull
    private final Validator<Schema> isActiveSourceValid;
    @NotNull
    private final Validator<Schema> isMonitorSourceValid;
    @NotNull
    private final Validator<Schema> isPassiveSourceValid;
    @NotNull
    public static final String TIME = "time";
    @NotNull
    private static final String TIME_RECEIVED = "timeReceived";
    @NotNull
    private static final String TIME_COMPLETED = "timeCompleted";
    @NotNull
    private static final Regex NAMESPACE_PATTERN = new Regex("[a-z]+(\\.[a-z]+)*");
    @NotNull
    private static final Regex RECORD_NAME_PATTERN = new Regex("([A-Z]([a-z]*[0-9]*))+[A-Z]?");
    @NotNull
    private static final Regex ENUM_SYMBOL_PATTERN = new Regex("[A-Z][A-Z0-9_]*");
    @NotNull
    private static final String WITH_TYPE_DOUBLE = "\" field with type \"double\".";

    public SchemaRules(@NotNull SchemaFieldRules fieldRules) {
        Intrinsics.checkNotNullParameter((Object)fieldRules, (String)"fieldRules");
        this.fieldRules = fieldRules;
        this.schemaStore = new HashMap();
        this.isUnique = DirectValidatorKt.Validator((Function2)new Function2<ValidationContext, Schema, Unit>(this){
            final /* synthetic */ SchemaRules this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull ValidationContext $this$Validator, @NotNull Schema schema) {
                Intrinsics.checkNotNullParameter((Object)$this$Validator, (String)"$this$Validator");
                Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
                String key = schema.getFullName();
                Schema oldSchema = this.this$0.getSchemaStore().putIfAbsent(key, schema);
                if (oldSchema != null && !Intrinsics.areEqual((Object)oldSchema, (Object)schema)) {
                    SchemaRulesKt.raise($this$Validator, schema, "Schema is already defined elsewhere with a different definition.");
                }
            }
        });
        this.isNamespaceValid = PredicateValidatorKt.validator((Function1)isNamespaceValid.1.INSTANCE, this.schemaErrorMessage("Namespace cannot be null and must fully lowercase, period-separated, without numeric characters."));
        this.isNameValid = PredicateValidatorKt.validator((Function1)isNameValid.1.INSTANCE, this.schemaErrorMessage("Record names must be camel case."));
        this.isDocumentationValid = DirectValidatorKt.Validator(isDocumentationValid.1.INSTANCE);
        this.isEnumSymbolsValid = DirectValidatorKt.Validator(isEnumSymbolsValid.1.INSTANCE);
        this.hasTime = PredicateValidatorKt.validator((Function1)hasTime.1.INSTANCE, this.schemaErrorMessage("Any schema representing collected data must have a \"time\" field with type \"double\"."));
        this.hasTimeCompleted = PredicateValidatorKt.validator((Function1)hasTimeCompleted.1.INSTANCE, this.schemaErrorMessage("Any ACTIVE schema must have a \"timeCompleted\" field with type \"double\"."));
        this.hasNoTimeCompleted = PredicateValidatorKt.validator((Function1)hasNoTimeCompleted.1.INSTANCE, this.schemaErrorMessage("\"timeCompleted\" is allow only in ACTIVE schemas."));
        this.hasTimeReceived = PredicateValidatorKt.validator((Function1)hasTimeReceived.1.INSTANCE, this.schemaErrorMessage("Any PASSIVE schema must have a \"timeReceived\" field with type \"double\"."));
        this.hasNoTimeReceived = PredicateValidatorKt.validator((Function1)hasNoTimeReceived.1.INSTANCE, this.schemaErrorMessage("\"timeReceived\" is allow only in PASSIVE schemas."));
        Validator[] validatorArray = new Validator[]{this.isUnique, this.isNamespaceValid, this.isEnumSymbolsValid, this.isDocumentationValid, this.isNameValid};
        this.isEnumValid = AllValidatorKt.all(validatorArray);
        this.fieldRules.setSchemaRules$radar_schemas_core(this);
        validatorArray = new Validator[]{this.isUnique, this.isAvroConnectCompatible(), this.isNamespaceValid, this.isNameValid, this.isDocumentationValid, this.isFieldsValid(this.fieldRules.isFieldValid())};
        this.isRecordValid = AllValidatorKt.all(validatorArray);
        validatorArray = new Validator[]{this.isRecordValid, this.hasTime};
        this.isActiveSourceValid = AllValidatorKt.all(validatorArray);
        validatorArray = new Validator[]{this.isRecordValid, this.hasTime};
        this.isMonitorSourceValid = AllValidatorKt.all(validatorArray);
        validatorArray = new Validator[]{this.isRecordValid, this.hasTime, this.hasTimeReceived, this.hasNoTimeCompleted};
        this.isPassiveSourceValid = AllValidatorKt.all(validatorArray);
    }

    public /* synthetic */ SchemaRules(SchemaFieldRules schemaFieldRules, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            schemaFieldRules = new SchemaFieldRules();
        }
        this(schemaFieldRules);
    }

    @NotNull
    public final SchemaFieldRules getFieldRules() {
        return this.fieldRules;
    }

    @NotNull
    public final Map<String, Schema> getSchemaStore() {
        return this.schemaStore;
    }

    @NotNull
    public final Validator<Schema> isUnique() {
        return this.isUnique;
    }

    @NotNull
    public final Validator<Schema> isNamespaceValid() {
        return this.isNamespaceValid;
    }

    @NotNull
    public final Validator<Schema> isNameValid() {
        return this.isNameValid;
    }

    @NotNull
    public final Validator<Schema> isDocumentationValid() {
        return this.isDocumentationValid;
    }

    @NotNull
    public final Validator<Schema> isEnumSymbolsValid() {
        return this.isEnumSymbolsValid;
    }

    @NotNull
    public final Validator<Schema> getHasTime() {
        return this.hasTime;
    }

    @NotNull
    public final Validator<Schema> getHasTimeCompleted() {
        return this.hasTimeCompleted;
    }

    @NotNull
    public final Validator<Schema> getHasNoTimeCompleted() {
        return this.hasNoTimeCompleted;
    }

    @NotNull
    public final Validator<Schema> getHasTimeReceived() {
        return this.hasTimeReceived;
    }

    @NotNull
    public final Validator<Schema> getHasNoTimeReceived() {
        return this.hasNoTimeReceived;
    }

    @NotNull
    public final Validator<Schema> isEnumValid() {
        return this.isEnumValid;
    }

    @NotNull
    public final Validator<Schema> isRecordValid() {
        return this.isRecordValid;
    }

    @NotNull
    public final Validator<Schema> isActiveSourceValid() {
        return this.isActiveSourceValid;
    }

    @NotNull
    public final Validator<Schema> isMonitorSourceValid() {
        return this.isMonitorSourceValid;
    }

    @NotNull
    public final Validator<Schema> isPassiveSourceValid() {
        return this.isPassiveSourceValid;
    }

    @NotNull
    public final Validator<Schema> isFieldsValid(@NotNull Validator<SchemaField> validator2) {
        Intrinsics.checkNotNullParameter(validator2, (String)"validator");
        return DirectValidatorKt.Validator((Function2)new Function2<ValidationContext, Schema, Unit>(validator2){
            final /* synthetic */ Validator<SchemaField> $validator;
            {
                this.$validator = $validator;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull ValidationContext $this$Validator, @NotNull Schema schema) {
                Intrinsics.checkNotNullParameter((Object)$this$Validator, (String)"$this$Validator");
                Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
                if (schema.getType() != Schema.Type.RECORD) {
                    ValidationContext.raise$default($this$Validator, "Default validation can be applied only to an Avro RECORD, not to " + schema.getType() + " of schema " + schema.getFullName() + ".", null, 2, null);
                } else if (schema.getFields().isEmpty()) {
                    ValidationContext.raise$default($this$Validator, "Schema " + schema.getFullName() + " does not contain any fields.", null, 2, null);
                } else {
                    Collection<SchemaField> collection;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    List list = schema.getFields();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getFields(...)");
                    Iterable iterable = list;
                    Validator<SchemaField> validator2 = this.$validator;
                    ValidationContext validationContext2 = $this$Validator;
                    boolean $i$f$map = false;
                    void var5_7 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        Schema.Field field = (Schema.Field)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        Intrinsics.checkNotNull((Object)it);
                        collection.add(new SchemaField(schema, (Schema.Field)it));
                    }
                    collection = (List)destination$iv$iv;
                    validationContext2.validateAll(validator2, (Iterable)collection);
                }
            }
        });
    }

    private final Validator<Schema> isAvroConnectCompatible() {
        AvroDataConfig avroConfig = new AvroDataConfig.Builder().with("connect.meta.data", (Object)false).with("schemas.cache.config", (Object)10).with("enhanced.avro.schema.support", (Object)true).build();
        return DirectValidatorKt.Validator((Function2)new Function2<ValidationContext, Schema, Unit>(avroConfig){
            final /* synthetic */ AvroDataConfig $avroConfig;
            {
                this.$avroConfig = $avroConfig;
                super(2);
            }

            public final void invoke(@NotNull ValidationContext $this$Validator, @NotNull Schema schema) {
                Intrinsics.checkNotNullParameter((Object)$this$Validator, (String)"$this$Validator");
                Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
                AvroData encoder = new AvroData(10);
                AvroData decoder = new AvroData(this.$avroConfig);
                try {
                    org.apache.kafka.connect.data.Schema connectSchema = encoder.toConnectSchema(schema);
                    Schema originalSchema = decoder.fromConnectSchema(connectSchema);
                    if (!Intrinsics.areEqual((Object)schema, (Object)originalSchema)) {
                        boolean bl = false;
                        String string = "Schema changed by validation: " + schema.toString(true) + " is not equal to " + originalSchema.toString(true);
                        throw new IllegalStateException(string.toString());
                    }
                }
                catch (Exception ex) {
                    ValidationContext.raise$default($this$Validator, "Failed to convert schema back to itself", null, 2, null);
                }
            }
        });
    }

    private final Function1<Schema, String> schemaErrorMessage(String text) {
        return (Function1)new Function1<Schema, String>(text){
            final /* synthetic */ String $text;
            {
                this.$text = $text;
                super(1);
            }

            @NotNull
            public final String invoke(@NotNull Schema schema) {
                Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
                return "Schema " + schema.getFullName() + " is invalid. " + this.$text;
            }
        };
    }

    public SchemaRules() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JL\u0010\u0010\u001a\u00020\u0011\"\u0004\b\u0000\u0010\u0012*\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\f2#\u0010\u0015\u001a\u001f\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u0002H\u0012\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00110\u0016\u00a2\u0006\u0002\b\u00172\u0006\u0010\u0018\u001a\u0002H\u0012\u00a2\u0006\u0002\u0010\u0019R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u000e\u0010\u000b\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/radarbase/schema/validation/rules/SchemaRules$Companion;", "", "()V", "ENUM_SYMBOL_PATTERN", "Lkotlin/text/Regex;", "getENUM_SYMBOL_PATTERN", "()Lkotlin/text/Regex;", "NAMESPACE_PATTERN", "getNAMESPACE_PATTERN", "RECORD_NAME_PATTERN", "getRECORD_NAME_PATTERN", "TIME", "", "TIME_COMPLETED", "TIME_RECEIVED", "WITH_TYPE_DOUBLE", "validateDocumentation", "", "T", "Lorg/radarbase/schema/validation/ValidationContext;", "doc", "raise", "Lkotlin/Function3;", "Lkotlin/ExtensionFunctionType;", "schema", "(Lorg/radarbase/schema/validation/ValidationContext;Ljava/lang/String;Lkotlin/jvm/functions/Function3;Ljava/lang/Object;)V", "radar-schemas-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Regex getNAMESPACE_PATTERN() {
            return NAMESPACE_PATTERN;
        }

        @NotNull
        public final Regex getRECORD_NAME_PATTERN() {
            return RECORD_NAME_PATTERN;
        }

        @NotNull
        public final Regex getENUM_SYMBOL_PATTERN() {
            return ENUM_SYMBOL_PATTERN;
        }

        public final <T> void validateDocumentation(@NotNull ValidationContext $this$validateDocumentation, @Nullable String doc, @NotNull Function3<? super ValidationContext, ? super T, ? super String, Unit> raise, T schema) {
            Intrinsics.checkNotNullParameter((Object)$this$validateDocumentation, (String)"<this>");
            Intrinsics.checkNotNullParameter(raise, (String)"raise");
            CharSequence charSequence = doc;
            if (charSequence == null || charSequence.length() == 0) {
                raise.invoke((Object)$this$validateDocumentation, schema, (Object)"Property \"doc\" is missing. Documentation is mandatory for all fields.\n The documentation should report what is being measured, how, and what\n  units or ranges are applicable. Abbreviations and acronyms in the\n   documentation should be written out. The sentence must end with a\n    period '.'. Please add \"doc\" property.");
                return;
            }
            if (doc.charAt(doc.length() - 1) != '.') {
                raise.invoke((Object)$this$validateDocumentation, schema, (Object)"Documentation is not terminated with a period. The documentation should report what is being measured, how, and what units or ranges are applicable. Abbreviations and acronyms in the documentation should be written out. Please end the sentence with a period '.'.");
            }
            if (!Character.isUpperCase(doc.charAt(0))) {
                raise.invoke((Object)$this$validateDocumentation, schema, (Object)"Documentation does not start with a capital letter. The documentation should report what is being measured, how, and what units or ranges are applicable. Abbreviations and acronyms in the documentation should be written out. Please end the sentence with a period '.'.");
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

