/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.schema.specification;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.radarbase.config.AvroTopicConfig;
import org.radarbase.config.OpenConfig;
import org.radarbase.schema.SchemaCatalogue;
import org.radarbase.schema.specification.AppDataTopic;
import org.radarbase.schema.specification.SampleRateConfig;
import org.radarbase.schema.util.SchemaUtils;
import org.radarbase.topic.AvroTopic;
import org.radarcns.catalogue.Unit;
import org.radarcns.kafka.ObservationKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@OpenConfig
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 /2\u00020\u0001:\u0001/B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\"\u001a\u00020#2\u0014\u0010$\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010&0%2\u0006\u0010'\u001a\u00020(H\u0014J\b\u0010)\u001a\u00020\u0004H\u0016J\u0010\u0010)\u001a\u00020\u00042\u0006\u0010*\u001a\u00020(H\u0016J\u001e\u0010+\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030,0\u00162\u0006\u0010-\u001a\u00020.H\u0017R\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0016X\u0097\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b8\u0016X\u0097\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR*\u0010\r\u001a\u0004\u0018\u00010\u00042\b\u0010\f\u001a\u0004\u0018\u00010\u00048\u0016@WX\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0006\"\u0004\b\u000f\u0010\u0010R\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u00128\u0016X\u0097\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u00168WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0018\u0010\u0019\u001a\u0004\u0018\u00010\u00048\u0016X\u0097\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0006R\u0018\u0010\u001b\u001a\u0004\u0018\u00010\u001c8\u0016X\u0097\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR*\u0010\u001f\u001a\u0004\u0018\u00010\u00042\b\u0010\f\u001a\u0004\u0018\u00010\u00048\u0016@WX\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0006\"\u0004\b!\u0010\u0010\u00a8\u00060"}, d2={"Lorg/radarbase/schema/specification/DataTopic;", "Lorg/radarbase/config/AvroTopicConfig;", "()V", "doc", "", "getDoc", "()Ljava/lang/String;", "fields", "", "Lorg/radarbase/schema/specification/AppDataTopic$DataField;", "getFields", "()Ljava/util/List;", "schema", "keySchema", "getKeySchema", "setKeySchema", "(Ljava/lang/String;)V", "sampleRate", "Lorg/radarbase/schema/specification/SampleRateConfig;", "getSampleRate", "()Lorg/radarbase/schema/specification/SampleRateConfig;", "topicNames", "Ljava/util/stream/Stream;", "getTopicNames", "()Ljava/util/stream/Stream;", "type", "getType", "unit", "Lorg/radarcns/catalogue/Unit;", "getUnit", "()Lorg/radarcns/catalogue/Unit;", "valueSchema", "getValueSchema", "setValueSchema", "propertiesMap", "", "map", "", "", "reduced", "", "toString", "prettyString", "topics", "Lorg/radarbase/topic/AvroTopic;", "schemaCatalogue", "Lorg/radarbase/schema/SchemaCatalogue;", "Companion", "radar-schemas-core"})
public class DataTopic
extends AvroTopicConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JsonProperty
    @Nullable
    private final String type;
    @JsonProperty
    @Nullable
    private final String doc;
    @JsonProperty(value="sample_rate")
    @Nullable
    private final SampleRateConfig sampleRate;
    @JsonProperty
    @Nullable
    private final Unit unit;
    @JsonProperty
    @Nullable
    private final List<AppDataTopic.DataField> fields;
    @JsonProperty(value="key_schema")
    @Nullable
    private String keySchema = ObservationKey.class.getName();
    @JsonProperty(value="value_schema")
    @Nullable
    private String valueSchema;
    private static final Logger logger = LoggerFactory.getLogger(DataTopic.class);

    @Nullable
    public String getType() {
        return this.type;
    }

    @Nullable
    public String getDoc() {
        return this.doc;
    }

    @Nullable
    public SampleRateConfig getSampleRate() {
        return this.sampleRate;
    }

    @Nullable
    public Unit getUnit() {
        return this.unit;
    }

    @Nullable
    public List<AppDataTopic.DataField> getFields() {
        return this.fields;
    }

    @JsonIgnore
    @NotNull
    public Stream<String> getTopicNames() {
        Stream<String> stream = Stream.of(this.getTopic());
        Intrinsics.checkNotNullExpressionValue(stream, (String)"of(...)");
        return stream;
    }

    @JsonIgnore
    @NotNull
    public Stream<AvroTopic<?, ?>> topics(@NotNull SchemaCatalogue schemaCatalogue) throws IOException {
        Intrinsics.checkNotNullParameter((Object)schemaCatalogue, (String)"schemaCatalogue");
        Stream<AvroTopic<?, ?>> stream = Stream.of(schemaCatalogue.genericAvroTopic(this));
        Intrinsics.checkNotNullExpressionValue(stream, (String)"of(...)");
        return stream;
    }

    @Nullable
    public String getKeySchema() {
        return this.keySchema;
    }

    @JsonSetter
    public void setKeySchema(@Nullable String schema) {
        this.keySchema = SchemaUtils.INSTANCE.expandClass(schema);
    }

    @Nullable
    public String getValueSchema() {
        return this.valueSchema;
    }

    @JsonSetter
    public void setValueSchema(@Nullable String schema) {
        this.valueSchema = SchemaUtils.INSTANCE.expandClass(schema);
    }

    @NotNull
    public String toString() {
        return this.toString(false);
    }

    @NotNull
    public String toString(boolean prettyString) {
        String string;
        String name = ((Object)((Object)this)).getClass().getSimpleName();
        Map properties = new LinkedHashMap();
        this.propertiesMap(properties, !prettyString);
        if (prettyString) {
            Object object;
            YAMLFactory $this$toString_u24lambda_u240 = object = new YAMLFactory();
            boolean bl = false;
            $this$toString_u24lambda_u240.disable(YAMLGenerator.Feature.WRITE_DOC_START_MARKER);
            $this$toString_u24lambda_u240.enable(YAMLGenerator.Feature.MINIMIZE_QUOTES);
            JsonFactory jsonFactory = (JsonFactory)object;
            ObjectMapper mapper2 = new ObjectMapper(jsonFactory);
            try {
                object = mapper2.writeValueAsString((Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)name, (Object)properties)));
            }
            catch (JsonProcessingException ex) {
                logger.error("Failed to convert data to YAML", (Throwable)ex);
                object = name + properties;
            }
            Object object2 = object;
            Intrinsics.checkNotNull((Object)object2);
            string = object2;
        } else {
            string = name + properties;
        }
        return string;
    }

    protected void propertiesMap(@NotNull Map<String, Object> map, boolean reduced) {
        String topic;
        Intrinsics.checkNotNullParameter(map, (String)"map");
        map.put("type", this.getType());
        if (!reduced && this.getDoc() != null) {
            map.put("doc", this.getDoc());
        }
        if ((topic = this.getTopic()) != null) {
            map.put("topic", topic);
        }
        map.put("key_schema", this.getKeySchema());
        map.put("value_schema", this.getValueSchema());
        if (!reduced) {
            if (this.getSampleRate() != null) {
                map.put("sample_rate", this.getSampleRate());
            }
            if (this.getUnit() != null) {
                map.put("unit", this.getUnit());
            }
            if (this.getFields() != null) {
                map.put("fields", this.getFields());
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/radarbase/schema/specification/DataTopic$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "radar-schemas-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

