/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.schema.validation.rules;

import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.radarbase.schema.validation.rules.SchemaField;
import org.radarbase.schema.validation.rules.SchemaFieldRules;
import org.radarbase.schema.validation.rules.Validator;

public interface SchemaRules {
    public SchemaFieldRules getFieldRules();

    public Validator<Schema> validateUniqueness();

    public Validator<Schema> validateNameSpace();

    public Validator<Schema> validateName();

    public Validator<Schema> validateSchemaDocumentation();

    public Validator<Schema> validateSymbols();

    public Validator<Schema> validateTime();

    public Validator<Schema> validateTimeCompleted();

    public Validator<Schema> validateNotTimeCompleted();

    public Validator<Schema> validateTimeReceived();

    public Validator<Schema> validateNotTimeReceived();

    default public Validator<Schema> validateEnum() {
        return this.validateUniqueness().and(this.validateNameSpace()).and(this.validateSymbols()).and(this.validateSchemaDocumentation()).and(this.validateName());
    }

    default public Validator<Schema> validateRecord() {
        return this.validateUniqueness().and(this.validateAvroData()).and(this.validateNameSpace()).and(this.validateName()).and(this.validateSchemaDocumentation()).and(this.fields(this.getFieldRules().getValidator(this)));
    }

    public Validator<Schema> validateAvroData();

    default public Validator<Schema> validateActiveSource() {
        return this.validateRecord().and(this.validateTime().and(this.validateTimeCompleted()).and(this.validateNotTimeReceived()));
    }

    default public Validator<Schema> validateMonitor() {
        return this.validateRecord().and(this.validateTime());
    }

    default public Validator<Schema> validatePassive() {
        return this.validateRecord().and(this.validateTime()).and(this.validateTimeReceived()).and(this.validateNotTimeCompleted());
    }

    default public Function<Schema, String> messageSchema(String text) {
        return schema -> "Schema " + schema.getFullName() + " is invalid. " + text;
    }

    default public Validator<Schema> fields(Validator<SchemaField> validator) {
        return schema -> {
            if (!schema.getType().equals((Object)Schema.Type.RECORD)) {
                return Validator.raise("Default validation can be applied only to an Avro RECORD, not to " + schema.getType() + " of schema " + schema.getFullName() + ".");
            }
            if (schema.getFields().isEmpty()) {
                return Validator.raise("Schema " + schema.getFullName() + " does not contain any fields.");
            }
            return schema.getFields().stream().flatMap(field -> (Stream)validator.apply(new SchemaField((Schema)schema, (Schema.Field)field)));
        };
    }
}

