/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.schema.validation.rules;

import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.apache.avro.Schema;
import org.jetbrains.annotations.NotNull;
import org.radarbase.schema.Scope;
import org.radarbase.schema.validation.rules.SchemaMetadata;
import org.radarbase.schema.validation.rules.SchemaRules;
import org.radarbase.schema.validation.rules.Validator;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\u001c\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u0007H\u0016J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0013"}, d2={"Lorg/radarbase/schema/validation/rules/SchemaMetadataRules;", "", "schemaRules", "Lorg/radarbase/schema/validation/rules/SchemaRules;", "getSchemaRules", "()Lorg/radarbase/schema/validation/rules/SchemaRules;", "getValidator", "Lorg/radarbase/schema/validation/rules/Validator;", "Lorg/radarbase/schema/validation/rules/SchemaMetadata;", "validateScopeSpecific", "", "message", "Lkotlin/Function1;", "", "text", "schema", "validator", "Lorg/apache/avro/Schema;", "validateSchemaLocation", "radar-schemas-core"})
public interface SchemaMetadataRules {
    @NotNull
    public SchemaRules getSchemaRules();

    @NotNull
    public Validator<SchemaMetadata> validateSchemaLocation();

    @NotNull
    public Validator<SchemaMetadata> getValidator(boolean var1);

    @NotNull
    public Validator<SchemaMetadata> schema(@NotNull Validator<Schema> var1);

    @NotNull
    public Function1<SchemaMetadata, String> message(@NotNull String var1);

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Scope.values().length];
            try {
                nArray[Scope.ACTIVE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Scope.MONITOR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Scope.PASSIVE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static Validator<SchemaMetadata> getValidator(@NotNull SchemaMetadataRules $this, boolean validateScopeSpecific) {
            return arg_0 -> DefaultImpls.getValidator$lambda$0($this, validateScopeSpecific, arg_0);
        }

        @NotNull
        public static Validator<SchemaMetadata> schema(@NotNull SchemaMetadataRules $this, @NotNull Validator<Schema> validator) {
            Intrinsics.checkNotNullParameter(validator, (String)"validator");
            return arg_0 -> DefaultImpls.schema$lambda$1(validator, arg_0);
        }

        @NotNull
        public static Function1<SchemaMetadata, String> message(@NotNull SchemaMetadataRules $this, @NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            return (Function1)new Function1<SchemaMetadata, String>(text){
                final /* synthetic */ String $text;
                {
                    this.$text = $text;
                    super(1);
                }

                @NotNull
                public final String invoke(@NotNull SchemaMetadata metadata) {
                    Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
                    return "Schema " + metadata.getSchema().getFullName() + " at " + metadata.getPath() + " is invalid. " + this.$text;
                }
            };
        }

        private static Stream getValidator$lambda$0(SchemaMetadataRules this$0, boolean $validateScopeSpecific, SchemaMetadata metadata) {
            Validator<SchemaMetadata> validator;
            Validator<SchemaMetadata> validator2;
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
            SchemaRules schemaRules = this$0.getSchemaRules();
            Validator<SchemaMetadata> validator3 = this$0.validateSchemaLocation();
            if (metadata.getSchema().getType() == Schema.Type.ENUM) {
                Validator<Schema> validator4 = schemaRules.validateEnum();
                Intrinsics.checkNotNullExpressionValue(validator4, (String)"schemaRules.validateEnum()");
                validator2 = validator3.and(this$0.schema(validator4));
                Intrinsics.checkNotNullExpressionValue(validator2, (String)"{\n                valida\u2026ateEnum()))\n            }");
                validator = validator2;
            } else if ($validateScopeSpecific) {
                Validator<SchemaMetadata> validator5;
                Scope scope = metadata.getScope();
                switch (scope == null ? -1 : WhenMappings.$EnumSwitchMapping$0[scope.ordinal()]) {
                    case 1: {
                        Validator<Schema> validator6 = schemaRules.validateActiveSource();
                        Intrinsics.checkNotNullExpressionValue(validator6, (String)"schemaRules.validateActiveSource()");
                        validator5 = validator3.and(this$0.schema(validator6));
                        break;
                    }
                    case 2: {
                        Validator<Schema> validator7 = schemaRules.validateMonitor();
                        Intrinsics.checkNotNullExpressionValue(validator7, (String)"schemaRules.validateMonitor()");
                        validator5 = validator3.and(this$0.schema(validator7));
                        break;
                    }
                    case 3: {
                        Validator<Schema> validator8 = schemaRules.validatePassive();
                        Intrinsics.checkNotNullExpressionValue(validator8, (String)"schemaRules.validatePassive()");
                        validator5 = validator3.and(this$0.schema(validator8));
                        break;
                    }
                    default: {
                        Validator<Schema> validator9 = schemaRules.validateRecord();
                        Intrinsics.checkNotNullExpressionValue(validator9, (String)"schemaRules.validateRecord()");
                        validator5 = validator3.and(this$0.schema(validator9));
                    }
                }
                validator2 = validator5;
                Intrinsics.checkNotNullExpressionValue(validator2, (String)"{\n                when (\u2026          }\n            }");
                validator = validator2;
            } else {
                Validator<Schema> validator10 = schemaRules.validateRecord();
                Intrinsics.checkNotNullExpressionValue(validator10, (String)"schemaRules.validateRecord()");
                validator2 = validator3.and(this$0.schema(validator10));
                Intrinsics.checkNotNullExpressionValue(validator2, (String)"{\n                valida\u2026eRecord()))\n            }");
                validator = validator2;
            }
            validator3 = validator;
            return (Stream)validator3.apply(metadata);
        }

        private static Stream schema$lambda$1(Validator $validator, SchemaMetadata metadata) {
            Intrinsics.checkNotNullParameter((Object)$validator, (String)"$validator");
            Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
            return (Stream)$validator.apply(metadata.getSchema());
        }
    }
}

