/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.schema.validation.rules;

import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.radarbase.schema.validation.rules.SchemaField;
import org.radarbase.schema.validation.rules.SchemaRules;
import org.radarbase.schema.validation.rules.Validator;

public interface SchemaFieldRules {
    public Validator<SchemaField> validateFieldTypes(SchemaRules var1);

    public Validator<SchemaField> validateFieldName();

    public Validator<SchemaField> validateFieldDocumentation();

    public Validator<SchemaField> validateDefault();

    default public Validator<SchemaField> getValidator(SchemaRules schemaRules) {
        return this.validateFieldTypes(schemaRules).and(this.validateFieldName()).and(this.validateDefault()).and(this.validateFieldDocumentation());
    }

    default public Validator<SchemaField> validateInternalUnion(SchemaRules schemaRules) {
        return field -> field.getField().schema().getTypes().stream().flatMap(schema -> {
            Schema.Type type = schema.getType();
            if (type == Schema.Type.RECORD) {
                return (Stream)schemaRules.validateRecord().apply((Schema)schema);
            }
            if (type == Schema.Type.ENUM) {
                return (Stream)schemaRules.validateEnum().apply((Schema)schema);
            }
            if (type == Schema.Type.UNION) {
                return Validator.raise(this.message("Cannot have a nested union.").apply((SchemaField)field));
            }
            return Validator.valid();
        });
    }

    default public Function<SchemaField, String> message(String text) {
        return schema -> "Field " + schema.getField().name() + " in schema " + schema.getSchema().getFullName() + " is invalid. " + text;
    }
}

