/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.schema.validation.rules;

import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.avro.Schema;
import org.jetbrains.annotations.NotNull;
import org.radarbase.schema.specification.config.SchemaConfig;
import org.radarbase.schema.validation.ValidationHelper;
import org.radarbase.schema.validation.rules.RadarSchemaRules;
import org.radarbase.schema.validation.rules.SchemaMetadata;
import org.radarbase.schema.validation.rules.SchemaMetadataRules;
import org.radarbase.schema.validation.rules.SchemaRules;
import org.radarbase.schema.validation.rules.Validator;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B!\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000eH\u0016J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0015"}, d2={"Lorg/radarbase/schema/validation/rules/RadarSchemaMetadataRules;", "Lorg/radarbase/schema/validation/rules/SchemaMetadataRules;", "schemaRoot", "Ljava/nio/file/Path;", "config", "Lorg/radarbase/schema/specification/config/SchemaConfig;", "schemaRules", "Lorg/radarbase/schema/validation/rules/SchemaRules;", "(Ljava/nio/file/Path;Lorg/radarbase/schema/specification/config/SchemaConfig;Lorg/radarbase/schema/validation/rules/SchemaRules;)V", "pathMatcher", "Ljava/nio/file/PathMatcher;", "getSchemaRules", "()Lorg/radarbase/schema/validation/rules/SchemaRules;", "schema", "Lorg/radarbase/schema/validation/rules/Validator;", "Lorg/radarbase/schema/validation/rules/SchemaMetadata;", "validator", "Lorg/apache/avro/Schema;", "validateNameSchemaLocation", "validateNamespaceSchemaLocation", "validateSchemaLocation", "radar-schemas-core"})
public final class RadarSchemaMetadataRules
implements SchemaMetadataRules {
    @NotNull
    private final Path schemaRoot;
    @NotNull
    private final SchemaRules schemaRules;
    @NotNull
    private final PathMatcher pathMatcher;

    @JvmOverloads
    public RadarSchemaMetadataRules(@NotNull Path schemaRoot, @NotNull SchemaConfig config, @NotNull SchemaRules schemaRules) {
        Intrinsics.checkNotNullParameter((Object)schemaRoot, (String)"schemaRoot");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)schemaRules, (String)"schemaRules");
        this.schemaRoot = schemaRoot;
        this.schemaRules = schemaRules;
        this.pathMatcher = config.pathMatcher(this.schemaRoot);
    }

    public /* synthetic */ RadarSchemaMetadataRules(Path path, SchemaConfig schemaConfig, SchemaRules schemaRules, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            schemaRules = new RadarSchemaRules();
        }
        this(path, schemaConfig, schemaRules);
    }

    @Override
    @NotNull
    public SchemaRules getSchemaRules() {
        return this.schemaRules;
    }

    @Override
    @NotNull
    public Validator<SchemaMetadata> validateSchemaLocation() {
        Validator<SchemaMetadata> validator = this.validateNamespaceSchemaLocation().and(this.validateNameSchemaLocation());
        Intrinsics.checkNotNullExpressionValue(validator, (String)"validateNamespaceSchemaL\u2026dateNameSchemaLocation())");
        return validator;
    }

    private final Validator<SchemaMetadata> validateNamespaceSchemaLocation() {
        return arg_0 -> RadarSchemaMetadataRules.validateNamespaceSchemaLocation$lambda$0(this, arg_0);
    }

    private final Validator<SchemaMetadata> validateNameSchemaLocation() {
        return arg_0 -> RadarSchemaMetadataRules.validateNameSchemaLocation$lambda$1(this, arg_0);
    }

    @Override
    @NotNull
    public Validator<SchemaMetadata> schema(@NotNull Validator<Schema> validator) {
        Intrinsics.checkNotNullParameter(validator, (String)"validator");
        return arg_0 -> RadarSchemaMetadataRules.schema$lambda$2(this, validator, arg_0);
    }

    @Override
    @NotNull
    public Validator<SchemaMetadata> getValidator(boolean validateScopeSpecific) {
        return SchemaMetadataRules.DefaultImpls.getValidator(this, validateScopeSpecific);
    }

    @Override
    @NotNull
    public Function1<SchemaMetadata, String> message(@NotNull String text) {
        return SchemaMetadataRules.DefaultImpls.message(this, text);
    }

    @JvmOverloads
    public RadarSchemaMetadataRules(@NotNull Path schemaRoot, @NotNull SchemaConfig config) {
        Intrinsics.checkNotNullParameter((Object)schemaRoot, (String)"schemaRoot");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this(schemaRoot, config, null, 4, null);
    }

    private static final Stream validateNamespaceSchemaLocation$lambda$0(RadarSchemaMetadataRules this$0, SchemaMetadata metadata) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        try {
            String expected = ValidationHelper.getNamespace(this$0.schemaRoot, metadata.getPath(), metadata.getScope());
            String namespace = metadata.getSchema().getNamespace();
            return Validator.check(StringsKt.equals((String)expected, (String)namespace, (boolean)true), (String)this$0.message("Namespace cannot be null and must fully lowercase dot separated without numeric. In this case the expected value is \"" + expected + "\".").invoke((Object)metadata));
        }
        catch (IllegalArgumentException ex) {
            return Validator.raise("Path " + metadata.getPath() + " is not part of root " + this$0.schemaRoot, ex);
        }
    }

    private static final Stream validateNameSchemaLocation$lambda$1(RadarSchemaMetadataRules this$0, SchemaMetadata metadata) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        String expected = ValidationHelper.getRecordName(metadata.getPath());
        return StringsKt.equals((String)expected, (String)metadata.getSchema().getName(), (boolean)true) ? Validator.valid() : Validator.raise((String)this$0.message("Record name should match file name. Expected record name is \"" + expected + "\".").invoke((Object)metadata));
    }

    private static final Stream schema$lambda$2(RadarSchemaMetadataRules this$0, Validator $validator, SchemaMetadata metadata) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$validator, (String)"$validator");
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        return this$0.pathMatcher.matches(metadata.getPath()) ? (Stream)$validator.apply(metadata.getSchema()) : Validator.valid();
    }
}

