/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.schema.validation;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.stream.Stream;
import org.radarbase.schema.Scope;
import org.radarbase.schema.specification.config.SchemaConfig;
import org.radarbase.schema.validation.ValidationHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpecificationsValidator {
    private static final Logger logger = LoggerFactory.getLogger(SpecificationsValidator.class);
    public static final String YML_EXTENSION = "yml";
    private final Path specificationsRoot;
    private final ObjectMapper mapper;
    private final PathMatcher pathMatcher;

    public SpecificationsValidator(Path root, SchemaConfig config) {
        this.specificationsRoot = root.resolve("specifications");
        this.pathMatcher = config.pathMatcher(this.specificationsRoot);
        this.mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
    }

    public boolean specificationsAreYmlFiles(Scope scope) throws IOException {
        Path baseFolder = scope.getPath(this.specificationsRoot);
        if (baseFolder == null) {
            logger.info("{} sources folder not present at {}", (Object)scope, (Object)this.specificationsRoot.resolve(scope.getLower()));
            return false;
        }
        try (Stream<Path> walker = Files.walk(baseFolder, new FileVisitOption[0]);){
            boolean bl = walker.filter(this.pathMatcher::matches).allMatch(SpecificationsValidator::isYmlFile);
            return bl;
        }
    }

    public <T> boolean checkSpecificationParsing(Scope scope, Class<T> clazz) throws IOException {
        Path baseFolder = scope.getPath(this.specificationsRoot);
        if (baseFolder == null) {
            logger.info("{} sources folder not present at {}", (Object)scope, (Object)this.specificationsRoot.resolve(scope.getLower()));
            return false;
        }
        try (Stream<Path> walker = Files.walk(baseFolder, new FileVisitOption[0]);){
            boolean bl = walker.filter(this.pathMatcher::matches).allMatch(f -> {
                try {
                    this.mapper.readerFor(clazz).readValue(f.toFile());
                    return true;
                }
                catch (IOException ex) {
                    logger.error("Failed to load configuration {}: {}", f, (Object)ex.toString());
                    return false;
                }
            });
            return bl;
        }
    }

    private static boolean isYmlFile(Path path) {
        return ValidationHelper.matchesExtension(path, YML_EXTENSION);
    }
}

