/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.schema.validation;

import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.avro.Schema;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.radarbase.schema.SchemaCatalogue;
import org.radarbase.schema.Scope;
import org.radarbase.schema.specification.DataProducer;
import org.radarbase.schema.specification.DataTopic;
import org.radarbase.schema.specification.SourceCatalogue;
import org.radarbase.schema.specification.config.SchemaConfig;
import org.radarbase.schema.validation.SchemaValidator;
import org.radarbase.schema.validation.ValidationException;
import org.radarbase.schema.validation.ValidationHelper;
import org.radarbase.schema.validation.rules.RadarSchemaMetadataRules;
import org.radarbase.schema.validation.rules.RadarSchemaRules;
import org.radarbase.schema.validation.rules.SchemaMetadata;
import org.radarbase.schema.validation.rules.SchemaMetadataRules;
import org.radarbase.schema.validation.rules.SchemaRules;
import org.radarbase.schema.validation.rules.Validator;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 $2\u00020\u0001:\u0001$B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0019\u001a\u00020\u001aJ\u001e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001e\u001a\u00020\u001fJ$\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010!\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u001cJ\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010#\u001a\u00020\u0015H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/radarbase/schema/validation/SchemaValidator;", "", "schemaRoot", "Ljava/nio/file/Path;", "config", "Lorg/radarbase/schema/specification/config/SchemaConfig;", "(Ljava/nio/file/Path;Lorg/radarbase/schema/specification/config/SchemaConfig;)V", "pathMatcher", "Ljava/nio/file/PathMatcher;", "rules", "Lorg/radarbase/schema/validation/rules/SchemaMetadataRules;", "getRules", "()Lorg/radarbase/schema/validation/rules/SchemaMetadataRules;", "validatedSchemas", "", "", "Lorg/apache/avro/Schema;", "getValidatedSchemas", "()Ljava/util/Map;", "validator", "Lorg/radarbase/schema/validation/rules/Validator;", "Lorg/radarbase/schema/validation/rules/SchemaMetadata;", "analyseFiles", "Ljava/util/stream/Stream;", "Lorg/radarbase/schema/validation/ValidationException;", "schemaCatalogue", "Lorg/radarbase/schema/SchemaCatalogue;", "scope", "Lorg/radarbase/schema/Scope;", "analyseSourceCatalogue", "catalogue", "Lorg/radarbase/schema/specification/SourceCatalogue;", "validate", "schema", "path", "schemaMetadata", "Companion", "radar-schemas-core"})
public final class SchemaValidator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SchemaMetadataRules rules;
    @NotNull
    private final PathMatcher pathMatcher;
    @NotNull
    private Validator<SchemaMetadata> validator;
    @NotNull
    private static final String AVRO_EXTENSION = "avsc";

    public SchemaValidator(@NotNull Path schemaRoot, @NotNull SchemaConfig config) {
        Intrinsics.checkNotNullParameter((Object)schemaRoot, (String)"schemaRoot");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.pathMatcher = config.pathMatcher(schemaRoot);
        this.rules = new RadarSchemaMetadataRules(schemaRoot, config, null, 4, null);
        this.validator = this.rules.getValidator(false);
    }

    @NotNull
    public final SchemaMetadataRules getRules() {
        return this.rules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Stream<ValidationException> analyseSourceCatalogue(@Nullable Scope scope, @NotNull SourceCatalogue catalogue) {
        Stream<Object> stream;
        Stream<Object> stream2;
        Intrinsics.checkNotNullParameter((Object)catalogue, (String)"catalogue");
        this.validator = this.rules.getValidator(true);
        if (scope != null) {
            stream2 = catalogue.getSources().stream().filter(arg_0 -> SchemaValidator.analyseSourceCatalogue$lambda$0((Function1)new Function1<DataProducer<?>, Boolean>(scope){
                final /* synthetic */ Scope $scope;
                {
                    this.$scope = $scope;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(DataProducer<?> it) {
                    return it.getScope() == this.$scope;
                }
            }, arg_0));
            Intrinsics.checkNotNullExpressionValue(stream2, (String)"scope: Scope?, catalogue\u2026cope == scope }\n        }");
            stream = stream2;
        } else {
            Stream stream3 = catalogue.getSources().stream();
            stream = stream3;
            Intrinsics.checkNotNullExpressionValue(stream3, (String)"{\n            catalogue.sources.stream()\n        }");
        }
        Stream producers2 = stream;
        try {
            stream2 = producers2.flatMap(arg_0 -> SchemaValidator.analyseSourceCatalogue$lambda$1(analyseSourceCatalogue.1.INSTANCE, arg_0)).flatMap(arg_0 -> SchemaValidator.analyseSourceCatalogue$lambda$2((Function1)new Function1<DataTopic, Stream<? extends SchemaMetadata>>(catalogue){
                final /* synthetic */ SourceCatalogue $catalogue;
                {
                    this.$catalogue = $catalogue;
                    super(1);
                }

                public final Stream<? extends SchemaMetadata> invoke(DataTopic topic) {
                    SchemaCatalogue schemaCatalogue = this.$catalogue.getSchemaCatalogue();
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)topic), (String)"topic");
                    Pair<SchemaMetadata, SchemaMetadata> pair = schemaCatalogue.getSchemaMetadata(topic);
                    SchemaMetadata keySchema = (SchemaMetadata)pair.component1();
                    SchemaMetadata valueSchema = (SchemaMetadata)pair.component2();
                    SchemaMetadata[] schemaMetadataArray = new SchemaMetadata[]{keySchema, valueSchema};
                    return Stream.of(schemaMetadataArray);
                }
            }, arg_0)).sorted(Comparator.comparing(arg_0 -> SchemaValidator.analyseSourceCatalogue$lambda$3(analyseSourceCatalogue.3.INSTANCE, arg_0))).distinct().flatMap(arg_0 -> SchemaValidator.analyseSourceCatalogue$lambda$4((Function1)new Function1<SchemaMetadata, Stream<ValidationException>>((Object)this){

                @NotNull
                public final Stream<ValidationException> invoke(@NotNull SchemaMetadata p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return SchemaValidator.access$validate((SchemaValidator)this.receiver, p0);
                }
            }, arg_0)).distinct();
            Intrinsics.checkNotNullExpressionValue(stream2, (String)"catalogue: SourceCatalog\u2026    .distinct()\n        }");
        }
        finally {
            this.validator = this.rules.getValidator(false);
        }
        return stream2;
    }

    @NotNull
    public final Stream<ValidationException> analyseFiles(@Nullable Scope scope, @NotNull SchemaCatalogue schemaCatalogue) {
        Intrinsics.checkNotNullParameter((Object)schemaCatalogue, (String)"schemaCatalogue");
        if (scope == null) {
            return this.analyseFiles(schemaCatalogue);
        }
        this.validator = this.rules.getValidator(false);
        Object object = MapsKt.createMapBuilder();
        Map $this$analyseFiles_u24lambda_u246 = object;
        boolean bl = false;
        Map<String, SchemaMetadata> $this$forEach$iv = schemaCatalogue.getSchemas();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, SchemaMetadata>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, SchemaMetadata> element$iv;
            Map.Entry<String, SchemaMetadata> entry = element$iv = iterator.next();
            boolean bl2 = false;
            String key = entry.getKey();
            SchemaMetadata value = entry.getValue();
            if (value.getScope() != scope) continue;
            $this$analyseFiles_u24lambda_u246.put(key, value.getSchema());
        }
        Map useTypes = MapsKt.build((Map)object);
        object = Stream.concat(schemaCatalogue.getUnmappedAvroFiles().stream().filter(arg_0 -> SchemaValidator.analyseFiles$lambda$7((Function1)new Function1<SchemaMetadata, Boolean>(scope){
            final /* synthetic */ Scope $scope;
            {
                this.$scope = $scope;
                super(1);
            }

            @NotNull
            public final Boolean invoke(SchemaMetadata s) {
                return s.getScope() == this.$scope && s.getPath() != null;
            }
        }, arg_0)).map(arg_0 -> SchemaValidator.analyseFiles$lambda$8((Function1)new Function1<SchemaMetadata, ValidationException>((Map<String, ? extends Schema>)useTypes){
            final /* synthetic */ Map<String, Schema> $useTypes;
            {
                this.$useTypes = $useTypes;
                super(1);
            }

            @Nullable
            public final ValidationException invoke(SchemaMetadata p) {
                Schema.Parser parser = new Schema.Parser();
                parser.addTypes(this.$useTypes);
                try {
                    parser.parse(p.getPath().toFile());
                    return null;
                }
                catch (Exception ex) {
                    return new ValidationException("Cannot parse schema", ex);
                }
            }
        }, arg_0)).filter(Objects::nonNull).map(arg_0 -> SchemaValidator.analyseFiles$lambda$9(analyseFiles.4.INSTANCE, arg_0)), schemaCatalogue.getSchemas().values().stream().flatMap(arg_0 -> SchemaValidator.analyseFiles$lambda$10((Function1)new Function1<SchemaMetadata, Stream<? extends ValidationException>>(this){
            final /* synthetic */ SchemaValidator this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final Stream<? extends ValidationException> invoke(SchemaMetadata it) {
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                return SchemaValidator.access$validate(this.this$0, it);
            }
        }, arg_0))).distinct();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fun analyseFiles(\n      \u2026       ).distinct()\n    }");
        return object;
    }

    private final Stream<ValidationException> analyseFiles(SchemaCatalogue schemaCatalogue) {
        Stream<ValidationException> stream = Arrays.stream(Scope.values()).flatMap(arg_0 -> SchemaValidator.analyseFiles$lambda$11((Function1)new Function1<Scope, Stream<? extends ValidationException>>(this, schemaCatalogue){
            final /* synthetic */ SchemaValidator this$0;
            final /* synthetic */ SchemaCatalogue $schemaCatalogue;
            {
                this.this$0 = $receiver;
                this.$schemaCatalogue = $schemaCatalogue;
                super(1);
            }

            public final Stream<? extends ValidationException> invoke(Scope scope) {
                return this.this$0.analyseFiles(scope, this.$schemaCatalogue);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue(stream, (String)"private fun analyseFiles\u2026scope, schemaCatalogue) }");
        return stream;
    }

    @NotNull
    public final Stream<ValidationException> validate(@NotNull Schema schema, @NotNull Path path, @NotNull Scope scope) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        return this.validate(new SchemaMetadata(schema, scope, path));
    }

    private final Stream<ValidationException> validate(SchemaMetadata schemaMetadata) {
        Stream stream;
        if (this.pathMatcher.matches(schemaMetadata.getPath())) {
            Object r = this.validator.apply(schemaMetadata);
            Intrinsics.checkNotNullExpressionValue(r, (String)"{\n            validator.\u2026schemaMetadata)\n        }");
            stream = (Stream)r;
        } else {
            Stream stream2 = Stream.empty();
            stream = stream2;
            Intrinsics.checkNotNullExpressionValue(stream2, (String)"empty()");
        }
        return stream;
    }

    @NotNull
    public final Map<String, Schema> getValidatedSchemas() {
        SchemaRules schemaRules = this.rules.getSchemaRules();
        Intrinsics.checkNotNull((Object)schemaRules, (String)"null cannot be cast to non-null type org.radarbase.schema.validation.rules.RadarSchemaRules");
        Map<String, Schema> map = ((RadarSchemaRules)schemaRules).getSchemaStore();
        Intrinsics.checkNotNullExpressionValue(map, (String)"rules.schemaRules as RadarSchemaRules).schemaStore");
        return map;
    }

    private static final boolean analyseSourceCatalogue$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Stream analyseSourceCatalogue$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Stream)$tmp0.invoke(p0);
    }

    private static final Stream analyseSourceCatalogue$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Stream)$tmp0.invoke(p0);
    }

    private static final String analyseSourceCatalogue$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final Stream analyseSourceCatalogue$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Stream)$tmp0.invoke(p0);
    }

    private static final boolean analyseFiles$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final ValidationException analyseFiles$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ValidationException)$tmp0.invoke(p0);
    }

    private static final ValidationException analyseFiles$lambda$9(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ValidationException)$tmp0.invoke(p0);
    }

    private static final Stream analyseFiles$lambda$10(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Stream)$tmp0.invoke(p0);
    }

    private static final Stream analyseFiles$lambda$11(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Stream)$tmp0.invoke(p0);
    }

    @JvmStatic
    @NotNull
    public static final String format(@NotNull Stream<ValidationException> exceptionStream) {
        return Companion.format(exceptionStream);
    }

    public static final /* synthetic */ Stream access$validate(SchemaValidator $this, SchemaMetadata schemaMetadata) {
        return $this.validate(schemaMetadata);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0007J\u0010\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/radarbase/schema/validation/SchemaValidator$Companion;", "", "()V", "AVRO_EXTENSION", "", "format", "exceptionStream", "Ljava/util/stream/Stream;", "Lorg/radarbase/schema/validation/ValidationException;", "isAvscFile", "", "file", "Ljava/nio/file/Path;", "radar-schemas-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final String format(@NotNull Stream<ValidationException> exceptionStream) {
            Intrinsics.checkNotNullParameter(exceptionStream, (String)"exceptionStream");
            String string = exceptionStream.map(arg_0 -> Companion.format$lambda$0(format.1.INSTANCE, arg_0)).collect(Collectors.joining());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"exceptionStream\n        \u2026ect(Collectors.joining())");
            return string;
        }

        public final boolean isAvscFile(@Nullable Path file) {
            return ValidationHelper.matchesExtension(file, SchemaValidator.AVRO_EXTENSION);
        }

        private static final String format$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (String)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

