/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.schema.validation.rules;

import io.confluent.connect.avro.AvroData;
import io.confluent.connect.avro.AvroDataConfig;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.radarbase.schema.validation.ValidationException;
import org.radarbase.schema.validation.rules.RadarSchemaFieldRules;
import org.radarbase.schema.validation.rules.SchemaField;
import org.radarbase.schema.validation.rules.SchemaFieldRules;
import org.radarbase.schema.validation.rules.SchemaRules;
import org.radarbase.schema.validation.rules.Validator;

public class RadarSchemaRules
implements SchemaRules {
    static final String TIME = "time";
    private static final String TIME_RECEIVED = "timeReceived";
    private static final String TIME_COMPLETED = "timeCompleted";
    static final Pattern NAMESPACE_PATTERN = Pattern.compile("^[a-z]+(\\.[a-z]+)*$");
    private final Map<String, Schema> schemaStore;
    static final Pattern RECORD_NAME_PATTERN = Pattern.compile("^([A-Z]([a-z]*[0-9]*))+[A-Z]?$");
    static final Pattern ENUM_SYMBOL_PATTERN = Pattern.compile("^[A-Z][A-Z0-9_]*$");
    private static final String WITH_TYPE_DOUBLE = "\" field with type \"double\".";
    private final RadarSchemaFieldRules fieldRules;

    public RadarSchemaRules(RadarSchemaFieldRules fieldRules) {
        this.fieldRules = fieldRules;
        this.schemaStore = new HashMap<String, Schema>();
    }

    public RadarSchemaRules() {
        this(new RadarSchemaFieldRules());
    }

    @Override
    public SchemaFieldRules getFieldRules() {
        return this.fieldRules;
    }

    @Override
    public Validator<Schema> validateUniqueness() {
        return schema -> {
            String key = schema.getFullName();
            Schema oldSchema = this.schemaStore.putIfAbsent(key, (Schema)schema);
            return Validator.check(oldSchema == null || oldSchema.equals(schema), this.messageSchema("Schema is already defined elsewhere with a different definition.").apply((Schema)schema));
        };
    }

    @Override
    public Validator<Schema> validateNameSpace() {
        return Validator.validateNonNull(Schema::getNamespace, Validator.matches(NAMESPACE_PATTERN), this.messageSchema("Namespace cannot be null and must fully lowercase, period-separated, without numeric characters."));
    }

    @Override
    public Validator<Schema> validateName() {
        return Validator.validateNonNull(Schema::getName, Validator.matches(RECORD_NAME_PATTERN), this.messageSchema("Record names must be camel case."));
    }

    @Override
    public Validator<Schema> validateSchemaDocumentation() {
        return schema -> RadarSchemaRules.validateDocumentation(schema.getDoc(), (m, t) -> this.messageSchema((String)m).apply((Schema)t), schema);
    }

    static <T> Stream<ValidationException> validateDocumentation(String doc, BiFunction<String, T, String> message2, T schema) {
        if (doc == null || doc.isEmpty()) {
            return Validator.raise(message2.apply("Property \"doc\" is missing. Documentation is mandatory for all fields. The documentation should report what is being measured, how, and what units or ranges are applicable. Abbreviations and acronyms in the documentation should be written out. The sentence must end with a period '.'. Please add \"doc\" property.", (String)schema));
        }
        Stream<ValidationException> result = Validator.valid();
        if (doc.charAt(doc.length() - 1) != '.') {
            result = Validator.raise(message2.apply("Documentation is not terminated with a period. The documentation should report what is being measured, how, and what units or ranges are applicable. Abbreviations and acronyms in the documentation should be written out. Please end the sentence with a period '.'.", (String)schema));
        }
        if (!Character.isUpperCase(doc.charAt(0))) {
            result = Stream.concat(result, Validator.raise(message2.apply("Documentation does not start with a capital letter. The documentation should report what is being measured, how, and what units or ranges are applicable. Abbreviations and acronyms in the documentation should be written out. Please end the sentence with a period '.'.", (String)schema)));
        }
        return result;
    }

    @Override
    public Validator<Schema> validateSymbols() {
        return Validator.validateNonEmpty(Schema::getEnumSymbols, this.messageSchema("Avro Enumerator must have symbol list.")).and(schema -> schema.getEnumSymbols().stream().filter(Predicate.not(Validator.matches(ENUM_SYMBOL_PATTERN))).map(s -> new ValidationException(this.messageSchema("Symbol " + s + " does not use valid syntax. Enumerator items should be written in uppercase characters separated by underscores.").apply((Schema)schema))));
    }

    @Override
    public Validator<Schema> validateTime() {
        return Validator.validateNonNull(s -> s.getField(TIME), time -> time.schema().getType().equals((Object)Schema.Type.DOUBLE), this.messageSchema("Any schema representing collected data must have a \"time\" field with type \"double\"."));
    }

    @Override
    public Validator<Schema> validateTimeCompleted() {
        return Validator.validateNonNull(s -> s.getField(TIME_COMPLETED), time -> time.schema().getType().equals((Object)Schema.Type.DOUBLE), this.messageSchema("Any ACTIVE schema must have a \"timeCompleted\" field with type \"double\"."));
    }

    @Override
    public Validator<Schema> validateNotTimeCompleted() {
        return Validator.validate(s -> s.getField(TIME_COMPLETED), Objects::isNull, this.messageSchema("\"timeCompleted\" is allow only in ACTIVE schemas."));
    }

    @Override
    public Validator<Schema> validateTimeReceived() {
        return Validator.validateNonNull(s -> s.getField(TIME_RECEIVED), time -> time.schema().getType().equals((Object)Schema.Type.DOUBLE), this.messageSchema("Any PASSIVE schema must have a \"timeReceived\" field with type \"double\"."));
    }

    @Override
    public Validator<Schema> validateNotTimeReceived() {
        return Validator.validate(s -> s.getField(TIME_RECEIVED), Objects::isNull, this.messageSchema("\"timeReceived\" is allow only in PASSIVE schemas."));
    }

    @Override
    public Validator<Schema> validateAvroData() {
        return schema -> {
            AvroDataConfig avroConfig = new AvroDataConfig.Builder().with("connect.meta.data", (Object)false).with("schemas.cache.config", (Object)10).with("enhanced.avro.schema.support", (Object)true).build();
            AvroData encoder = new AvroData(10);
            AvroData decoder = new AvroData(avroConfig);
            try {
                org.apache.kafka.connect.data.Schema connectSchema = encoder.toConnectSchema(schema);
                Schema originalSchema = decoder.fromConnectSchema(connectSchema);
                return Validator.check(schema.equals((Object)originalSchema), () -> "Schema changed by validation: " + schema.toString(true) + " is not equal to " + originalSchema.toString(true));
            }
            catch (Exception ex) {
                return Validator.raise("Failed to convert schema back to itself");
            }
        };
    }

    @Override
    public Validator<Schema> fields(Validator<SchemaField> validator) {
        return schema -> {
            if (!schema.getType().equals((Object)Schema.Type.RECORD)) {
                return Validator.raise("Default validation can be applied only to an Avro RECORD, not to " + schema.getType() + " of schema " + schema.getFullName() + ".");
            }
            if (schema.getFields().isEmpty()) {
                return Validator.raise("Schema " + schema.getFullName() + " does not contain any fields.");
            }
            return schema.getFields().stream().flatMap(field -> {
                SchemaField schemaField = new SchemaField((Schema)schema, (Schema.Field)field);
                return (Stream)validator.apply(schemaField);
            });
        };
    }

    public Map<String, Schema> getSchemaStore() {
        return Collections.unmodifiableMap(this.schemaStore);
    }
}

