/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.schema;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.radarbase.config.AvroTopicConfig;
import org.radarbase.schema.Scope;
import org.radarbase.schema.specification.config.SchemaConfig;
import org.radarbase.schema.validation.SchemaValidator;
import org.radarbase.schema.validation.rules.SchemaMetadata;
import org.radarbase.topic.AvroTopic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 &2\u00020\u0001:\u0001&B#\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0004\u001a\u00020\u0016J\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u00182\u0006\u0010\u0004\u001a\u00020\u0016JB\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\f0\u001d2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002JV\u0010 \u001a\u00020\u001a*\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\u001b2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00030#2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020%0\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006'"}, d2={"Lorg/radarbase/schema/SchemaCatalogue;", "", "schemaRoot", "Ljava/nio/file/Path;", "config", "Lorg/radarbase/schema/specification/config/SchemaConfig;", "scope", "Lorg/radarbase/schema/Scope;", "(Ljava/nio/file/Path;Lorg/radarbase/schema/specification/config/SchemaConfig;Lorg/radarbase/schema/Scope;)V", "schemas", "", "", "Lorg/radarbase/schema/validation/rules/SchemaMetadata;", "getSchemas", "()Ljava/util/Map;", "unmappedAvroFiles", "", "getUnmappedAvroFiles", "()Ljava/util/List;", "getGenericAvroTopic", "Lorg/radarbase/topic/AvroTopic;", "Lorg/apache/avro/generic/GenericRecord;", "Lorg/radarbase/config/AvroTopicConfig;", "getSchemaMetadata", "Lkotlin/Pair;", "loadSchemas", "", "", "unmappedFiles", "", "matcher", "Ljava/nio/file/PathMatcher;", "putParsedSchemas", "customSchemas", "ignoreFiles", "", "useTypes", "Lorg/apache/avro/Schema;", "Companion", "radar-schemas-core"})
public final class SchemaCatalogue {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path schemaRoot;
    @NotNull
    private final Map<String, SchemaMetadata> schemas;
    @NotNull
    private final List<SchemaMetadata> unmappedAvroFiles;
    private static final Logger logger = LoggerFactory.getLogger(SchemaCatalogue.class);

    @JvmOverloads
    public SchemaCatalogue(@NotNull Path schemaRoot, @NotNull SchemaConfig config, @Nullable Scope scope) {
        Intrinsics.checkNotNullParameter((Object)schemaRoot, (String)"schemaRoot");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.schemaRoot = schemaRoot;
        HashMap schemaTemp = new HashMap();
        List unmappedTemp = new ArrayList();
        PathMatcher matcher = config.pathMatcher(this.schemaRoot);
        if (scope != null) {
            this.loadSchemas(schemaTemp, unmappedTemp, scope, matcher, config);
        } else {
            for (Scope useScope : Scope.values()) {
                this.loadSchemas(schemaTemp, unmappedTemp, useScope, matcher, config);
            }
        }
        this.schemas = MapsKt.toMap((Map)schemaTemp);
        this.unmappedAvroFiles = CollectionsKt.toList((Iterable)unmappedTemp);
    }

    public /* synthetic */ SchemaCatalogue(Path path, SchemaConfig schemaConfig, Scope scope, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            scope = null;
        }
        this(path, schemaConfig, scope);
    }

    @NotNull
    public final Map<String, SchemaMetadata> getSchemas() {
        return this.schemas;
    }

    @NotNull
    public final List<SchemaMetadata> getUnmappedAvroFiles() {
        return this.unmappedAvroFiles;
    }

    @NotNull
    public final AvroTopic<GenericRecord, GenericRecord> getGenericAvroTopic(@NotNull AvroTopicConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Pair<SchemaMetadata, SchemaMetadata> pair = this.getSchemaMetadata(config);
        SchemaMetadata keySchema = (SchemaMetadata)pair.component1();
        SchemaMetadata valueSchema = (SchemaMetadata)pair.component2();
        return new AvroTopic(config.getTopic(), keySchema.getSchema(), valueSchema.getSchema(), GenericRecord.class, GenericRecord.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void loadSchemas(Map<String, SchemaMetadata> schemas, List<SchemaMetadata> unmappedFiles, Scope scope, PathMatcher matcher, SchemaConfig config) throws IOException {
        Sequence $this$mapTo$iv;
        SchemaMetadata item$iv;
        Object object;
        void $this$forEach$iv;
        Object walker2;
        Object object2;
        Map map;
        Path walkRoot = this.schemaRoot.resolve(scope.getLower());
        Map $this$loadSchemas_u24lambda_u244 = map = MapsKt.createMapBuilder();
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)walkRoot, (String)"walkRoot");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(walkRoot, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            Stream<Path> stream = Files.walk(walkRoot, new FileVisitOption[0]);
            Intrinsics.checkNotNullExpressionValue(stream, (String)"walk(walkRoot)");
            object2 = stream;
            Throwable throwable = null;
            try {
                walker2 = (Stream)object2;
                boolean bl2 = false;
                walker2.filter(arg_0 -> SchemaCatalogue.loadSchemas$lambda$4$lambda$2$lambda$0((Function1)new Function1<Path, Boolean>(matcher){
                    final /* synthetic */ PathMatcher $matcher;
                    {
                        this.$matcher = $matcher;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(Path p) {
                        return this.$matcher.matches(p) && SchemaValidator.Companion.isAvscFile(p);
                    }
                }, arg_0)).forEach(arg_0 -> SchemaCatalogue.loadSchemas$lambda$4$lambda$2$lambda$1((Function1)new Function1<Path, Unit>((Map<Path, String>)$this$loadSchemas_u24lambda_u244){
                    final /* synthetic */ Map<Path, String> $this_buildMap;
                    {
                        this.$this_buildMap = $receiver;
                        super(1);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public final void invoke(Path p) {
                        Intrinsics.checkNotNullExpressionValue((Object)p, (String)"p");
                        OpenOption[] openOptionArray = new OpenOption[]{};
                        InputStream inputStream = Files.newInputStream(p, Arrays.copyOf(openOptionArray, openOptionArray.length));
                        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(this, *options)");
                        Closeable closeable = inputStream;
                        Object object = Charsets.UTF_8;
                        closeable = new InputStreamReader((InputStream)closeable, (Charset)object);
                        object = this.$this_buildMap;
                        Throwable throwable = null;
                        try {
                            InputStreamReader it = (InputStreamReader)closeable;
                            boolean bl = false;
                            object.put(p, TextStreamsKt.readText((Reader)it));
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                        }
                    }
                }, arg_0));
                walker2 = Unit.INSTANCE;
            }
            catch (Throwable walker2) {
                throwable = walker2;
                throw walker2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)object2, (Throwable)throwable);
            }
        }
        object2 = config.schemas(scope);
        boolean $i$f$forEach2 = false;
        walker2 = $this$forEach$iv.entrySet().iterator();
        while (walker2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = walker2.next();
            boolean bl3 = false;
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            Path path = walkRoot.resolve(key);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"walkRoot.resolve(key)");
            $this$loadSchemas_u24lambda_u244.put(path, value);
        }
        Map avroFiles2 = MapsKt.build((Map)map);
        int prevSize = -1;
        while (prevSize != schemas.size()) {
            void $this$mapTo$iv2;
            void $this$mapValuesTo$iv$iv;
            prevSize = schemas.size();
            Map<String, SchemaMetadata> $this$mapValues$iv = schemas;
            boolean $i$f$mapValues22 = false;
            Map<String, SchemaMetadata> $i$f$forEach2 = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo22 = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo2 = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map2 = destination$iv$iv;
                boolean bl4 = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                object = map2;
                boolean bl5 = false;
                SchemaMetadata value = (SchemaMetadata)entry2.getValue();
                Schema schema = value.getSchema();
                object.put(k, schema);
            }
            Map useTypes = destination$iv$iv;
            Iterable $i$f$mapValues22 = schemas.values();
            Collection destination$iv = new HashSet();
            boolean $i$f$mapTo = false;
            Iterator $i$f$mapValuesTo22 = $this$mapTo$iv2.iterator();
            while ($i$f$mapValuesTo22.hasNext()) {
                void it;
                SchemaMetadata $i$f$associateByTo2 = item$iv = $i$f$mapValuesTo22.next();
                object = destination$iv;
                boolean bl6 = false;
                object.add(it.getPath());
            }
            HashSet ignoreFiles = (HashSet)destination$iv;
            this.putParsedSchemas(schemas, avroFiles2, ignoreFiles, useTypes, scope);
        }
        Iterable ignoreFiles = schemas.values();
        Collection destination$iv = new HashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv2 : $this$mapTo$iv) {
            void it;
            item$iv = (SchemaMetadata)item$iv2;
            object = destination$iv;
            boolean bl7 = false;
            object.add(it.getPath());
        }
        HashSet mappedPaths = (HashSet)destination$iv;
        $this$mapTo$iv = SequencesKt.distinct((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)avroFiles2.keySet()), (Function1)((Function1)new Function1<Path, Boolean>((HashSet<Path>)mappedPaths){
            final /* synthetic */ HashSet<Path> $mappedPaths;
            {
                this.$mappedPaths = $mappedPaths;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Path it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return !this.$mappedPaths.contains(it);
            }
        })));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv3 : $this$mapTo$iv) {
            void p;
            Path item$iv2 = (Path)item$iv3;
            object = unmappedFiles;
            boolean bl8 = false;
            object.add(new SchemaMetadata(null, scope, (Path)p));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void putParsedSchemas(Map<String, SchemaMetadata> $this$putParsedSchemas, Map<Path, String> customSchemas, Set<? extends Path> ignoreFiles, Map<String, ? extends Schema> useTypes, Scope scope) {
        void $this$forEach$iv;
        Sequence sequence = SequencesKt.filter((Sequence)MapsKt.asSequence(customSchemas), (Function1)((Function1)new Function1<Map.Entry<? extends Path, ? extends String>, Boolean>(ignoreFiles){
            final /* synthetic */ Set<Path> $ignoreFiles;
            {
                this.$ignoreFiles = $ignoreFiles;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Map.Entry<? extends Path, String> entry) {
                Intrinsics.checkNotNullParameter(entry, (String)"<name for destructuring parameter 0>");
                Path p = entry.getKey();
                return !this.$ignoreFiles.contains(p);
            }
        }));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            Path p = (Path)entry.getKey();
            String schema = (String)entry.getValue();
            Schema.Parser parser = new Schema.Parser();
            parser.addTypes(useTypes);
            try {
                Schema parsedSchema = parser.parse(schema);
                String string = parsedSchema.getFullName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"parsedSchema.fullName");
                $this$putParsedSchemas.put(string, new SchemaMetadata(parsedSchema, scope, p));
            }
            catch (Exception ex) {
                logger.debug("Cannot parse schema {}: {}", (Object)p, (Object)ex.toString());
            }
        }
    }

    @NotNull
    public final Pair<SchemaMetadata, SchemaMetadata> getSchemaMetadata(@NotNull AvroTopicConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        SchemaMetadata schemaMetadata = this.schemas.get(config.getKeySchema());
        if (schemaMetadata == null) {
            throw new NoSuchElementException("Key schema " + config.getKeySchema() + " for topic " + config.getTopic() + " not found.");
        }
        SchemaMetadata parsedKeySchema = schemaMetadata;
        SchemaMetadata schemaMetadata2 = this.schemas.get(config.getValueSchema());
        if (schemaMetadata2 == null) {
            throw new NoSuchElementException("Value schema " + config.getValueSchema() + " for topic " + config.getTopic() + " not found.");
        }
        SchemaMetadata parsedValueSchema = schemaMetadata2;
        return new Pair((Object)parsedKeySchema, (Object)parsedValueSchema);
    }

    @JvmOverloads
    public SchemaCatalogue(@NotNull Path schemaRoot, @NotNull SchemaConfig config) {
        Intrinsics.checkNotNullParameter((Object)schemaRoot, (String)"schemaRoot");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this(schemaRoot, config, null, 4, null);
    }

    private static final boolean loadSchemas$lambda$4$lambda$2$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void loadSchemas$lambda$4$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/radarbase/schema/SchemaCatalogue$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "radar-schemas-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

