/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.schema.validation.rules;

import java.util.Collection;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.radarbase.schema.validation.ValidationException;

public interface Validator<T>
extends Function<T, Stream<ValidationException>> {
    public static Stream<ValidationException> check(boolean test, String message2) {
        return test ? Validator.valid() : Validator.raise(message2);
    }

    public static Stream<ValidationException> check(boolean test, Supplier<String> message2) {
        return test ? Validator.valid() : Validator.raise(message2.get());
    }

    public static <T> Validator<T> validate(Predicate<T> predicate, String message2) {
        return object -> Validator.check(predicate.test(object), message2);
    }

    public static <T> Validator<T> validate(Predicate<T> predicate, Function<T, String> message2) {
        return object -> Validator.check(predicate.test(object), (String)message2.apply(object));
    }

    public static <T, V> Validator<T> validate(Function<T, V> property, Predicate<V> predicate, Function<T, String> message2) {
        return object -> Validator.check(predicate.test(property.apply(object)), (String)message2.apply(object));
    }

    public static <T> Validator<T> validateNonNull(Predicate<T> predicate, String message2) {
        return Validator.validate((T o) -> o != null && predicate.test(o), message2);
    }

    public static <T, V> Validator<T> validateNonNull(Function<T, V> property, Predicate<V> predicate, Function<T, String> message2) {
        return Validator.validate((T o) -> {
            Object val = property.apply(o);
            return val != null && predicate.test(val);
        }, message2);
    }

    public static <T, V> Validator<T> validateNonNull(Function<T, V> property, Predicate<V> predicate, String message2) {
        return Validator.validate((T o) -> {
            Object val = property.apply(o);
            return val != null && predicate.test(val);
        }, message2);
    }

    public static <T, V> Validator<T> validateNonNull(Function<T, V> property, String message2) {
        return Validator.validate((T o) -> property.apply(o) != null, message2);
    }

    public static <T> Validator<T> validateNonEmpty(Function<T, String> property, Function<T, String> message2, Validator<String> validator) {
        return o -> {
            String val = (String)property.apply(o);
            if (val == null || val.isEmpty()) {
                return Validator.raise((String)message2.apply(o));
            }
            return (Stream)validator.apply(val);
        };
    }

    public static <T> Validator<T> validateNonEmpty(Function<T, String> property, String message2, Validator<String> validator) {
        return o -> {
            String val = (String)property.apply(o);
            if (val == null || val.isEmpty()) {
                return Validator.raise(message2);
            }
            return (Stream)validator.apply(val);
        };
    }

    public static <T, V extends Collection<?>> Validator<T> validateNonEmpty(Function<T, V> property, String message2) {
        return Validator.validate((T o) -> {
            Collection val = (Collection)property.apply(o);
            return val != null && !val.isEmpty();
        }, message2);
    }

    public static <T, V extends Collection<?>> Validator<T> validateNonEmpty(Function<T, V> property, Function<T, String> message2) {
        return Validator.validate((T o) -> {
            Collection val = (Collection)property.apply(o);
            return val != null && !val.isEmpty();
        }, message2);
    }

    public static <T> Validator<T> validateOrNull(Predicate<T> predicate, String message2) {
        return Validator.validate((T o) -> o == null || predicate.test(o), message2);
    }

    public static <T, V> Validator<T> validateOrNull(Function<T, V> property, Predicate<V> predicate, String message2) {
        return Validator.validate((T o) -> {
            Object val = property.apply(o);
            return val == null || predicate.test(val);
        }, message2);
    }

    default public Validator<T> and(Validator<T> other) {
        return object -> Stream.concat((Stream)this.apply(object), (Stream)other.apply(object));
    }

    default public <R> Validator<T> and(Validator<R> other, Function<T, R> toOther) {
        return object -> Stream.concat((Stream)this.apply(object), (Stream)other.apply(toOther.apply(object)));
    }

    public static boolean matches(String str, Pattern pattern) {
        return pattern.matcher(str).matches();
    }

    public static Predicate<String> matches(Pattern pattern) {
        return str -> pattern.matcher((CharSequence)str).matches();
    }

    public static Stream<ValidationException> raise(String message2) {
        return Stream.of(new ValidationException(message2));
    }

    public static Stream<ValidationException> raise(String message2, Exception ex) {
        return Stream.of(new ValidationException(message2, ex));
    }

    public static Stream<ValidationException> valid() {
        return Stream.empty();
    }
}

