/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.schema.validation.rules;

import java.nio.file.Path;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.radarbase.schema.validation.ValidationHelper;
import org.radarbase.schema.validation.config.ExcludeConfig;
import org.radarbase.schema.validation.rules.RadarSchemaRules;
import org.radarbase.schema.validation.rules.SchemaMetadata;
import org.radarbase.schema.validation.rules.SchemaMetadataRules;
import org.radarbase.schema.validation.rules.SchemaRules;
import org.radarbase.schema.validation.rules.Validator;

public class RadarSchemaMetadataRules
implements SchemaMetadataRules {
    private final SchemaRules schemaRules;
    private final Path root;
    private final ExcludeConfig config;

    public RadarSchemaMetadataRules(Path root, ExcludeConfig config) {
        this(root, config, new RadarSchemaRules(config));
    }

    public RadarSchemaMetadataRules(Path root, ExcludeConfig config, SchemaRules schemaRules) {
        this.schemaRules = schemaRules;
        this.config = config;
        this.root = root;
    }

    @Override
    public SchemaRules getSchemaRules() {
        return this.schemaRules;
    }

    @Override
    public Validator<SchemaMetadata> validateSchemaLocation() {
        return this.validateNamespaceSchemaLocation().and(this.validateNameSchemaLocation());
    }

    private Validator<SchemaMetadata> validateNamespaceSchemaLocation() {
        return metadata -> {
            try {
                String expected = ValidationHelper.getNamespace(this.root, metadata.getPath(), metadata.getScope());
                String namespace = metadata.getSchema().getNamespace();
                return Validator.check(expected.equalsIgnoreCase(namespace), this.message("Namespace cannot be null and must fully lowercase dot separated without numeric. In this case the expected value is \"" + expected + "\".").apply((SchemaMetadata)metadata));
            }
            catch (IllegalArgumentException ex) {
                return Validator.raise("Path " + metadata.getPath() + " is not part of root " + this.root, ex);
            }
        };
    }

    private Validator<SchemaMetadata> validateNameSchemaLocation() {
        return metadata -> {
            String expected = ValidationHelper.getRecordName(metadata.getPath());
            return expected.equalsIgnoreCase(metadata.getSchema().getName()) ? Validator.valid() : Validator.raise(this.message("Record name should match file name. Expected record name is \"" + expected + "\".").apply((SchemaMetadata)metadata));
        };
    }

    @Override
    public Validator<SchemaMetadata> schema(Validator<Schema> validator) {
        return metadata -> this.config.skipFile(metadata.getPath()) ? Validator.valid() : (Stream)validator.apply(metadata.getSchema());
    }
}

