/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.schema.validation.rules;

import java.util.EnumMap;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.avro.JsonProperties;
import org.apache.avro.Schema;
import org.radarbase.schema.validation.ValidationException;
import org.radarbase.schema.validation.rules.RadarSchemaRules;
import org.radarbase.schema.validation.rules.SchemaField;
import org.radarbase.schema.validation.rules.SchemaFieldRules;
import org.radarbase.schema.validation.rules.SchemaRules;
import org.radarbase.schema.validation.rules.Validator;

public class RadarSchemaFieldRules
implements SchemaFieldRules {
    private static final String UNKNOWN = "UNKNOWN";
    public static final Pattern FIELD_NAME_PATTERN = Pattern.compile("^[a-z][a-z0-9]*([a-z0-9][A-Z][a-z0-9]+)?([A-Z][a-z0-9]+)*[A-Z]?$");
    private final Map<Schema.Type, Validator<SchemaField>> defaultsValidator = new EnumMap<Schema.Type, Validator<SchemaField>>(Schema.Type.class);

    public RadarSchemaFieldRules() {
        this.defaultsValidator.put(Schema.Type.ENUM, this::validateDefaultEnum);
        this.defaultsValidator.put(Schema.Type.UNION, this::validateDefaultUnion);
    }

    @Override
    public Validator<SchemaField> validateFieldTypes(SchemaRules schemaRules) {
        return field -> {
            Schema schema = field.getField().schema();
            Schema.Type subType = schema.getType();
            if (subType == Schema.Type.UNION) {
                return (Stream)this.validateInternalUnion(schemaRules).apply((SchemaField)field);
            }
            if (subType == Schema.Type.RECORD) {
                return (Stream)schemaRules.validateRecord().apply(schema);
            }
            if (subType == Schema.Type.ENUM) {
                return (Stream)schemaRules.validateEnum().apply(schema);
            }
            return Validator.valid();
        };
    }

    @Override
    public Validator<SchemaField> validateDefault() {
        return input -> (Stream)this.defaultsValidator.getOrDefault(input.getField().schema().getType(), this::validateDefaultOther).apply((SchemaField)input);
    }

    @Override
    public Validator<SchemaField> validateFieldName() {
        return Validator.validateNonNull(f -> f.getField().name(), Validator.matches(FIELD_NAME_PATTERN), this.message("Field name does not respect lowerCamelCase name convention. Please avoid abbreviations and write out the field name instead."));
    }

    @Override
    public Validator<SchemaField> validateFieldDocumentation() {
        return field -> RadarSchemaRules.validateDocumentation(field.getField().doc(), (m, f) -> this.message((String)m).apply((SchemaField)f), field);
    }

    private Stream<ValidationException> validateDefaultEnum(SchemaField field) {
        return Validator.check(!field.getField().schema().getEnumSymbols().contains(UNKNOWN) || field.getField().defaultVal() != null && field.getField().defaultVal().toString().equals(UNKNOWN), this.message("Default is \"" + field.getField().defaultVal() + "\". Any Avro enum type that has an \"UNKNOWN\" symbol must set its default value to \"UNKNOWN\".").apply(field));
    }

    private Stream<ValidationException> validateDefaultUnion(SchemaField field) {
        return Validator.check(!field.getField().schema().getTypes().contains(Schema.create((Schema.Type)Schema.Type.NULL)) || field.getField().defaultVal() != null && field.getField().defaultVal().equals(JsonProperties.NULL_VALUE), this.message("Default is not null. Any nullable Avro field must specify have its default value set to null.").apply(field));
    }

    private Stream<ValidationException> validateDefaultOther(SchemaField field) {
        return Validator.check(field.getField().defaultVal() == null, this.message("Default of type " + field.getField().schema().getType() + " is set to " + field.getField().defaultVal() + ". The only acceptable default values are the \"UNKNOWN\" enum symbol and null.").apply(field));
    }
}

