/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.schema.validation;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.radarbase.schema.Scope;
import org.radarbase.schema.validation.ValidationHelper;
import org.radarbase.schema.validation.config.ExcludeConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpecificationsValidator {
    private static final Logger logger = LoggerFactory.getLogger(SpecificationsValidator.class);
    public static final String YML_EXTENSION = "yml";
    private final ExcludeConfig config;
    private final Path specificationsRoot;
    private final ObjectMapper mapper;

    public SpecificationsValidator(Path root, ExcludeConfig config) {
        this.specificationsRoot = root.resolve("specifications");
        this.config = config;
        this.mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
    }

    public boolean specificationsAreYmlFiles(Scope scope) throws IOException {
        Path baseFolder = scope.getPath(this.specificationsRoot);
        if (baseFolder == null) {
            logger.info(scope + " sources folder not present");
            return false;
        }
        return Files.walk(baseFolder, new FileVisitOption[0]).filter(p -> Files.isRegularFile(p, new LinkOption[0]) && !this.config.skipFile((Path)p)).allMatch(SpecificationsValidator::isYmlFile);
    }

    public <T> boolean checkSpecificationParsing(Scope scope, Class<T> clazz) throws IOException {
        Path baseFolder = scope.getPath(this.specificationsRoot);
        if (baseFolder == null) {
            logger.info(scope + " sources folder not present");
            return false;
        }
        return Files.walk(baseFolder, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).allMatch(f -> {
            try {
                this.mapper.readerFor(clazz).readValue(f.toFile());
                return true;
            }
            catch (IOException ex) {
                logger.error("Failed to load configuration {}: {}", f, (Object)ex.toString());
                return false;
            }
        });
    }

    private static boolean isYmlFile(Path path) {
        return ValidationHelper.matchesExtension(path, YML_EXTENSION);
    }
}

