/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.schema.specification;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.radarbase.config.AvroTopicConfig;
import org.radarbase.schema.SchemaCatalogue;
import org.radarbase.schema.specification.AppDataTopic;
import org.radarbase.schema.specification.SampleRateConfig;
import org.radarbase.schema.util.SchemaUtils;
import org.radarbase.topic.AvroTopic;
import org.radarcns.catalogue.Unit;
import org.radarcns.kafka.ObservationKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DataTopic
extends AvroTopicConfig {
    private static final Logger logger = LoggerFactory.getLogger(DataTopic.class);
    @JsonProperty
    private String type;
    @JsonProperty
    private String doc;
    @JsonProperty(value="sample_rate")
    private SampleRateConfig sampleRate;
    @JsonProperty
    private Unit unit;
    @JsonProperty
    private List<AppDataTopic.DataField> fields;

    public DataTopic() {
        this.setKeySchema(ObservationKey.class.getName());
    }

    @JsonIgnore
    public Stream<String> getTopicNames() {
        return Stream.of(this.getTopic());
    }

    @JsonIgnore
    public Stream<AvroTopic<?, ?>> getTopics(SchemaCatalogue schemaCatalogue) throws IOException {
        return Stream.of(schemaCatalogue.getGenericAvroTopic(this));
    }

    public String getType() {
        return this.type;
    }

    public String getDoc() {
        return this.doc;
    }

    public SampleRateConfig getSampleRate() {
        return this.sampleRate;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public List<AppDataTopic.DataField> getFields() {
        return this.fields;
    }

    @JsonSetter
    public void setKeySchema(String schema) {
        super.setKeySchema(SchemaUtils.expandClass(schema));
    }

    @JsonSetter
    public void setValueSchema(String schema) {
        super.setValueSchema(SchemaUtils.expandClass(schema));
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean prettyString) {
        String name = ((Object)((Object)this)).getClass().getSimpleName();
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        this.propertiesMap(properties, !prettyString);
        if (prettyString) {
            YAMLFactory factory = new YAMLFactory();
            factory.configure(YAMLGenerator.Feature.WRITE_DOC_START_MARKER, false);
            factory.configure(YAMLGenerator.Feature.MINIMIZE_QUOTES, true);
            ObjectMapper mapper = new ObjectMapper((JsonFactory)factory);
            try {
                return mapper.writeValueAsString(Map.of(name, properties));
            }
            catch (JsonProcessingException ex) {
                logger.error("Failed to convert data to YAML", (Throwable)ex);
                return name + properties;
            }
        }
        return name + properties;
    }

    protected void propertiesMap(Map<String, Object> map, boolean reduced) {
        String topic;
        map.put("type", this.type);
        if (!reduced && this.doc != null) {
            map.put("doc", this.doc);
        }
        if ((topic = this.getTopic()) != null) {
            map.put("topic", topic);
        }
        map.put("key_schema", this.getKeySchema());
        map.put("value_schema", this.getValueSchema());
        if (!reduced) {
            if (this.sampleRate != null) {
                map.put("sample_rate", this.sampleRate);
            }
            if (this.unit != null) {
                map.put("unit", this.unit);
            }
            if (this.fields != null) {
                map.put("fields", this.fields);
            }
        }
    }
}

