/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.schema.validation.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.radarbase.schema.validation.config.ConfigItem;
import org.radarbase.schema.validation.rules.SchemaField;
import org.radarbase.schema.validation.rules.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcludeConfig {
    private static final Logger logger = LoggerFactory.getLogger(ExcludeConfig.class);
    public static final String REPOSITORY_NAME = "/RADAR-Schemas/";
    private static final String FILE_NAME = "schema.yml";
    private static final String WILD_CARD_PACKAGE = ".*";
    public static final Pattern VALID_INPUT_PATTERN = Pattern.compile("[a-z][a-zA-Z0-9.*]*");
    @JsonIgnore
    private final Collection<PathMatcher> matchers = new ArrayList<PathMatcher>();
    private final Map<String, ConfigItem> validation = new HashMap<String, ConfigItem>();
    private Path root;

    public static ExcludeConfig load(Path path) throws IOException {
        YAMLFactory factory = new YAMLFactory();
        ObjectReader reader = new ObjectMapper((JsonFactory)factory).readerFor(ExcludeConfig.class);
        if (path == null) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            try (InputStream in = loader.getResourceAsStream(FILE_NAME);){
                if (in == null) {
                    logger.debug("Not loading any configuration");
                    ExcludeConfig excludeConfig = new ExcludeConfig();
                    return excludeConfig;
                }
                ExcludeConfig excludeConfig = (ExcludeConfig)reader.readValue(in);
                return excludeConfig;
            }
        }
        return (ExcludeConfig)reader.readValue(path.toFile());
    }

    private static boolean invalidClass(Stream<String> stream) {
        return stream.anyMatch(Predicate.not(Validator.matches(VALID_INPUT_PATTERN)));
    }

    public boolean isSkipped(SchemaField field) {
        Schema schema = field.getSchema();
        ConfigItem item = this.validation.get(schema.getFullName()) == null ? this.validation.get(schema.getNamespace() + WILD_CARD_PACKAGE) : this.validation.get(schema.getFullName());
        return item != null && item.getFields().contains(field.getField().name());
    }

    public boolean skipFile(Path checkPath) {
        if (checkPath == null) {
            return false;
        }
        Path relativePath = this.relativize(checkPath);
        return this.matchers.stream().anyMatch(p -> p.matches(relativePath) || p.matches(checkPath.getFileName()));
    }

    private Path relativize(Path path) {
        if (path.isAbsolute() && this.root != null) {
            try {
                return this.root.relativize(path.normalize());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return path;
    }

    public void setFiles(String ... files) {
        this.setFiles(List.of(files));
    }

    @JsonSetter(value="files")
    public void setFiles(Collection<String> files) {
        FileSystem fs = FileSystems.getDefault();
        List pathMatchers = files.stream().map(p -> {
            try {
                return fs.getPathMatcher("glob:" + p);
            }
            catch (IllegalArgumentException ex) {
                logger.error("Exclude pattern {} is invalid. Please use the glob syntaxdescribed in https://docs.oracle.com/javase/7/docs/api/java/nio/file/FileSystem.html#getPathMatcher(java.lang.String)", p, (Object)ex);
                return null;
            }
        }).collect(Collectors.toList());
        if (pathMatchers.stream().anyMatch(Objects::isNull)) {
            throw new IllegalArgumentException("Invalid exclude config.");
        }
        if (!files.isEmpty()) {
            this.matchers.clear();
        }
        this.matchers.addAll(pathMatchers);
    }

    @JsonSetter(value="validation")
    public void setValidation(Map<String, ConfigItem> validation) {
        if (ExcludeConfig.invalidClass(validation.keySet().stream())) {
            throw new IllegalArgumentException("Validation map keys are invalid");
        }
        if (ExcludeConfig.invalidClass(validation.values().stream().map(ConfigItem::getFields).flatMap(Collection::stream))) {
            throw new IllegalArgumentException("Validation map values are not valid.");
        }
        if (!this.validation.isEmpty()) {
            this.validation.clear();
        }
        this.validation.putAll(validation);
    }

    public Map<String, ConfigItem> getValidation() {
        return new HashMap<String, ConfigItem>(this.validation);
    }

    public Path getRoot() {
        return this.root;
    }

    public void setRoot(Path root) {
        this.root = root.normalize();
    }
}

