/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.schema.specification;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.util.Objects;
import org.radarbase.schema.specification.DataProducer;
import org.radarbase.schema.specification.DataTopic;
import org.radarbase.schema.util.SchemaUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public abstract class AppSource<T extends DataTopic>
extends DataProducer<T> {
    @JsonProperty(value="app_provider")
    private String appProvider;
    @JsonProperty
    private String vendor;
    @JsonProperty
    private String model;
    @JsonProperty
    private String version;

    @JsonSetter
    private void setAppProvider(String provider) {
        this.appProvider = SchemaUtils.expandClass(provider);
    }

    public String getAppProvider() {
        return this.appProvider;
    }

    public String getVersion() {
        return this.version;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getModel() {
        return this.model;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppSource provider = (AppSource)o;
        return Objects.equals(this.appProvider, provider.appProvider) && Objects.equals(this.version, provider.version) && Objects.equals(this.model, provider.model) && Objects.equals(this.vendor, provider.vendor) && Objects.equals(this.getData(), provider.getData());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.appProvider, this.vendor, this.model, this.version, this.getData());
    }
}

