/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.schema;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kotlin.Pair;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.radarbase.config.AvroTopicConfig;
import org.radarbase.schema.Scope;
import org.radarbase.schema.validation.SchemaValidator;
import org.radarbase.schema.validation.rules.SchemaMetadata;
import org.radarbase.topic.AvroTopic;

public class SchemaCatalogue {
    private final Path root;
    private final Map<String, SchemaMetadata> schemas;
    private final List<SchemaMetadata> unmappedFiles;

    public SchemaCatalogue(Path root) throws IOException {
        this(root, null);
    }

    public SchemaCatalogue(Path root, Scope scope) throws IOException {
        this.root = root.resolve("commons");
        HashMap<String, SchemaMetadata> schemaTemp = new HashMap<String, SchemaMetadata>();
        ArrayList<SchemaMetadata> unmappedTemp = new ArrayList<SchemaMetadata>();
        if (scope != null) {
            this.loadSchemas(schemaTemp, unmappedTemp, scope);
        } else {
            for (Scope useScope : Scope.values()) {
                this.loadSchemas(schemaTemp, unmappedTemp, useScope);
            }
        }
        this.schemas = Collections.unmodifiableMap(schemaTemp);
        this.unmappedFiles = Collections.unmodifiableList(unmappedTemp);
    }

    public AvroTopic<GenericRecord, GenericRecord> getGenericAvroTopic(AvroTopicConfig config) {
        Pair<SchemaMetadata, SchemaMetadata> schemaMetadata = this.getSchemaMetadata(config);
        return new AvroTopic(config.getTopic(), ((SchemaMetadata)schemaMetadata.component1()).getSchema(), ((SchemaMetadata)schemaMetadata.component2()).getSchema(), GenericRecord.class, GenericRecord.class);
    }

    public Map<String, SchemaMetadata> getSchemas() {
        return this.schemas;
    }

    public List<SchemaMetadata> getUnmappedAvroFiles() {
        return this.unmappedFiles;
    }

    private void loadSchemas(Map<String, SchemaMetadata> schemas, List<SchemaMetadata> unmappedFiles, Scope scope) throws IOException {
        Path walkRoot = scope.getPath(this.root);
        if (walkRoot == null) {
            return;
        }
        List avroFiles = Files.walk(walkRoot, new FileVisitOption[0]).filter(p -> Files.isRegularFile(p, new LinkOption[0]) && SchemaValidator.isAvscFile(p)).collect(Collectors.toList());
        int prevSize = -1;
        while (prevSize != schemas.size()) {
            prevSize = schemas.size();
            Map<String, Schema> useTypes = schemas.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((SchemaMetadata)e.getValue()).getSchema()));
            Set ignoreFiles = schemas.values().stream().map(SchemaMetadata::getPath).collect(Collectors.toSet());
            schemas.putAll(avroFiles.stream().filter(Predicate.not(ignoreFiles::contains)).map(p -> {
                Schema.Parser parser = new Schema.Parser();
                parser.addTypes(useTypes);
                try {
                    return new SchemaMetadata(parser.parse(p.toFile()), scope, (Path)p);
                }
                catch (Exception ex) {
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toMap(m -> m.getSchema().getFullName(), Function.identity(), (v1, v2) -> {
                if (v1.equals(v2)) {
                    return v1;
                }
                throw new IllegalStateException("Duplicate enum: " + v1);
            })));
        }
        Set mappedPaths = schemas.values().stream().map(SchemaMetadata::getPath).collect(Collectors.toSet());
        unmappedFiles.addAll(avroFiles.stream().filter(p -> !mappedPaths.contains(p)).map(p -> new SchemaMetadata(null, scope, (Path)p)).collect(Collectors.toList()));
    }

    public Pair<SchemaMetadata, SchemaMetadata> getSchemaMetadata(AvroTopicConfig config) {
        SchemaMetadata parsedKeySchema = this.schemas.get(config.getKeySchema());
        if (parsedKeySchema == null) {
            throw new NoSuchElementException("Key schema " + config.getKeySchema() + " for topic " + config.getTopic() + " not found.");
        }
        SchemaMetadata parsedValueSchema = this.schemas.get(config.getValueSchema());
        if (parsedValueSchema == null) {
            throw new NoSuchElementException("Value schema " + config.getValueSchema() + " for topic " + config.getTopic() + " not found.");
        }
        return new Pair((Object)parsedKeySchema, (Object)parsedValueSchema);
    }
}

