/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.schema.validation.rules;

import java.util.Collection;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.radarbase.schema.validation.ValidationException;

public interface Validator<T>
extends Function<T, Stream<ValidationException>> {
    public static Stream<ValidationException> check(boolean test, String message) {
        return test ? Validator.valid() : Validator.raise(message);
    }

    public static Stream<ValidationException> check(boolean test, Supplier<String> message) {
        return test ? Validator.valid() : Validator.raise(message.get());
    }

    public static <T> Validator<T> validate(Predicate<T> predicate, String message) {
        return object -> Validator.check(predicate.test(object), message);
    }

    public static <T> Validator<T> validate(Predicate<T> predicate, Function<T, String> message) {
        return object -> Validator.check(predicate.test(object), (String)message.apply(object));
    }

    public static <T, V> Validator<T> validate(Function<T, V> property, Predicate<V> predicate, Function<T, String> message) {
        return object -> Validator.check(predicate.test(property.apply(object)), (String)message.apply(object));
    }

    public static <T> Validator<T> validateNonNull(Predicate<T> predicate, String message) {
        return Validator.validate((T o) -> o != null && predicate.test(o), message);
    }

    public static <T, V> Validator<T> validateNonNull(Function<T, V> property, Predicate<V> predicate, Function<T, String> message) {
        return Validator.validate((T o) -> {
            Object val = property.apply(o);
            return val != null && predicate.test(val);
        }, message);
    }

    public static <T, V> Validator<T> validateNonNull(Function<T, V> property, Predicate<V> predicate, String message) {
        return Validator.validate((T o) -> {
            Object val = property.apply(o);
            return val != null && predicate.test(val);
        }, message);
    }

    public static <T, V> Validator<T> validateNonNull(Function<T, V> property, String message) {
        return Validator.validate((T o) -> property.apply(o) != null, message);
    }

    public static <T> Validator<T> validateNonEmpty(Function<T, String> property, Function<T, String> message, Validator<String> validator) {
        return o -> {
            String val = (String)property.apply(o);
            if (val == null || val.isEmpty()) {
                return Validator.raise((String)message.apply(o));
            }
            return (Stream)validator.apply(val);
        };
    }

    public static <T> Validator<T> validateNonEmpty(Function<T, String> property, String message, Validator<String> validator) {
        return o -> {
            String val = (String)property.apply(o);
            if (val == null || val.isEmpty()) {
                return Validator.raise(message);
            }
            return (Stream)validator.apply(val);
        };
    }

    public static <T, V extends Collection<?>> Validator<T> validateNonEmpty(Function<T, V> property, String message) {
        return Validator.validate((T o) -> {
            Collection val = (Collection)property.apply(o);
            return val != null && !val.isEmpty();
        }, message);
    }

    public static <T, V extends Collection<?>> Validator<T> validateNonEmpty(Function<T, V> property, Function<T, String> message) {
        return Validator.validate((T o) -> {
            Collection val = (Collection)property.apply(o);
            return val != null && !val.isEmpty();
        }, message);
    }

    public static <T> Validator<T> validateOrNull(Predicate<T> predicate, String message) {
        return Validator.validate((T o) -> o == null || predicate.test(o), message);
    }

    public static <T, V> Validator<T> validateOrNull(Function<T, V> property, Predicate<V> predicate, String message) {
        return Validator.validate((T o) -> {
            Object val = property.apply(o);
            return val == null || predicate.test(val);
        }, message);
    }

    default public Validator<T> and(Validator<T> other) {
        return object -> Stream.concat((Stream)this.apply(object), (Stream)other.apply(object));
    }

    default public <R> Validator<T> and(Validator<R> other, Function<T, R> toOther) {
        return object -> Stream.concat((Stream)this.apply(object), (Stream)other.apply(toOther.apply(object)));
    }

    public static boolean matches(String str, Pattern pattern) {
        return pattern.matcher(str).matches();
    }

    public static Predicate<String> matches(Pattern pattern) {
        return str -> pattern.matcher((CharSequence)str).matches();
    }

    public static Stream<ValidationException> raise(String message) {
        return Stream.of(new ValidationException(message));
    }

    public static Stream<ValidationException> raise(String message, Exception ex) {
        return Stream.of(new ValidationException(message, ex));
    }

    public static Stream<ValidationException> valid() {
        return Stream.empty();
    }
}

