/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.schema.validation;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.Pair;
import org.apache.avro.Schema;
import org.radarbase.config.AvroTopicConfig;
import org.radarbase.schema.SchemaCatalogue;
import org.radarbase.schema.Scope;
import org.radarbase.schema.specification.SourceCatalogue;
import org.radarbase.schema.validation.ValidationException;
import org.radarbase.schema.validation.ValidationHelper;
import org.radarbase.schema.validation.config.ExcludeConfig;
import org.radarbase.schema.validation.rules.RadarSchemaMetadataRules;
import org.radarbase.schema.validation.rules.RadarSchemaRules;
import org.radarbase.schema.validation.rules.SchemaMetadata;
import org.radarbase.schema.validation.rules.SchemaMetadataRules;
import org.radarbase.schema.validation.rules.Validator;

public class SchemaValidator {
    public static final String AVRO_EXTENSION = "avsc";
    private final ExcludeConfig config;
    private final SchemaMetadataRules rules;
    private Validator<SchemaMetadata> validator;

    public SchemaValidator(Path root, ExcludeConfig config) {
        this.config = config;
        this.rules = new RadarSchemaMetadataRules(root, config);
        this.validator = this.rules.getValidator(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream<ValidationException> analyseSourceCatalogue(Scope scope, SourceCatalogue catalogue) {
        this.validator = this.rules.getValidator(true);
        Stream<Object> producers = scope != null ? catalogue.getSources().stream().filter(s -> s.getScope().equals((Object)scope)) : catalogue.getSources().stream();
        try {
            Stream<ValidationException> stream = producers.flatMap(s -> s.getData().stream()).flatMap(d -> {
                Pair<SchemaMetadata, SchemaMetadata> metadata = catalogue.getSchemaCatalogue().getSchemaMetadata((AvroTopicConfig)d);
                return Stream.of((SchemaMetadata)metadata.component1(), (SchemaMetadata)metadata.component2());
            }).sorted(Comparator.comparing(s -> s.getSchema().getFullName())).distinct().flatMap(this::validate).distinct();
            return stream;
        }
        finally {
            this.validator = this.rules.getValidator(false);
        }
    }

    public Stream<ValidationException> analyseFiles(Scope scope, SchemaCatalogue schemaCatalogue) {
        if (scope == null) {
            return this.analyseFiles(schemaCatalogue);
        }
        this.validator = this.rules.getValidator(false);
        Map<String, Schema> useTypes = schemaCatalogue.getSchemas().entrySet().stream().filter(s -> ((SchemaMetadata)s.getValue()).getScope().equals((Object)scope)).collect(Collectors.toMap(Map.Entry::getKey, e -> ((SchemaMetadata)e.getValue()).getSchema()));
        return Stream.concat(schemaCatalogue.getUnmappedAvroFiles().stream().filter(s -> s.getScope().equals((Object)scope)).map(p -> {
            Schema.Parser parser = new Schema.Parser();
            parser.addTypes(useTypes);
            try {
                parser.parse(p.getPath().toFile());
                return null;
            }
            catch (Exception ex) {
                return new ValidationException("Cannot parse schema", ex);
            }
        }).filter(Objects::nonNull), schemaCatalogue.getSchemas().values().stream().flatMap(this::validate)).distinct();
    }

    public Stream<ValidationException> analyseFiles(SchemaCatalogue schemaCatalogue) {
        return Arrays.stream(Scope.values()).flatMap(scope -> this.analyseFiles((Scope)scope, schemaCatalogue));
    }

    public Stream<ValidationException> validate(Schema schema, Path path, Scope scope) {
        return this.validate(new SchemaMetadata(schema, scope, path));
    }

    public Stream<ValidationException> validate(SchemaMetadata schemaMetadata) {
        if (this.config.skipFile(schemaMetadata.getPath())) {
            return Stream.empty();
        }
        return (Stream)this.validator.apply(schemaMetadata);
    }

    public static String format(Stream<ValidationException> exceptionStream) {
        return exceptionStream.map(ex -> "Validation FAILED:\n" + ex.getMessage() + "\n\n").collect(Collectors.joining());
    }

    public static boolean isAvscFile(Path file) {
        return ValidationHelper.matchesExtension(file, AVRO_EXTENSION);
    }

    public static String getPath(Path path) {
        return path.toString().substring(path.toString().indexOf("/RADAR-Schemas/"));
    }

    public SchemaMetadataRules getRules() {
        return this.rules;
    }

    public Map<String, Schema> getValidatedSchemas() {
        return ((RadarSchemaRules)this.rules.getSchemaRules()).getSchemaStore();
    }
}

