/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.schema.specification.stream;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.radarbase.config.AvroTopicConfig;
import org.radarbase.schema.SchemaCatalogue;
import org.radarbase.schema.specification.DataTopic;
import org.radarbase.schema.util.SchemaUtils;
import org.radarbase.stream.TimeWindowMetadata;
import org.radarbase.topic.AvroTopic;
import org.radarcns.kafka.AggregateKey;
import org.radarcns.kafka.ObservationKey;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class StreamDataTopic
extends DataTopic {
    @JsonProperty
    private boolean windowed = false;
    @JsonProperty(value="input_topics")
    private final List<String> inputTopics = new ArrayList<String>();
    @JsonProperty(value="topic_base")
    private String topicBase;

    @JsonSetter
    private void setWindowed(boolean windowed) {
        this.windowed = windowed;
        if (windowed && (this.getKeySchema() == null || this.getKeySchema().equals(ObservationKey.class.getName()))) {
            this.setKeySchema(AggregateKey.class.getName());
        }
    }

    @JsonSetter(value="input_topic")
    private void setInputTopic(String inputTopic) {
        if (this.topicBase == null) {
            this.topicBase = inputTopic;
        }
        if (!this.inputTopics.isEmpty()) {
            throw new IllegalStateException("Input topics already set");
        }
        this.inputTopics.add(inputTopic);
    }

    public String getTopic() {
        if (this.windowed) {
            return this.topicBase + "_<time-frame>";
        }
        if (super.getTopic() == null) {
            return this.topicBase + "_output";
        }
        return super.getTopic();
    }

    public boolean isWindowed() {
        return this.windowed;
    }

    public List<String> getInputTopics() {
        return this.inputTopics;
    }

    @JsonSetter
    private void setInputTopics(Collection<? extends String> topics) {
        if (!this.inputTopics.isEmpty()) {
            throw new IllegalStateException("Input topics already set");
        }
        this.inputTopics.addAll(topics);
    }

    public String getTopicBase() {
        return this.topicBase;
    }

    @Override
    @JsonIgnore
    public Stream<String> getTopicNames() {
        if (this.windowed) {
            return Arrays.stream(TimeWindowMetadata.values()).map(label -> label.getTopicLabel(this.topicBase));
        }
        Object currentTopic = this.getTopic();
        if (currentTopic == null) {
            currentTopic = this.topicBase + "_output";
            this.setTopic((String)currentTopic);
        }
        return Stream.of(currentTopic);
    }

    @Override
    @JsonIgnore
    public Stream<AvroTopic<?, ?>> getTopics(SchemaCatalogue schemaCatalogue) {
        return this.getTopicNames().flatMap(SchemaUtils.applyOrEmpty(topic -> {
            AvroTopicConfig config = new AvroTopicConfig();
            config.setTopic(topic);
            config.setKeySchema(this.getKeySchema());
            config.setValueSchema(this.getValueSchema());
            return Stream.of(schemaCatalogue.getGenericAvroTopic(config));
        }));
    }

    @JsonIgnore
    public Stream<String> getTimedTopicNames() {
        if (this.windowed) {
            return this.getTopicNames();
        }
        return Stream.empty();
    }

    @Override
    protected void propertiesMap(Map<String, Object> properties, boolean reduce) {
        properties.put("input_topics", this.inputTopics);
        properties.put("windowed", this.windowed);
        if (!reduce) {
            properties.put("topic_base", this.topicBase);
        }
    }
}

