/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.schema.specification;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.radarbase.schema.SchemaCatalogue;
import org.radarbase.schema.Scope;
import org.radarbase.schema.specification.DataProducer;
import org.radarbase.schema.specification.active.ActiveSource;
import org.radarbase.schema.specification.connector.ConnectorSource;
import org.radarbase.schema.specification.monitor.MonitorSource;
import org.radarbase.schema.specification.passive.PassiveSource;
import org.radarbase.schema.specification.push.PushSource;
import org.radarbase.schema.specification.stream.StreamGroup;
import org.radarbase.topic.AvroTopic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceCatalogue {
    private static final Logger logger = LoggerFactory.getLogger(SourceCatalogue.class);
    public static final Path BASE_PATH = Paths.get("../..", new String[0]).toAbsolutePath().normalize();
    private final Map<String, ActiveSource<?>> activeSources;
    private final Map<String, MonitorSource> monitorSources;
    private final Map<String, PassiveSource> passiveSources;
    private final Map<String, ConnectorSource> connectorSources;
    private final Map<String, StreamGroup> streamGroups;
    private final Map<String, PushSource> pushSources;
    private final Set<DataProducer<?>> sources;
    private final SchemaCatalogue schemaCatalogue;

    SourceCatalogue(SchemaCatalogue schemaCatalogue, Map<String, ActiveSource<?>> activeSources, Map<String, MonitorSource> monitorSources, Map<String, PassiveSource> passiveSources, Map<String, StreamGroup> streamGroups, Map<String, ConnectorSource> connectorSources, Map<String, PushSource> pushSources) {
        this.schemaCatalogue = schemaCatalogue;
        this.activeSources = activeSources;
        this.monitorSources = monitorSources;
        this.passiveSources = passiveSources;
        this.streamGroups = streamGroups;
        this.connectorSources = connectorSources;
        this.pushSources = pushSources;
        this.sources = new HashSet();
        this.sources.addAll(activeSources.values());
        this.sources.addAll(monitorSources.values());
        this.sources.addAll(passiveSources.values());
        this.sources.addAll(streamGroups.values());
        this.sources.addAll(connectorSources.values());
        this.sources.addAll(pushSources.values());
    }

    public static SourceCatalogue load(Path root) throws IOException {
        Path specRoot = root.resolve("specifications");
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        mapper.setPropertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE);
        mapper.setVisibility(mapper.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withIsGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.NONE));
        SchemaCatalogue schemaCatalogue = new SchemaCatalogue(root);
        return new SourceCatalogue(schemaCatalogue, SourceCatalogue.initSources(mapper.readerFor(ActiveSource.class), specRoot, Scope.ACTIVE), SourceCatalogue.initSources(mapper.readerFor(MonitorSource.class), specRoot, Scope.MONITOR), SourceCatalogue.initSources(mapper.readerFor(PassiveSource.class), specRoot, Scope.PASSIVE), SourceCatalogue.initSources(mapper.readerFor(StreamGroup.class), specRoot, Scope.STREAM), SourceCatalogue.initSources(mapper.readerFor(ConnectorSource.class), specRoot, Scope.CONNECTOR), SourceCatalogue.initSources(mapper.readerFor(PushSource.class), specRoot, Scope.PUSH));
    }

    private static <T> Map<String, T> initSources(ObjectReader reader, Path root, Scope scope) throws IOException {
        Path baseFolder = scope.getPath(root);
        if (baseFolder == null) {
            logger.info(scope + " sources folder not present");
            return Map.of();
        }
        return Files.walk(baseFolder, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(f -> {
            String filename = f.getFileName().toString();
            int extensionIndex = filename.lastIndexOf(46);
            if (extensionIndex != -1) {
                filename = filename.substring(0, extensionIndex);
            }
            try {
                return Map.entry(filename.toUpperCase(Locale.ENGLISH), reader.readValue(f.toFile()));
            }
            catch (IOException ex) {
                logger.error("Failed to load configuration {}", f, (Object)ex);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public SchemaCatalogue getSchemaCatalogue() {
        return this.schemaCatalogue;
    }

    public Map<String, ActiveSource<?>> getActiveSources() {
        return this.activeSources;
    }

    public ActiveSource<?> getActiveSource(String topic) {
        return this.activeSources.get(topic);
    }

    public Map<String, MonitorSource> getMonitorSources() {
        return this.monitorSources;
    }

    public MonitorSource getMonitorSource(String topic) {
        return this.monitorSources.get(topic);
    }

    public Map<String, PassiveSource> getPassiveSources() {
        return this.passiveSources;
    }

    public PassiveSource getPassiveSource(String topic) {
        return this.passiveSources.get(topic);
    }

    public Map<String, StreamGroup> getStreamGroups() {
        return this.streamGroups;
    }

    public Set<DataProducer<?>> getSources() {
        return this.sources;
    }

    public Stream<String> getTopicNames() {
        return this.sources.stream().flatMap(DataProducer::getTopicNames);
    }

    public Map<String, ConnectorSource> getConnectorSources() {
        return this.connectorSources;
    }

    public Map<String, PushSource> getPushSources() {
        return this.pushSources;
    }

    public Stream<AvroTopic<?, ?>> getTopics() {
        return this.sources.stream().flatMap(s -> s.getTopics(this.schemaCatalogue));
    }
}

