/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.schema.specification;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.radarbase.schema.SchemaCatalogue;
import org.radarbase.schema.Scope;
import org.radarbase.schema.specification.DataTopic;
import org.radarbase.schema.util.SchemaUtils;
import org.radarbase.topic.AvroTopic;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public abstract class DataProducer<T extends DataTopic> {
    @JsonProperty
    @NotBlank
    private String name;
    @JsonProperty
    @NotBlank
    private String doc;
    @JsonProperty
    private Map<String, String> properties;
    @JsonProperty
    private List<String> labels;
    @JsonProperty(value="register_schema")
    protected boolean registerSchema = true;

    public String getName() {
        return this.name;
    }

    public String getDoc() {
        return this.doc;
    }

    @NotNull
    public abstract List<T> getData();

    @NotNull
    public abstract Scope getScope();

    public List<String> getLabels() {
        return this.labels;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    @JsonIgnore
    public Stream<String> getTopicNames() {
        return this.getData().stream().flatMap(DataTopic::getTopicNames);
    }

    @JsonIgnore
    public Stream<AvroTopic<?, ?>> getTopics(SchemaCatalogue schemaCatalogue) {
        return this.getData().stream().flatMap(SchemaUtils.applyOrEmpty(t -> t.getTopics(schemaCatalogue)));
    }

    public boolean doRegisterSchema() {
        return this.registerSchema;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataProducer producer = (DataProducer)o;
        return Objects.equals(this.name, producer.name) && Objects.equals(this.doc, producer.doc) && Objects.equals(this.getData(), producer.getData());
    }

    public int hashCode() {
        return Objects.hash(this.name, this.doc, this.getData());
    }
}

