/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.schema.validation.rules;

import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.radarbase.schema.validation.rules.SchemaMetadata;
import org.radarbase.schema.validation.rules.SchemaRules;
import org.radarbase.schema.validation.rules.Validator;

public interface SchemaMetadataRules {
    public SchemaRules getSchemaRules();

    public Validator<SchemaMetadata> validateSchemaLocation();

    default public Validator<SchemaMetadata> getValidator(boolean validateScopeSpecific) {
        return metadata -> {
            SchemaRules schemaRules = this.getSchemaRules();
            Validator<SchemaMetadata> validator = this.validateSchemaLocation();
            if (metadata.getSchema().getType().equals((Object)Schema.Type.ENUM)) {
                validator = validator.and(this.schema(schemaRules.validateEnum()));
            } else if (validateScopeSpecific) {
                switch (metadata.getScope()) {
                    case ACTIVE: {
                        validator = validator.and(this.schema(schemaRules.validateActiveSource()));
                        break;
                    }
                    case MONITOR: {
                        validator = validator.and(this.schema(schemaRules.validateMonitor()));
                        break;
                    }
                    case PASSIVE: {
                        validator = validator.and(this.schema(schemaRules.validatePassive()));
                        break;
                    }
                    default: {
                        validator = validator.and(this.schema(schemaRules.validateRecord()));
                        break;
                    }
                }
            } else {
                validator = validator.and(this.schema(schemaRules.validateRecord()));
            }
            return (Stream)validator.apply((SchemaMetadata)metadata);
        };
    }

    default public Validator<SchemaMetadata> schema(Validator<Schema> validator) {
        return metadata -> (Stream)validator.apply(metadata.getSchema());
    }

    default public Function<SchemaMetadata, String> message(String text) {
        return metadata -> "Schema " + metadata.getSchema().getFullName() + " at " + metadata.getPath() + " is invalid. " + text;
    }
}

