/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.schema.validation;

import java.nio.file.Path;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.radarbase.schema.Scope;
import org.radarbase.schema.util.SchemaUtils;

public final class ValidationHelper {
    public static final String COMMONS_PATH = "commons";
    public static final String SPECIFICATIONS_PATH = "specifications";
    private static final Pattern TOPIC_PATTERN = Pattern.compile("[A-Za-z][a-z0-9-]*(_[A-Za-z0-9-]+)*");

    private ValidationHelper() {
    }

    public static String getNamespace(Path root, Path schemaPath, Scope scope) {
        Path rootPath = scope.getPath(root.resolve(COMMONS_PATH));
        if (rootPath == null) {
            throw new IllegalArgumentException("Scope " + scope + " does not have a commons path");
        }
        Path relativePath = rootPath.relativize(schemaPath);
        StringBuilder builder = new StringBuilder(50);
        builder.append(SchemaUtils.getProjectGroup()).append('.').append(scope.getLower());
        for (int i = 0; i < relativePath.getNameCount() - 1; ++i) {
            builder.append('.').append(relativePath.getName(i));
        }
        return builder.toString();
    }

    public static String getRecordName(Path path) {
        Objects.requireNonNull(path);
        return SchemaUtils.snakeToCamelCase(path.getFileName().toString());
    }

    public static boolean isValidTopic(String topicName) {
        return topicName != null && TOPIC_PATTERN.matcher(topicName).matches();
    }

    public static boolean matchesExtension(Path file, String extension) {
        return file.toString().toLowerCase(Locale.ENGLISH).endsWith("." + extension.toLowerCase(Locale.ENGLISH));
    }

    public static boolean equalsFileName(String str, Path file, String extension) {
        return ValidationHelper.equalsFileName(file, extension).test(str);
    }

    public static Predicate<String> equalsFileName(Path file, String extension) {
        return str -> {
            String fileName = file.getFileName().toString();
            if (fileName.endsWith(extension)) {
                fileName = fileName.substring(0, fileName.length() - extension.length());
            }
            return str.equalsIgnoreCase(fileName);
        };
    }

    public static enum Package {
        AGGREGATOR(".kafka.aggregator"),
        BIOVOTION(".passive.biovotion"),
        EMPATICA(".passive.empatica"),
        KAFKA_KEY(".kafka.key"),
        MONITOR(".monitor"),
        PEBBLE(".passive.pebble"),
        QUESTIONNAIRE(".active.questionnaire");

        private final String name;

        private Package(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

