/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.schema.validation;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.radarbase.schema.Scope;
import org.radarbase.schema.validation.ValidationHelper;
import org.radarbase.schema.validation.config.ExcludeConfig;

public class SpecificationsValidator {
    public static final String YML_EXTENSION = "yml";
    private final ExcludeConfig config;
    private final Path root;

    public SpecificationsValidator(Path root, ExcludeConfig config) {
        this.root = root;
        this.config = config;
    }

    public boolean specificationsAreYmlFiles(Scope scope) throws IOException {
        return Files.walk(scope.getPath(this.root.resolve("specifications")), new FileVisitOption[0]).filter(p -> Files.isRegularFile(p, new LinkOption[0]) && !this.config.skipFile((Path)p)).allMatch(SpecificationsValidator::isYmlFile);
    }

    private static boolean isYmlFile(Path path) {
        return ValidationHelper.matchesExtension(path, YML_EXTENSION);
    }
}

