/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.schema.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SchemaUtils {
    private static final Logger logger = LoggerFactory.getLogger(SchemaUtils.class);
    private static final String GRADLE_PROPERTIES = "exchange.properties";
    private static final String GROUP_PROPERTY = "project.group";
    private static String projectGroup;

    private SchemaUtils() {
    }

    public static synchronized String getProjectGroup() {
        if (projectGroup == null) {
            Properties prop = new Properties();
            ClassLoader loader = ClassLoader.getSystemClassLoader();
            try (InputStream in = loader.getResourceAsStream(GRADLE_PROPERTIES);){
                if (in == null) {
                    projectGroup = "org.radarcns";
                    logger.debug("Project group not specified. Using \"{}\".", (Object)projectGroup);
                } else {
                    prop.load(in);
                    projectGroup = prop.getProperty(GROUP_PROPERTY);
                    if (projectGroup == null) {
                        projectGroup = "org.radarcns";
                        logger.debug("Project group not specified. Using \"{}\".", (Object)projectGroup);
                    }
                }
            }
            catch (IOException exc) {
                throw new IllegalStateException("project.group cannot be extracted from exchange.properties", exc);
            }
        }
        return projectGroup;
    }

    public static String expandClass(String classShorthand) {
        if (classShorthand == null || classShorthand.isEmpty()) {
            return null;
        }
        if (classShorthand.charAt(0) == '.') {
            return SchemaUtils.getProjectGroup() + classShorthand;
        }
        return classShorthand;
    }

    public static String snakeToCamelCase(String value) {
        char[] fileName = value.toCharArray();
        StringBuilder builder = new StringBuilder(fileName.length);
        boolean nextIsUpperCase = true;
        block4: for (char c : fileName) {
            switch (c) {
                case '_': {
                    nextIsUpperCase = true;
                    continue block4;
                }
                case '.': {
                    return builder.toString();
                }
                default: {
                    if (nextIsUpperCase) {
                        builder.append(String.valueOf(c).toUpperCase(Locale.ENGLISH));
                        nextIsUpperCase = false;
                        continue block4;
                    }
                    builder.append(c);
                }
            }
        }
        return builder.toString();
    }

    public static <T, R> Function<T, Stream<R>> applyOrEmpty(ThrowingFunction<T, Stream<R>> func) {
        return t -> {
            try {
                return (Stream)func.apply(t);
            }
            catch (Exception ex) {
                logger.error("Failed to apply function, returning empty.", (Throwable)ex);
                return Stream.empty();
            }
        };
    }

    public static <T, R> Function<T, Stream<R>> applyOrIllegalException(ThrowingFunction<T, Stream<R>> func) {
        return t -> {
            try {
                return (Stream)func.apply(t);
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex.getMessage(), ex);
            }
        };
    }

    @FunctionalInterface
    public static interface ThrowingFunction<T, R> {
        public R apply(T var1) throws Exception;
    }
}

