/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.utils;

import org.quattor.pan.exceptions.EvaluationException;

public class EscapeUtils {
    private EscapeUtils() {
    }

    public static String escape(String s) {
        StringBuilder sb = new StringBuilder();
        if ("".equals(s)) {
            sb.append("_");
        } else {
            for (int i = 0; i < s.length(); ++i) {
                int c = s.codePointAt(i);
                if (c >= 0 && c < 256) {
                    int digit = Character.digit(c, 36);
                    if (digit > 9 || i != 0 && digit >= 0) {
                        sb.appendCodePoint(c);
                        continue;
                    }
                    sb.append("_");
                    if (c < 16) {
                        sb.append("0");
                    }
                    sb.append(Integer.toHexString(c));
                    continue;
                }
                throw new EvaluationException("string contains character which cannot be escaped: " + Integer.toHexString(c));
            }
        }
        return sb.toString();
    }

    public static String unescape(String s) {
        StringBuilder sb = new StringBuilder();
        if (!"_".equals(s)) {
            int underscore = "_".codePointAt(0);
            for (int i = 0; i < s.length(); ++i) {
                int c = s.codePointAt(i);
                if (c != underscore) {
                    sb.appendCodePoint(c);
                    continue;
                }
                if (i + 2 < s.length()) {
                    String hex = null;
                    try {
                        hex = s.substring(i + 1, i + 3);
                        sb.appendCodePoint(Integer.parseInt(hex, 16));
                        i += 2;
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        throw new EvaluationException("string contains invalid escape sequence: " + hex);
                    }
                }
                throw new EvaluationException("string contains incomplete escape sequence");
            }
        }
        return sb.toString();
    }
}

