/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.type;

import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.StringProperty;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.exceptions.ValidationException;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;
import org.quattor.pan.type.BaseType;
import org.quattor.pan.type.CompositeType;
import org.quattor.pan.utils.Path;

public class LinkType
extends CompositeType {
    public LinkType(String source, SourceRange sourceRange, BaseType baseType) {
        super(source, sourceRange, baseType, null);
    }

    public Element findDefault(Context context) {
        return null;
    }

    public Element setDefaults(Context context, Element self) throws EvaluationException {
        try {
            StringProperty link = (StringProperty)self;
            try {
                Path path = new Path(link.getValue());
                Element linkedElement = context.getElement(path);
                Element linkedReplacement = null;
                if (linkedElement != null) {
                    linkedReplacement = this.baseType.setDefaults(context, linkedElement);
                }
                if (linkedReplacement != null) {
                    context.putElement(path, linkedReplacement);
                }
            }
            catch (SyntaxException consumed) {
            }
            catch (EvaluationException consumed) {}
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return null;
    }

    public void validate(Context context, Element self) throws ValidationException {
        try {
            StringProperty link = (StringProperty)self;
            Path path = null;
            try {
                path = new Path(link.getValue());
            }
            catch (SyntaxException se) {
                throw ValidationException.create("MSG_INVALID_LINK_PATH", link.getValue());
            }
            Element linkedElement = null;
            try {
                linkedElement = context.getElement(path);
                if (linkedElement == null) {
                    throw ValidationException.create("MSG_NONEXISTANT_LINK_ELEMENT", path);
                }
            }
            catch (EvaluationException ee) {
                throw ValidationException.create("MSG_PATH_EVAL_ERROR", path, ee.getSimpleMessage());
            }
            try {
                this.baseType.validate(context, linkedElement);
            }
            catch (ValidationException ve) {
                ValidationException envelope = ValidationException.create("MSG_LINK_ELEMENT_FAILED_VALIDATION", path);
                envelope.initCause(ve);
                throw envelope;
            }
        }
        catch (ClassCastException cce) {
            throw ValidationException.create("MSG_CONFLICTING_TYPES", "link", self.getTypeAsString());
        }
    }

    public String toString() {
        return this.baseType.toString() + "*";
    }
}

