/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.template;

import java.util.HashMap;
import java.util.Map;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.template.SourceRange;
import org.quattor.pan.template.Template;
import org.quattor.pan.type.BaseType;
import org.quattor.pan.type.FullType;
import org.quattor.pan.utils.MessageUtils;

public class TypeMap {
    private final Map<String, FullType> types = new HashMap<String, FullType>();

    public TypeMap() {
        Map<String, FullType> builtins = BaseType.getBuiltinTypes();
        for (Map.Entry<String, FullType> entry : builtins.entrySet()) {
            this.put(entry.getKey(), entry.getValue(), null, null);
        }
    }

    public FullType get(String name) {
        return this.types.get(name);
    }

    public void put(String name, FullType fullType, Template template, SourceRange sourceRange) throws EvaluationException {
        assert (name != null);
        assert (fullType != null);
        fullType.verifySubtypesDefined(this);
        FullType previous = this.types.put(name, fullType);
        if (previous != null) {
            String msg = MessageUtils.format("MSG_DUPLICATE_TYPE", name, previous.getSource(), previous.getSourceRange());
            throw new EvaluationException(msg);
        }
    }
}

