/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.statement;

import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.statement.Statement;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;
import org.quattor.pan.type.FullType;
import org.quattor.pan.utils.Path;

public class BindStatement
extends Statement {
    private final Path path;
    private final FullType fullType;

    public BindStatement(SourceRange sourceRange, Path path, FullType fullType) throws SyntaxException {
        super(sourceRange);
        assert (path != null);
        assert (fullType != null);
        if (!path.isAbsolute()) {
            throw SyntaxException.create(sourceRange, "MSG_ABSOLUTE_PATH_ONLY_FOR_BIND", path);
        }
        this.path = path;
        this.fullType = fullType;
    }

    public void execute(Context context) {
        assert (context != null);
        context.setBinding(this.path, this.fullType, context.getCurrentTemplate(), this.getSourceRange());
    }

    public String toString() {
        return "BIND: " + this.path + ", " + this.fullType;
    }
}

