/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.repository;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum SourceType {
    PAN(false, ".pan"),
    PANX(false, ".panx"),
    TPL(false, ".tpl"),
    TEXT(false, ""),
    ABSENT_SOURCE(true, ""),
    ABSENT_TEXT(true, "");

    private boolean absent;
    private String extension;
    private static final List<String> extensions;

    private SourceType(boolean absent, String extension) {
        this.absent = absent;
        this.extension = extension;
    }

    public boolean isSource() {
        return !"".equals(this.extension);
    }

    public boolean isAbsent() {
        return this.absent;
    }

    public String getExtension() {
        return this.extension;
    }

    public static List<String> getExtensions() {
        return extensions;
    }

    public static boolean hasSourceFileExtension(String filename) {
        for (String extension : extensions) {
            if (!filename.endsWith(extension)) continue;
            return true;
        }
        return false;
    }

    static {
        ArrayList<String> values = new ArrayList<String>();
        for (SourceType type : SourceType.values()) {
            if (!type.isSource()) continue;
            values.add(type.getExtension());
        }
        values.trimToSize();
        extensions = Collections.unmodifiableList(values);
    }
}

