/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.repository;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import net.jcip.annotations.Immutable;
import org.quattor.pan.exceptions.CompilerError;
import org.quattor.pan.repository.SourceType;
import org.quattor.pan.template.Template;
import org.quattor.pan.utils.MessageUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class SourceFile
implements Comparable<SourceFile> {
    private final String name;
    private final SourceType type;
    private final File location;
    private final File path;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SourceFile(String name, boolean isSource, File path) throws IllegalArgumentException {
        this.name = name;
        this.path = path;
        if (isSource) {
            if (path == null) {
                this.type = SourceType.ABSENT_SOURCE;
            } else {
                String extension = this.getFileExtension(path);
                if (".tpl".equals(extension)) {
                    this.type = SourceType.TPL;
                } else if (".pan".equals(extension)) {
                    this.type = SourceType.PAN;
                } else {
                    if (!".panx".equals(extension)) throw new IllegalArgumentException(MessageUtils.format("MSG_INVALID_TPL_NAME", name));
                    this.type = SourceType.PANX;
                }
            }
        } else {
            this.type = path != null ? SourceType.TEXT : SourceType.ABSENT_TEXT;
        }
        this.validateFields(name, this.type, path);
        this.location = SourceFile.weakTemplateNameVerification(name, this.type, path);
    }

    public String getName() {
        return this.name;
    }

    public SourceType getType() {
        return this.type;
    }

    public File getLocation() {
        return this.location;
    }

    public File getPath() {
        return this.path;
    }

    public boolean isAbsent() {
        return this.type.isAbsent();
    }

    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.path);
    }

    public Reader getReader() throws IOException {
        return new InputStreamReader(this.getInputStream(), "UTF-8");
    }

    public int hashCode() {
        int hc = this.name.hashCode() ^ this.type.hashCode();
        if (this.path != null) {
            hc ^= this.path.hashCode();
        }
        return hc;
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof SourceFile) {
            SourceFile s = (SourceFile)o;
            return this.compareTo(s) == 0;
        }
        return false;
    }

    @Override
    public int compareTo(SourceFile o) {
        if (o == null) {
            throw new NullPointerException();
        }
        int value = this.name.compareTo(o.name);
        if (value != 0) {
            return value;
        }
        value = this.type.compareTo(o.type);
        if (value != 0) {
            return value;
        }
        if (this.path != null && o.path != null) {
            value = this.path.compareTo(o.path);
            return value;
        }
        if (this.path == null && o.path == null) {
            return 0;
        }
        if (this.path == null) {
            return -1;
        }
        if (o.path == null) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        String uri = this.location != null ? this.location.toURI().toASCIIString() : "";
        return String.format("%s %s %s", new Object[]{this.name, this.type, uri});
    }

    private String getFileExtension(File path) {
        String s;
        int index;
        String extension = null;
        if (path != null && (index = (s = path.toString()).lastIndexOf(46)) >= 0) {
            extension = s.substring(index);
        }
        return extension;
    }

    private void validateFields(String name, SourceType type, File path) throws CompilerError {
        if (name == null || type == null) {
            throw CompilerError.create("MSG_SRC_FILE_NAME_OR_TYPE_IS_NULL", new Object[0]);
        }
        if (type.isAbsent() && path != null) {
            throw CompilerError.create("MSG_ABSOLUTE_PATH_REQ", new Object[0]);
        }
        if (path != null && !path.isAbsolute()) {
            throw CompilerError.create("MSG_ABSENT_FILE_MUST_HAVE_NULL_PATH", new Object[0]);
        }
        if (!Template.isValidTemplateName(name)) {
            throw new IllegalArgumentException(MessageUtils.format("MSG_INVALID_TPL_NAME", name));
        }
    }

    private static File weakTemplateNameVerification(String name, SourceType type, File source) throws IllegalArgumentException {
        File location = null;
        if (source != null) {
            StringBuilder sb = new StringBuilder("/");
            sb.append(name);
            sb.append(type.getExtension());
            String ending = sb.toString();
            String uri = source.toURI().toString();
            if (!uri.endsWith(ending)) {
                throw new IllegalArgumentException(MessageUtils.format("MSG_MISNAMED_TPL", name));
            }
            try {
                location = new File(new URI(uri.substring(0, uri.lastIndexOf(ending))));
            }
            catch (URISyntaxException consumed) {
                // empty catch block
            }
        }
        return location;
    }
}

