/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml.operators;

import org.quattor.pan.dml.AbstractOperation;
import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.BooleanProperty;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;
import org.quattor.pan.utils.MessageUtils;

public final class LogicalOr
extends AbstractOperation {
    private LogicalOr(SourceRange sourceRange, Operation ... operations) {
        super(sourceRange, operations);
        assert (operations.length == 2);
    }

    public static Operation newOperation(SourceRange sourceRange, Operation ... ops) throws SyntaxException {
        BooleanProperty a;
        assert (ops.length == 2);
        Operation result = null;
        if (ops[0] instanceof Element) {
            try {
                a = (BooleanProperty)ops[0];
                if (a.getValue().booleanValue()) {
                    result = BooleanProperty.TRUE;
                }
            }
            catch (ClassCastException cce) {
                throw SyntaxException.create(sourceRange, "MSG_INVALID_FIRST_ARG_L_OR", new Object[0]);
            }
        }
        if (result == null && ops[1] instanceof Element && !(ops[1] instanceof BooleanProperty)) {
            throw SyntaxException.create(sourceRange, "MSG_INVALID_SECOND_ARG_L_OR", new Object[0]);
        }
        if (result == null && ops[0] instanceof Element && ops[1] instanceof Element) {
            try {
                a = (BooleanProperty)ops[0];
                BooleanProperty b = (BooleanProperty)ops[1];
                boolean r = a.getValue() != false || b.getValue() != false;
                result = BooleanProperty.getInstance(r);
            }
            catch (ClassCastException cce) {
                throw SyntaxException.create(sourceRange, "MSG_INVALID_ARGS_L_OR", new Object[0]);
            }
        }
        if (result == null) {
            result = new LogicalOr(sourceRange, ops);
        }
        return result;
    }

    public Element execute(Context context) {
        BooleanProperty a = null;
        try {
            a = (BooleanProperty)this.ops[0].execute(context);
        }
        catch (ClassCastException cce) {
            throw new EvaluationException(MessageUtils.format("MSG_INVALID_FIRST_ARG_L_OR", new Object[0]), this.sourceRange);
        }
        if (a.getValue().booleanValue()) {
            return a;
        }
        BooleanProperty b = null;
        try {
            b = (BooleanProperty)this.ops[1].execute(context);
        }
        catch (ClassCastException cce) {
            throw new EvaluationException(MessageUtils.format("MSG_INVALID_SECOND_ARG_L_OR", new Object[0]), this.sourceRange);
        }
        return b;
    }
}

